/**
 * Description: ReportChannelWS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2017-07-17 上午 10:14:16
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-07-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.ReportChannelListRequest;
import com.house365.ws.beans.request.ReportChannelRequest;
import com.house365.ws.beans.response.ReportChannelListResponse;
import com.house365.ws.beans.response.ReportChannelResponse;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;


/**
 * ReportChannelWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-07-17
 * @see
 * @since 1.0
 */
public interface IReportChannel extends IService{

    /**
     * ReportChannel列表查询
     * 
     * @param request
     *            ReportChannel列表查询请求
     * @return ReportChannel列表查询响应
     */
    ReportChannelListResponse getReportChannelList(
        ReportChannelListRequest request
    );

    /**
     * 保存ReportChannel
     * 
     * @param request
     *            ReportChannel请求
     * @return 保存ReportChannel响应
     */
    ReportChannelResponse addReportChannel(ReportChannelRequest request);

    @Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = {Exception.class})
    ReportChannelResponse addReportChannels(ReportChannelRequest request, String[] departs);

    /**
     * 删除ReportChannel通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除ReportChannel响应
     */
    ReportChannelResponse deleteReportChannelById(Integer id);

    /**
     * 修改ReportChannel
     * 
     * @param request
     *            修改ReportChannel请求
     * @return 修改ReportChannel响应
     */
    ReportChannelResponse updateReportChannel(
        ReportChannelRequest request
    );

    ReportChannelResponse updateReportChannels(
        ReportChannelRequest request, String[] departs
    ) throws Exception;

    /**
     * 通过ID获取ReportChannel
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取ReportChannel响应
     */
    ReportChannelResponse getReportChannelById(Integer id);
}
