/**
 * Description: 客户信息WS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-15 下午 15:36:13
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.beans.entity.*;
import com.house365.rest.context.IService;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.beans.request.CustomerListRequest;
import com.house365.ws.beans.request.CustomerRequest;
import com.house365.ws.beans.request.MapListRequest;
import com.house365.ws.beans.response.CustomerListResponse;
import com.house365.ws.beans.response.CustomerResponse;
import com.house365.ws.beans.response.MapListResponse;

import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * 客户信息WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-15
 * @see
 * @since 1.0
 */
public interface ICustomer extends IService {

    /**
     * 客户信息列表查询
     *
     * @param request 客户信息列表查询请求
     * @return 客户信息列表查询响应
     */
    CustomerListResponse getCustomerList(CustomerListRequest request);

    /**
     * 客户信息列表查询
     *
     * @param request 客户信息列表查询请求
     * @return 客户信息列表查询响应
     */
    CustomerListResponse getCustomerManagementList(CustomerListRequest request);

    CustomerListResponse getPlatformCustomerList(CustomerListRequest request);

    CustomerListResponse getCustomerManagementList4Label(CustomerListRequest request);

    /**
     * 查询待回访的数据
     *
     * @param request
     * @return
     */
    CustomerListResponse getCustomerListFromOld(CustomerListRequest request);

    /**
     * 保存客户信息
     *
     * @param request 客户信息请求
     * @return 保存客户信息响应
     */
    CustomerResponse addCustomer(CustomerRequest request);

    /**
     * 保存客户信息新
     *
     * @param request  customer
     * @param userId   用户id
     * @param userName 用户名
     * @return
     */
    CustomerResponse addCustomerNew(CustomerRequest request, int userId, String userName);

    CustomerResponse setDeleteFlag(Integer id, int userId, String userName);

    /**
     * 修改客户信息
     *
     * @param request 修改客户信息请求
     * @return 修改客户信息响应
     */
    CustomerResponse updateCustomer(CustomerRequest request, int userId, String userName);

    CustomerResponse updateCustomerNew(CustomerRequest request, int userId, String userName);

    /**
     * 通过ID获取客户信息
     *
     * @param id 唯一标识
     * @return 通过ID获取客户信息响应
     */
    CustomerResponse getCustomerById(Integer id);

    House365RestResponse getSummary(String managerId);

    Map<String, Object> getNewSummary(Map<String, String> summaryParams);

    House365RestResponse getSummarySimple(String managerId);

    House365RestResponse getHotLineSummary(Integer managerId, String cityCode);

    House365RestResponse getSummaryIds(String summaryType, String managerId);

    House365RestResponse getSeaSummary(String cityCode);

    Integer getCustomersById(Map<String, Object> managerIdmap);

    void bindUser(String[] customerIds, String[] userIds, Integer operId, boolean isHandover, String type, String assignFrom) throws Exception;

    void transferUser(String[] customerIds, String[] userIds, Integer operId, String managerId, boolean isHandover, String type, String assignFrom, int count) throws Exception;

    void batch2Sea(String[] customerIds, Integer operId, String managerId, int count, String userName) throws Exception;

    /**
     * 平均派工
     *
     * @param customerIds 客户id
     * @param userId      用户id
     * @param operId      当前操作人id
     * @param userName    当前操作人姓名
     * @param type        操作类型
     * @throws Exception
     */
    void bindUser(String customerIds, String userId, Integer operId, String userName, int type) throws Exception;

    void bindCloudUser(String customerIds, String userId, Integer operId, String userName, int type) throws Exception;

    void bindProject(String projectId, String customerId, String creater) throws Exception;

    String bindTurnProject(String projectId, String customerId, int operId, String creater, String oldProjectId) throws Exception;

    void removeCustomer(Integer custmerId, Integer userId) throws Exception;

    /**
     * 批量转移客户到公海
     *
     * @param customerIds
     * @param userId
     * @throws Exception
     */
    void batchRemoveCustomer(String customerIds, Integer userId, String userName) throws Exception;

    void removeUserCustomer(Integer delUserId, Integer userId);

    String getCRMViewURL(String city, String phone);

    String getCRMCustomerURL(Integer customerId, String curid, String curname);

    String crmAddCallBack(Integer customerId);

    void abandonCustomer(String customerId, int userId, String oper, Integer callLogId);

    void abandonHotlineCustomer(String customerId, int userId, String oper, Integer callLogId);

    //获取最后评论记录，customerIds为逗号隔开，返回customerId和content
    House365RestResponse getLastestCallback(String customerIds);

    void updateSourceName(String oldName, String name);

    void updateManager(Integer managerId, String managerName);

    House365RestResponse checkCustomerPhone(Integer userId, String customerPhone, String sourceType, Integer platMangerId);

    House365RestResponse checkCustomerPhoneByCustomerIds(String userIds, String customerIds);

    Integer getTotalAbandon(CustomerListRequest request);

    Integer getTotalCall(CustomerListRequest totalCount);

    Integer getTotalCallOptimize(CustomerListRequest request);

    List<Map<String, Object>> getMarketInfo(CustomerListRequest request);

    void updatePeer(int customerId, int isPeer, Date returnRemindTime, int userId, String cityCode);

    List<CustomerEntity> queryByConditions(Map<String, Object> map);

    List<CustomerRemindEntity> queryByCondition(Map<String, Object> map);

    List<CustomerEntity> queryCustomers(Map<String, Object> map);

    void deleteTips(int id);

    void updateCustomerStar(int customerId, int starCustomer);

    void clearCustomerByManagerId(Map<String, Object> map, int userId, String userName);

    List<CustomerEntity> getCustomerIds(Integer id, String cityCode);

    List<CustomerCallbackLogEntity> getCallBackList(Map<String, Object> map);

    CustomerEntity getCustomerMerge(String phone, Integer id);

    CustomerEntity getCustomerMergeById(Integer oldCustomerId);

    CustomerEntity getMergeCustomerId(Map<String, Object> map);

    List<CustomerEntity> getCustomerMergeList(Map<String, Object> map);

    void saveCustomerMerge(CustomerEntity customerEntity);

    void updateCustomerMerge(CustomerEntity customerEntity);

    void updateCustomerMerge4AddCall(CustomerEntity customerEntity);

    void updateOldCustomers(String phone, Integer managerId, Integer operId);

    void deleteCustomerMergeById(Map<String, Object> idMap);

    void deleteSingleCustomer(CustomerEntity customerEntity);

    List<CustomerEntity> getDetailCustomers(String phone, Integer id);

    CustomerEntity queryById(int id);

    List<CustomerEntity> queryMergeByConditions(Map<String, Object> map);

    void updateSeaCustomerByPhone(CustomerEntity customerEntity, UserEntity userEntity);

    void saveLog(CustomerLogEntity entity);

    List<CustomerEntity> getSeaCustomerByPhone(CustomerEntity customerEntity, UserEntity userEntity);

    void update(Map<String, Object> map);

    List<CustomerEntity> queryForAddHot(Map<String, Object> map);

    void updateOldCustomerStar(int customerId, int starCustomer);

    int queryCount (Map<String, Object> map);

    MapListResponse successList(MapListRequest listRequest,UserEntity userEntity);

    Integer countCustomer(Map<String, Object> map);

    Integer countCustomer2(Map<String, Object> map);

    Integer countCustomer3(Map<String, Object> map);

    Integer countCustomer4(Map<String, Object> map);

    List<CustomerEntity> getAllCustomer(Map<String, Object> map);

    List<CustomerEntity> getAllCustomer2(Map<String, Object> map);

    List<CustomerEntity> getAllCustomer3(Map<String, Object> map);

    List<CustomerEntity> getAllCustomer4(Map<String, Object> map);

    MapListResponse seaList(MapListRequest listRequest,String type);

}
