/**
 * Description: CrmSourceWS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2017-12-09 下午 16:02:32
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-09   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.beans.entity.CrmSourceEntity;
import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CrmSourceListRequest;
import com.house365.ws.beans.request.CrmSourceRequest;
import com.house365.ws.beans.response.CrmSourceListResponse;
import com.house365.ws.beans.response.CrmSourceResponse;

import java.util.List;


/**
 * CrmSourceWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-09
 * @see
 * @since 1.0
 */
public interface ICrmSource extends IService{

    /**
     * CrmSource列表查询
     * 
     * @param request
     *            CrmSource列表查询请求
     * @return CrmSource列表查询响应
     */
    CrmSourceListResponse getCrmSourceList(
        CrmSourceListRequest request
    );

    /**
     * 保存CrmSource
     * 
     * @param request
     *            CrmSource请求
     * @return 保存CrmSource响应
     */
    CrmSourceResponse addCrmSource(CrmSourceRequest request);

    /**
     * 删除CrmSource通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除CrmSource响应
     */
    CrmSourceResponse deleteCrmSourceById(Integer id);

    /**
     * 修改CrmSource
     * 
     * @param request
     *            修改CrmSource请求
     * @return 修改CrmSource响应
     */
    CrmSourceResponse updateCrmSource(
        CrmSourceRequest request
    );

    /**
     * 通过ID获取CrmSource
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取CrmSource响应
     */
    CrmSourceResponse getCrmSourceById(Integer id);

    void refreshCrmConfig();

    CrmSourceListResponse getRushCrmSourceList(String cityCode);

    List<CrmSourceEntity> getListByCategory(String categoryId);
}
