window.onload = function () {
    var input = document.getElementById("upgteimg");
    var showui = document.getElementById("showui");
    var result;
    var dataArr = []; // 储存所选图片的结果(文件名和base64数据)
    var fd; //FormData方式发送请求
    var oSelect = document.getElementById("select");
    var oAdd = document.getElementById("add");
    var showinput = document.getElementById("showinput");
    var oSubmit = document.getElementById("submit");
    var oInput = document.getElementById("upgteimg");
    var lilength = showui.getElementsByTagName('li');

    function show() {
    }

    //监听展示图片的ul,执行判断是否隐藏
    showui.addEventListener("click", function () {
        show();
    });
    if (typeof FileReader === 'undefined') {
        alert("抱歉，你的浏览器不支持 FileReader");
        input.setAttribute('disabled', 'disabled');
    } else {
        input.addEventListener('change', readFile, false);
    }
    var files;

    function readFile() {
        fd = new FormData();
        var iLen = this.files.length;
        var allen = $(".imglist li").length;
        if (allen + iLen > 10) {
            return alert("只能选择10张图片");
        }
        var index = 0;
        var currentReViewImgIndex = 0;
        files = this.files;
        var sizeCount = 0;
        for (var i = 0; i < iLen; i++) {
            var size = this.files[i].size;
            if (size > 10485760) {
                return alert("单张图片大小不能超过10M");
            }
            sizeCount = sizeCount + size;
        }
        if (sizeCount > 52428800) {
            return alert("图片总大小不能超过50M");
        }
        for (var i = 0; i < iLen; i++) {
            if (!input['value'].match(/.jpg|.gif|.png|.jpeg|.bmp/i)) {　　 //判断上传文件格式
                return alert("上传的图片格式不正确，请重新选择");
            }
            var reader = new FileReader();
            reader.index = i;
            fd.append(i, this.files[i]);
            reader.readAsDataURL(this.files[i]); //转成base64
            reader.fileName = this.files[i].name;
            reader.onload = function (e) {
                var imgMsg = {
                    name: this.fileName, //获取文件名
                    base64: this.result //reader.readAsDataURL方法执行完后，base64数据储存在reader.result里
                };
                dataArr.push(imgMsg);
                for (var j = 0; j < dataArr.length; j++) {
                    currentReViewImgIndex = j
                }
                result = '<span class="delete"></span><img id="srcimgid' + currentReViewImgIndex + '" class="showimg" src="' + this.result + '" />';

                var li = document.createElement('li');
                li.innerHTML = result;
                showui.appendChild(li);
                var center = li.getElementsByTagName('span')[0];
                var src = li.getElementsByTagName('img')[0];
                show();
                center.onclick = function (num) {
                    return function () {
                        li.remove(); // 在页面中删除该图片元素
                        dataArr.splice(num, 1)
                    }
                }(currentReViewImgIndex);
                index++;
            }
        }
    }

    function send() {
        for (var j = 0; j < dataArr.length; j++) {
            var inputData;
            inputData = '<input name="" type="text" id="" value="' + dataArr[j].base64 + '" />';
            showinput.innerHTML += inputData;
        }
    }

    oSubmit.onclick = function () {
        var projectId = $("#projectId").val();
        var type = $("#type").val();
        if (!dataArr.length) {
            return alert('请先选择文件');
        }
        // send();
        var fileList = [];
        var nameList = [];
        for (var i = 0; i < dataArr.length; i++) {
            fileList[i] = dataArr[i].base64;
            nameList[i] = dataArr[i].name;
        }

        var url = ctx;
        url = url + '/project/addPic' + '/' + projectId + '/' + type;
        var data = {fileList: fileList, nameList: nameList};
        data = JSON.stringify(data);
        $.ajax({
            url: url,
            type: 'POST',
            contentType: 'application/json',
            data: data,
            dataType: 'json',
            cache: false,
            success: function (result) {
                if (result.status == 0) {
                    alert("新增成功！");
                    $(".uploadmain").css('display', 'none');
                    window.location.reload();
                } else {
                    alert(result.errorMessage);
                }
            }
        });
    };

    $('#showui').on('DOMNodeInserted', function () {
        show();
    })
};