<%@ page contentType="text/html;charset=UTF-8" %>
<%@ taglib prefix="house365" uri="http://www.house365.com/taglibs" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<c:set var="ctx" value="${pageContext.request.contextPath}"/>

<div class="row-fluid">
    <c:choose>
        <c:when test="${null != userRole && 0 < fn:length(userRole)}">
            <table class="table table-bordered table-advance table-hover">
                <thead>
                <tr>
                    <th>权限组编码</th>
                    <th>权限组名称</th>
                </tr>
                </thead>
                <tbody>
                <c:forEach items="${userRole}" var="userRoleMap">
                    <tr>
                        <td>${userRoleMap.roleCode}</td>
                        <td>${userRoleMap.roleName}</td>
                    </tr>
                </c:forEach>
                </tbody>
            </table>
        </c:when>
        <c:otherwise>
            <span>请分配权限组</span>
        </c:otherwise>
    </c:choose>
</div>