<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>项目列表</title>
</head>
<body>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li class="active"><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>项目列表</li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" name="filterForm" class="form-inline filterForm" action="${ctx}/project" method="get"
                  style="display: flex">
                <input type="text" name="search_LIKE_projectName" style="width: 9%"
                       value="${param['search_LIKE_projectName']}"
                       class="m-wrap small span2" placeholder="项目名称">

                <input type="text" class="datetime-picker span2 input-large" style="width: 9%"
                       name="search_GTE_createTimeStart"
                       date-language="zh-CN"
                       value="${param['search_GTE_createTimeStart']}" date-format="yyyy-mm-dd" date-minView="month"
                       placeholder="开始时间">
                <input type="text" class="datetime-picker span2 input-large" style="width: 9%"
                       name="search_LTE_createTimeEnd"
                       date-language="zh-CN"
                       value="${param['search_LTE_createTimeEnd']}" date-format="yyyy-mm-dd" date-minView="month"
                       placeholder="结束时间">

                <select name="search_EQ_status" class="form-inline chosen" data-placeholder="项目状态"
                        style="width: 150px;">
                    <option value="" <c:if test="${param['search_EQ_status']}">selected="selected"</c:if>></option>
                    <option value="1" <c:if test="${param['search_EQ_status'] eq 1 }">selected="selected"</c:if>>默认
                    </option>
                    <option value="2" <c:if test="${param['search_EQ_status'] eq 2 }">selected="selected"</c:if>>执行中
                    </option>
                    <option value="3" <c:if test="${param['search_EQ_status'] eq 3 }">selected="selected"</c:if>>办结
                    </option>
                    <option value="4" <c:if test="${param['search_EQ_status'] eq 4 }">selected="selected"</c:if>>
                        合同周期结束
                    </option>
                    <option value="5" <c:if test="${param['search_EQ_status'] eq 5 }">selected="selected"</c:if>>终止
                    </option>
                    <option value="6" <c:if test="${param['search_EQ_status'] eq 6 }">selected="selected"</c:if>>立项审核中
                    </option>
                    <option value="7" <c:if test="${param['search_EQ_status'] eq 7 }">selected="selected"</c:if>>删除
                    </option>
                </select>
                <select name="search_LIKE_business" class="form-inline chosen" data-placeholder="业务类型"
                        style="width: 150px;">
                    <option value="" <c:if test="${param['search_LIKE_business']}">selected="selected"</c:if>></option>
                    <option value="分销"
                            <c:if test="${param['search_LIKE_business'] eq '分销' }">selected="selected"</c:if>>分销
                    </option>
                    <option value="电商"
                            <c:if test="${param['search_LIKE_business'] eq '电商' }">selected="selected"</c:if>>电商
                    </option>
                    <option value="非我方收筹"
                            <c:if test="${param['search_LIKE_business'] eq '非我方收筹' }">selected="selected"</c:if>>非我方收筹
                    </option>
                </select>
                <select name="search_LIKE_showStatus" class="form-inline chosen" data-placeholder="状态"
                        style="width: 150px;">
                    <option value=""
                            <c:if test="${param['search_LIKE_showStatus']}">selected="selected"</c:if>></option>
                    <option value="0"
                            <c:if test="${param['search_LIKE_showStatus'] eq '0' }">selected="selected"</c:if>>关闭
                    </option>
                    <option value="1"
                            <c:if test="${param['search_LIKE_showStatus'] eq '1' }">selected="selected"</c:if>>开启
                    </option>
                </select>
                <div class="buttons pull-right" style="margin:3px 30px 0 0;margin-left: 20px;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
                <div style="margin-left: 20px">
                    <a class="btn" onclick="exportExcel();">导出项目</a>
                </div>
                <div style="margin-left: 20px;">
                    <a class="btn " onclick="loadData()">同步经管</a>
                </div>
            </form>
            <div class="buttons pull-right" style="margin-left:15px;">
                <a href="${ctx}/project?action=create" class="btn blue pull-right" target="_blank" title="新增项目">新增项目</a>
            </div>
            <div class="buttons pull-right" style="margin-left:15px;">
                <a class="btn " href="${ctx}/project/toJgAdd" target="_blank">经管新增</a>
            </div>
            <div class="buttons pull-right" style="float: left">
                <a href="javascript:void(0);" onclick="deleteById('')" class="btn blue pull-right"
                   title="批量指派驻场">指派驻场</a>
            </div>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th class="span1" width="50" style="text-align:center">
                <input id="memberCheckAll" type="checkbox" onclick="checkAll(this)"/>
            </th>
            <th class="span1" width="50">项目ID</th>
            <th class="span2" width="100">项目名称</th>
            <th class="span2" width="100">合同号</th>
            <th class="span2" width="100">项目状态</th>
            <th class="span2" width="100">业务类型</th>
            <th class="span2" width="100">关联楼盘</th>
            <th class="span2" width="100">物业类型</th>
            <th class="span2" width="100">驻场人员</th>
            <th class="span2" width="100">创建时间</th>
            <th class="span2" width="100">状态</th>
            <th class="span2" width="100">操作</th>
        </tr>
        </thead>
        <c:forEach items="${projects}" var="project">
            <tr>
                <td class="span1" style="text-align:center">
                    <input type="checkbox" name="memberCheck" value="${project.id}" onclick="checkMember(this)"/>
                </td>
                <td class="span1">
                    <a href="${ctx}/project/${project.id}" target="_blank"> <c:if
                            test="${null ne project.id && '' ne project.id}">
                        <c:out value="${project.id}"/>
                    </c:if>
                        <c:if test="${null eq project.id || '' eq project.id}">
                            &nbsp;
                        </c:if>
                    </a>
                </td>
                <td class="span2">
                    <c:if test="${null ne project.projectName && '' ne project.projectName}">
                        <c:out value="${project.projectName}"/>
                    </c:if>
                    <c:if test="${null eq project.projectName || '' eq project.projectName}">
                        &nbsp;
                    </c:if>
                </td>
                <td class="span2">
                    <c:if test="${null ne project.contractCode && '' ne project.contractCode}">
                        <c:out value="${project.contractCode}"/>
                    </c:if>
                    <c:if test="${null eq project.contractCode || '' eq project.contractCode}">
                        &nbsp;
                    </c:if>
                </td>
                <td class="span2">
                    <c:if test="${project.status eq 1}">默认</c:if>
                    <c:if test="${project.status eq 2}">执行中</c:if>
                    <c:if test="${project.status eq 3}">办结</c:if>
                    <c:if test="${project.status eq 4}">合同周期结束</c:if>
                    <c:if test="${project.status eq 5}">终止</c:if>
                    <c:if test="${project.status eq 6}">立项审核中</c:if>
                    <c:if test="${project.status eq 7}">删除</c:if>
                </td>
                <td class="span2">
                    <c:if test="${null ne project.business && '' ne project.business}">
                        <c:out value="${project.business}"/>
                    </c:if>
                    <c:if test="${null eq project.business || '' eq project.business}">
                        &nbsp;
                    </c:if>
                </td>
                <td class="span2">
                    <c:if test="${null ne project.buildingName && '' ne project.buildingName}">
                        <c:out value="${project.buildingName}"/>
                    </c:if>
                    <c:if test="${null eq project.buildingName || '' eq project.buildingName}">
                        &nbsp;
                    </c:if>
                </td>

                <td class="span2">
                    <c:if test="${null ne project.type && '' ne project.type}">
                        <c:out value="${project.type}"/>
                    </c:if>
                    <c:if test="${null eq project.type || '' eq project.type}">
                        &nbsp;
                    </c:if>
                </td>
                <td class="span2">
                    <c:if test="${null ne project.userName && '' ne project.userName}">
                        <c:out value="${project.userName}"/>
                    </c:if>
                    <c:if test="${null eq project.userName || '' eq project.userName}">
                        &nbsp;
                    </c:if>
                </td>
                <td class="span2">
                    <c:if test="${null ne project.createTime && '' ne project.createTime}">
                        <f:formatDate value='${project.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                    </c:if>
                    <c:if test="${null eq project.createTime || '' eq project.createTime}">
                        &nbsp;
                    </c:if>
                </td>
                <td class="span2">
                    <c:if test="${project.showStatus eq 0}">关闭</c:if>
                    <c:if test="${project.showStatus eq 1}">开启</c:if>
                </td>
                <td class="span2" style="width: 100px">
                    <div class="btn-group btn-group-sm">
                        <button type="button" class="btn btn-default"
                                onclick="window.open('${ctx}/project/attachments?projectId=${project.id}&number=1','_blank')">
                            项目图片
                        </button>&nbsp;
                        <button type="button" class="btn btn-default"
                                onclick="assignManager(${project.id})">指派驻场
                        </button>&nbsp;
                        <button type="button" class="btn btn-default"
                                onclick="window.open('${ctx}/customer/myRecordedCustomer?projectId=${project.id}','_blank')">
                            客户列表
                        </button>
                        <br>
                        <div style="margin-top: 5px;">
                            <button type="button" class="btn btn-default"
                                    onclick="window.open('${ctx}/project/${project.id}?action=edit','_blank')">编辑
                            </button>&nbsp;
                            <c:choose>
                                <c:when test="${project.showStatus == 0}">
                                    <button type="button" class="btn btn-default"
                                            onclick="window.location='${ctx}/project/open/${project.id}'">开启
                                    </button>
                                </c:when>
                                <c:otherwise>
                                    <button type="button" class="btn btn-default"
                                            onclick="window.location='${ctx}/project/close/${project.id}'">关闭
                                    </button>
                                </c:otherwise>
                            </c:choose>
                            &nbsp;
                        </div>
                    </div>
                </td>
            </tr>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>

<script type="text/javascript">
    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    });

    var projectIds;

    function assignManager(obj) {
        projectIds = obj;
        House365Util.createRemoteModal("指派驻场", "${ctx}/project/assignManager?projectId=" + obj, null, function () {
            var userIds = ",";
            $("#custom-headers").find("option:selected").each(function () {
                userIds = userIds + $(this).val() + ",";
            });
            $.ajax({
                url: '${ctx}/project/assign',
                data: {"userIds": userIds, "projectIds": projectIds},
                type: "GET",
                success: function () {
                    window.location.reload();
                }
            });
            return true;
        });
    }

    function assignSaler(obj) {
        projectIds = obj;
        House365Util.createRemoteModal("绑定直销人员", "${ctx}/project/assignSaler?projectId=" + obj, null, function () {
            var userIds = ",";
            $("#custom-headers").find("option:selected").each(function () {
                userIds = userIds + $(this).val() + ",";
            });
            $.ajax({
                url: '${ctx}/project/bindSaler',
                data: {"userIds": userIds, "projectIds": projectIds},
                type: "GET",
                success: function (data) {
                    if (data.result == '1') {
                        window.location.reload();
                    } else {
                        alert(data.msg);
                    }
                }
            });
            return true;
        });
    }

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    var deleteById = function (selectedId) {
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        if (selectedId == "") {
            for (var i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            House365Util.createModal("批量指派", "请至少选择一个项目!", function () {
            });
        }
        else {
            projectIds = selectedId;
            House365Util.createRemoteModal("指派驻场", "${ctx}/project/assignManager", null, function () {
                var userIds = ",";
                $("#custom-headers").find("option:selected").each(function () {
                    userIds = userIds + $(this).val() + ",";
                });
                $.ajax({
                    url: '${ctx}/project/assign',
                    data: {"userIds": userIds, "projectIds": projectIds},
                    type: "GET",
                    success: function () {
                        window.location.reload();
                    }
                });
                return true;
            });
        }

    };

    function exportExcel() {
        document.filterForm.action = "${ctx}/project/export";
        $('#filterForm').submit();
        document.filterForm.action = "${ctx}/project";
    }

    function loadData() {
        $.ajax({
            url: '${ctx}/project/updateJgData',
            data: {},
            type: "POST",
            success: function (result) {
                if (result.status == 0) {
                    alert("经管同步成功！");
                    window.location.reload();
                } else {
                    alert(result.errorMessage);
                }
            }
        });
    }

</script>
</body>
</html>
