<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>置业顾问</title>
    <style type="text/css">
        @keyframes fadeInOpacity {
            0% {
                opacity: 0
            }
            to {
                opacity: 1
            }
        }

        .table td.mangerItem {
            text-align: center;
        }

        :hover > * > .fbvd--wrapper {
            animation-name: fadeInOpacity;
            animation-duration: .3s;
            opacity: 1
        }

        .fbvd--wrapper {
            position: absolute;
            top: 10px;
            left: 10px;
            opacity: 0;
            text-align: center;
            margin: 0;
            z-index: 5
        }

        .fbvd--wrapper a {
            background: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz48IURPQ1RZUEUgc3ZnIFBVQkxJQyAiLS8vVzNDLy9EVEQgU1ZHIDEuMS8vRU4iICJodHRwOi8vd3d3LnczLm9yZy9HcmFwaGljcy9TVkcvMS4xL0RURC9zdmcxMS5kdGQiPjxzdmcgdmVyc2lvbj0iMS4xIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiI+PHBhdGggZmlsbD0iIzRiNGY1NiIgZD0iTTggMTUuNWw3LjUtNy41aC00LjV2LThoLTZ2OGgtNC41eiI+PC9wYXRoPjwvc3ZnPg==) no-repeat 3px 4.55px;
            background-color: #fff;
            display: inline-block;
            font: 700 14px Helvetica, Arial, sans-serif;
            color: #4b4f56;
            text-decoration: none;
            vertical-align: middle;
            padding: 0px 8px 0px;
            margin-right: 8px;
            border-radius: 2px;
            line-height: 22px;
            padding-left: 19px;
            border: 1px solid #e7e7e7;
            background-size: 13px
        }

        .fbvd--wrapper a:last-child {
            margin-right: 0
        }

        .fbvd--wrapper a:hover {
            text-decoration: none
        }

        .fbvd--wrapper a:focus {
            box-shadow: 0 0 1px 2px rgba(88, 144, 255, .75), 0 1px 1px rgba(0, 0, 0, .15);
            outline: none
        }

        .fbvd--wrapper b {
            font-size: 13px;
            position: relative;
            top: 1px;
            color: #3b5998;
            font-weight: 400
        }
    </style>
</head>
<body>

<div class="page-container">

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li><a href="/house365-hgs-web/">首页</a>
                    <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                    置业顾问管理
                </li>
            </ul>
        </div>
    </div>

    <c:choose>
        <c:when test="${departments!= null && fn:length(departments) == 0}">
            <div style="width: 90%;height: 40%;text-align: center;font-size: larger;margin-top: 30px;">名下暂无置业顾问数据</div>
        </c:when>
        <c:otherwise>

            <form id="filterForm" class="form-inline filterForm" action="${ctx}/manager" method="get">
                <div class="row-fluid">
                    <ul class="nav nav-tabs" style="margin-bottom: 0;position: relative;">
                        <c:forEach items="${departments}" var="dept">
                            <li <c:if test="${dept.id == deptId}">class="active"</c:if>>
                                <c:choose>
                                    <c:when test="${dept.id == deptId}">
                                        <a href="#">${dept.name}</a>
                                    </c:when>
                                    <c:when test="${dept.id != deptId}">
                                        <a href="${ctx}/manager?deptId=${dept.id}&search_LIKE_realName=${param['search_LIKE_realName']}&pageSize=${param['pageSize']}">${dept.name}</a>
                                    </c:when>
                                    <c:otherwise>

                                    </c:otherwise>
                                </c:choose>
                            </li>
                        </c:forEach>
                        <li class="inputSearch">
                            <input type="text" placeholder="搜索置业顾问" name="search_LIKE_realName"
                                   value="${param['search_LIKE_realName']}">
                            <div class="inputSearch__btn" onclick="$('#filterForm').submit();"></div>
                        </li>
                    </ul>
                </div>
                <input type="hidden" name="deptId" id="deptId" value="${deptId}">
                <input type="hidden" name="pageSize" id="pageSize" value="${param['pageSize']}">
            </form>

            <c:choose>
                <c:when test="${list!= null && fn:length(list) == 0}">
                    <div style="width: 90%;height: 40%;text-align: center;font-size: larger;margin-top: 30px;">
                        暂无置业顾问数据
                    </div>
                </c:when>
                <c:otherwise>
                    <table class="table table-advance table-hover">
                        <tbody>

                        <c:forEach items="${list}" var="user" varStatus="n">
                            <c:choose>
                                <c:when test="${n.index % 2!=0 && user.star=='off'}">
                                    <c:set var="bgc" value="style='background-color:#ddd;'"/>
                                </c:when>
                                <c:when test="${user.star=='on'}">
                                    <c:set var="bgc" value="style='background-color: #FFEB3B;'"/>
                                </c:when>
                                <c:otherwise>
                                    <c:set var="bgc" value=""/>
                                </c:otherwise>
                            </c:choose>

                            <tr class="header expand" ${bgc}>

                                <td class="mangerId mangerItem" style="width: 130px;">
                                    <div class="mangerItem__border"></div>
                                        <%--<input type="checkbox" name="memberCheck" value="23536" onclick="checkMember(this)">--%>
                                    <span class="mangerId_num">${user.managerId}</span>
                                </td>
                                <td class="mangerName mangerItem" style="width: 130px;">
                                    <div class="mangerItem__border"></div>
                                        ${user.managerName}
                                </td>
                                <td class="mangerItem doub" style="width: 130px;">
                                    <div class="mangerItem__border"></div>
                                    <div class="mangerItem__up">${user.total}</div>
                                    <div class="mangerItem__down">累计客户</div>
                                </td>
                                <td class="mangerItem doub" style="width: 130px;">
                                    <div class="mangerItem__border"></div>
                                    <div class="mangerItem__up">${user.waitCount}</div>
                                    <div class="mangerItem__down">待回访客户</div>
                                </td>
                                <td class="mangerItem doub" style="width: 130px;">
                                    <div class="mangerItem__border"></div>
                                    <div class="mangerItem__up">${user.callToday}</div>
                                    <div class="mangerItem__down">今日电话回访客户</div>
                                </td>
                                <td class="mangerItem doub" style="width: 130px;">
                                    <div class="mangerItem__border"></div>
                                    <div class="mangerItem__up">${user.callYesterday}</div>
                                    <div class="mangerItem__down">昨日电话回访客户</div>
                                </td>
                                <td class="mangerItem doub" style="width: 130px;">
                                    <div class="mangerItem__border"></div>
                                    <div class="mangerItem__up">${user.allCallToday}</div>
                                    <div class="mangerItem__down">今日累计客户</div>
                                </td>
                                <td class="mangerItem doub" style="width: 130px;">
                                    <div class="mangerItem__border"></div>
                                    <div class="mangerItem__up">${user.allCallYesterday}</div>
                                    <div class="mangerItem__down">昨日累计客户</div>
                                </td>
                                <td class="mangerItem mangerCollect ${user.star}"
                                    onclick="toggleCollect(this,'${user.managerId}')">
                                    <div class="mangerItem__border"></div>
                                </td>
                                <c:if test="${isDirector eq 1}">
                                    <td class="mangerItem">
                                        <a href="#">
                                            <div class="mangerItem__detail"
                                                 onclick="clearCustomerByManagerId('${user.managerId}', '${user.managerName}' ,${user.isClear})">
                                                清空客户
                                            </div>
                                        </a>
                                    </td>
                                </c:if>

                                <td class="mangerItem">
                                    <a href="#">
                                        <div class="mangerItem__detail"
                                             onclick="window.open('${ctx}/customermanagement/myCustomerNew?managerId=${user.managerId}');">
                                            查看详情
                                        </div>
                                    </a>
                                </td>
                            </tr>
                        </c:forEach>

                        </tbody>
                    </table>
                    <div class="row${fluid}">
                        <house365:newPagination page="${page}"/>
                    </div>
                </c:otherwise>
            </c:choose>

        </c:otherwise>
    </c:choose>

</div>

<script type="text/javascript">

    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    })

    var clearCustomerByManagerId = function (managerId, managerName, isClear) {
        if(isClear == 0){
            alert("名下暂无客户");
            return false;
        }else{
            House365Util.createModal("清空客户", "确认后所有客户将被移入公海,请谨慎操作！", function () {
                $.ajax({
                    url: '${ctx}/manager/clearCustomerByManagerId',
                    data: {"managerId": managerId, "managerName": managerName},
                    success: function (data) {
                        if (data.flag == '1') {
                            window.location.reload();
                        } else {
                            alert("清空失败，");
                        }
                        window.location.reload();
                    }
                });
            });
        }
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
//        if (selectedId == "") {
//            for (var i = 0; i < document.getElementsByName('memberCheck').length; i++) {
//                if (document.getElementsByName('memberCheck')[i].checked) {
//                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
//                }
//            }
//
//            var str = "";
//            if (selectedId != "") {
//                str = selectedId.split(",");
//
//                if (str[str.length - 1] == "") {
//                    selectedId = selectedId.substring(0, selectedId.length - 1);
//                }
//            }
//        }

//        if (selectedId == "") {
//            House365Util.createModal("删除400客户", "请至少选择一个400客户!", function () {
//            });
//        }
//        else {

//        }

    };

    function toggleCollect(_this, starUserId) {
        //收藏
        var flag = "off";
        if ($(_this).hasClass('on')) {
            $(_this).removeClass('on');
            $(_this).closest("tr").css("background-color", "#fff");
        } else {
            flag = "on";
            $(_this).addClass('on');
            $(_this).closest("tr").css("background-color", "#FFEB3B");
        }

        $.ajax({
            url: "${ctx}/manager/starToggle",
            data: {flag: flag, 'starUserId': starUserId},
            success: function (data) {

            }
        });

    }

</script>
</body>
</html>
