<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<style>
    tr.header {
        cursor: pointer;
    }

    .header .sign:after {
        content: "展开↓";
        display: inline-block;
    }

    .header.expand .sign:after {
        content: "收起↑";
    }

    .div-inline {
        display: inline-block;
    }

    .div-aaa {
        position: relative;
        overflow: auto;
        padding-left: 20px;
    }

    .div-aaa:before {
        content: '';
        position: absolute;
        left: 0;
        top: 0;
        display: inline-block;
        background: #1890ff;
        width: 10px;
        height: 10px;
        border: 1px solid white;
        border-radius: 5px;
        z-index: 9;
    }

    .div-aaa:after {
        content: '';
        position: absolute;
        left: 4px;
        top: 0;
        display: inline-block;
        background: #1890ff;
        height: 100%;
        width: 2px;
        z-index: 8;
    }

    .div-aaa:last-child:after {
        display: none;
    }

    .td {
        text-align: center !important;
    }

    .tag-item {
        color: white;
    }

    .clearfix:before, .clearfix:after {
        content: "";
        display: block;
        clear: both;
    }

    .bt {
        padding: 5px 10px;
        background-color: white;
        border-radius: 5px;
        outline: 0;
        border-color: transparent;
        box-shadow: none;
    }

    .temp {
        border: 1px solid #cccccc;
        width: 430px !important;
        height: 160px !important;
        position: relative;
        top: -26px;
        left: 81px;
    }

    .show-image {
        cursor: pointer;
    }

    .uploadmain .delete {
        position: absolute;
        right: -10px;
        top: -10px;
        cursor: pointer;
        border-radius: 50%;
        background: rgba(0, 0, 0, .5) url(${static_common}/upload/image/delete.png) no-repeat center;
        width: 20px;
        height: 20px;
        background-size: 10px
    }

</style>
<div id="input_form" class="form-horizontal valid"
      action="${ctx}/customer<c:if test="${action=='edit'}">/${entity.id}</c:if>"
      method="post">

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li><a href="/house365-hgs-web/">首页</a>
                    <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                    <a href="/house365-hgs-web/externalCustomer/list">外部客户</a>
                    <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                    客户信息
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <span class="inline"> ${entity.name} </span>
                </li>
            </ul>
        </div>
    </div>


    <div class="row${fluid}">
        <div class="span10 offset1">
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <input name="entity.id" type="hidden" value="${entity.id}"/>

                    <input name="entity.managerId" type="hidden" value="${entity.managerId}"/>
                    <input id="phone" name="phone" type="hidden" value="${entity.phone}"/>
                    <input name="entity.remark" id="entity_remark" type="hidden" value="${entity.remark}"/>
                    <input id="type" type="hidden" value="customer_cer_img"/>
                    <input type="hidden" id="projectId" name="projectId" value="${entity.id}"/>

                    <div class="sectionTitle" style="height:30px;">
                        基本信息
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label"><span style="color:red;">*</span> 客户姓名:</label>
                            <div class="controls">
                                <input type="text" id="name" name="name"
                                       value="${entity.name}"/>
                                <sapn><a href="#" onclick="getCRM(${entity.id})">查看CRM视图</a></sapn>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">手机号码:</label>
                            <div class="controls">
                                <span class="inline">${entity.phone}&nbsp;</span>
                                <c:if test="${hasPhone == 1}">
                                     <span id="star" class="icon-phone-sign"
                                           onclick="callCustomer('${entity.phone}','${entity.managerId}', '${entity.id}','${entity.buyIntention}','0')"></span>
                                </c:if>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">客户类型:</label>
                            <div class="controls">
                                ${entity.createSource}
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">安家顾问:</label>
                            <div class="controls">
                                ${entity.managerName}
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">性别:</label>
                            <div class="controls">
                                <input type="radio" name="sex" value="2" <c:if test="${entity.sex eq '2'}">
                                       checked</c:if>>未知
                                <input type="radio" name="sex" value="1" <c:if test="${entity.sex eq '1'}">
                                       checked</c:if>>男
                                <input type="radio" name="sex" value="0" <c:if test="${entity.sex eq '0'}">
                                       checked</c:if>>女
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">其他号码:</label>
                            <div class="controls">
                                <input type="text" id="bakPhone"
                                       name="bakPhone" maxlength="11"
                                       value="${entity.bakPhone}"/>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">跟踪状态:</label>
                            <div class="controls">
                                <select name="traceStatus" id="traceStatus">
                                    <option value="1"
                                            <c:if test="${'1' eq entity.traceStatus}">selected="selected"</c:if>>
                                        有效
                                    </option>
                                    <option value="2"
                                            <c:if test="${'2' eq entity.traceStatus}">selected="selected"</c:if>>
                                        已购
                                    </option>
                                    <option value="3"
                                            <c:if test="${'3' eq entity.traceStatus}">selected="selected"</c:if>>
                                        我购
                                    </option>
                                    <option value="4"
                                            <c:if test="${'4' eq entity.traceStatus}">selected="selected"</c:if>>
                                        暂缓
                                    </option>
                                </select>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">购房意向:</label>
                            <div class="controls">
                                <select name="buyIntention" id="buyIntention" style="width: 208px;">
                                    <option value="">请选择</option>
                                    <option value="1"
                                            <c:if test="${'1' eq entity.buyIntention}">selected="selected"</c:if>>A
                                    </option>
                                    <option value="2"
                                            <c:if test="${'2' eq entity.buyIntention}">selected="selected"</c:if>>B
                                    </option>
                                    <option value="3"
                                            <c:if test="${'3' eq entity.buyIntention}">selected="selected"</c:if>>C
                                    </option>
                                    <option value="4"
                                            <c:if test="${'4' eq entity.buyIntention}">selected="selected"</c:if>>D
                                    </option>
                                    <option value="5"
                                            <c:if test="${'5' eq entity.buyIntention}">selected="selected"</c:if>>E
                                    </option>
                                </select>
                            </div>
                        </div>

                        <span> <input class="btn btn-primary" type="button" onclick="commitForm()" value="保存"/></span>
                    </div>

                    <div class="sectionTitle" style="height:30px;">
                        回访记录&凭证文件
                    </div>
                    <div>
                        <div class="div-inline" style="width: 45%;margin-left: 2%;vertical-align: top;">
                            <span>回访记录</span>
                            <span style="margin-left: 10px;">
                                <shiro:hasPermission name="FUNC:ADDCALL">
                                    <button type="button" class="btn btn-primary btn-sm"
                                            onclick="addCallBack()">
                                        添加回访
                                    </button>
                                </shiro:hasPermission>
                            </span>
                            <div style="margin-top: 10px;border: 1px solid #ccc;padding: 10px;">
                                <c:forEach items="${callLogs}" var="call">
                                    <div class="row-fluid div-aaa">
                                        <div style="color: #ccc;margin-bottom: 10px;">
                                                ${call.managerName}
                                            <span style="float: right;color: #ccc">
                                                 <fmt:formatDate value='${call.createTime}'
                                                                 pattern='yyyy-MM-dd HH:mm:ss'/>
                                            </span>
                                        </div>

                                        <div style="margin-bottom: 10px;">
                                                ${call.content}
                                            <c:if test="${null ne call.callRecordName && '' ne call.callRecordName}">
                                                <span>
                                                    <audio controls>
                                                        <source src="http://218.94.115.131:98/uncall_api/downloadFile.php?f_path=${call.callRecordName}">
                                                         Your browser does not support this audio format.
                                                    </audio>
                                                </span>
                                            </c:if>
                                        </div>
                                    </div>
                                </c:forEach>
                                <c:if test="${0 eq fn:length(callLogs)}">
                                    <div style="margin-bottom: 10px;">
                                        暂无回访记录！
                                    </div>
                                </c:if>
                            </div>
                        </div>
                        <div class="div-inline" style="width: 45%;margin-left: 2%;">
                            <span>凭证文件</span>
                            <span style="margin-left: 10px;">
                                <button type="button" class="btn btn-primary btn-sm"
                                        onclick="showUpload()">
                                    新增
                                </button>
                            </span>

                            <div style="margin-top: 10px;border: 1px solid #ccc;padding: 10px;">
                                <c:forEach items="${attachList}" var="attachment">
                                    <tr>
                                        <td class="span2">
                                            <img class="show-image" width="100px" src="${attachment.remotePath}"
                                                 onclick="showImage('${attachment.remotePath}')"/>
                                            <span class="glyphicon glyphicon-remove" aria-hidden="true" style="margin-top: -50px;"
                                                  onclick="deleteById(${attachment.id})"></span>
                                        </td>
                                    </tr>
                                </c:forEach>

                            </div>
                        </div>
                    </div>

                    <div class="sectionTitle" style="height:30px;margin-top: 10px;">
                        客户情况与来源
                    </div>
                    <div class="row-fluid">
                        <table class="table table-bordered" style="width: 90%;margin-left: 5%;">
                            <thead>
                            <tr>
                                <th class="td" width="100">id</th>
                                <th class="td" width="100">来源类型</th>
                                <th class="td" width="100">活动名称</th>
                                <th class="td" width="100">添加时间</th>
                                <th class="td" width="100">添加人</th>
                            </tr>
                            </thead>
                            <tbody>
                            <c:forEach items="${oldList}" var="old">
                                <tr>
                                    <td class="td" width="100">${old.id}</td>
                                    <td class="td" width="100">${old.createSource}</td>
                                    <td class="td" width="100">${old.actSource}</td>
                                    <td class="td">
                                        <c:if test="${null ne old.createTime}">
                                            <f:formatDate value='${old.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                                        </c:if>
                                    </td>
                                    <td class="td" width="100">${old.createName}</td>
                                </tr>
                            </c:forEach>
                            </tbody>
                        </table>
                    </div>
                    <div class="sectionTitle" style="height:30px;">
                        客户日志
                    </div>
                    <ul>
                        <c:forEach items="${logList}" var="log">
                            <li>
                                <c:out value="${log}"/>
                            </li>
                        </c:forEach>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="uploadmain">
    <div class="uploadmask"></div>
    <div class="uploadmain">
        <div class="updiv">
            图片上传：
            <div class="upimg">
                <span>选择文件</span>
                <input type="file" id="upgteimg" value="" multiple/>
            </div>
        </div>
        <div id="showimg">
            <ul id="showui" class="imglist"></ul>
            <div id="showinput"></div>
        </div>
        <div class="btnlist">
            <button class="btn cblue" id="submit">确定</button>
            <button class="btn cgray" onclick="cancel()">取消</button>
        </div>
    </div>
</div>

<script>
    $(function () {
        $('.header').click(function () {
            $(this).toggleClass('expand').nextUntil('tr.header').slideToggle(100);
        });
        $('.header').click();
    });

    function commitForm() {
        var id = ${entity.id};
        var bakPhone = $("#bakPhone").val();
        var name = $("#name").val();
        var buyIntention = $("#buyIntention").val();
        var traceStatus = $("#traceStatus").val();
        var sex = $("input[name='sex']:checked").val();

        if (name == 'null' || !name || name == "") {
            alert("请填写姓名");
            return false;
        }

        if (buyIntention == 'null' || !buyIntention || buyIntention == "") {
            alert("请填写购房意向");
            return false;
        }

        if (bakPhone != "" && !checkMobile(bakPhone)) {
            alert("其他号码格式不正确");
            return false;
        }
        var data = {
            id: id,
            name: name,
            sex: parseInt(sex),
            bakPhone: bakPhone,
            traceStatus: parseInt(traceStatus),
            buyIntention: buyIntention
        };
        data = JSON.stringify(data);
        console.log(data);
        $.ajax({
            url: '${ctx}/externalCustomer/edit/' + id,
            type: 'POST',
            contentType: 'application/json',
            data: data,
            dataType: 'json',
            cache: false,
            success: function (result) {
                if (result.status == 0) {
                    var url = "/house365-hgs-web/externalCustomer/toEdit/" + id;
                    window.location.href = url;
                } else {
                    alert(result.errorMessage);
                }
            }
        });
    }

    function checkMobile(val) {
        var pattern = /(^(([0\+]\d{2,3}-)?(0\d{2,3})-)(\d{7,8})(-(\d{3,}))?$)|(^0{0,1}1[3|4|5|6|7|8|9][0-9]{9}$)/;
        if (pattern.test(val)) {
            return true;
        } else {
            return false;
        }
    }

    function addCallBack() {
        var callContentHtml = "";
        var phone = ${entity.phone};
        callContentHtml += "<div class='row-fluid'><div class='span5 control-group' style='position: relative'>"
            + " <label class='control-label'>购房意向：</label>"
            + "<div class='controls' style='position: absolute;top: -4px;left: 80px'><select name='entity.buyIntention' id='buyIntention2'>"
            + "<option value=''";
        <c:if test="${null eq entity.buyIntention or '' eq entity.buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">请选择</option><option value='1'";
        <c:if test="${'1' eq entity.buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">A</option><option value='2'";
        <c:if test="${'2' eq entity.buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">B</option><option value='3'";
        <c:if test="${'3' eq entity.buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">C</option><option value='4'";
        <c:if test="${'4' eq entity.buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">D</option><option value='5'";
        <c:if test="${'5' eq entity.buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">E</option>";
        callContentHtml += "</select>";
        callContentHtml += "<span style='margin-left: 200px;'>";

        callContentHtml += "</span></div></div></div>";
        callContentHtml += "<div class='row-fluid'><div class='span5 control-group'  style='width: 100%;position: relative;'>"
            + " <label class='control-label'>回访内容：</label>";
        callContentHtml += "<p contenteditable='true' class='temp' cols='10' rows='5' style='margin: 0px 0px 10px; width: 436px; height: 70px;' id='callContent'>" +
            "<div style='position: absolute;bottom: 39px;width: 80%;left:85px'>" +
            "</div></p></div>";
        callContentHtml += "</div>";

        House365Util.createModal("添加回访", callContentHtml, function () {
            var callContent = $("#callContent").text().replace(/(^\s*)|\s*$/g, '');

            var buyIntention = $("#buyIntention2").val();
            var customerId = ${entity.id};

            if (buyIntention == null || buyIntention == '') {
                alert("请选择购房意向");
                return false;
            }

            $("#hiddenBuyIntention").val(buyIntention);
            if (!callContent) {
                alert("回访内容不能为空");
                return false;
            } else if (callContent.length > 600) {
                alert("不能超过600个字");
                return false;
            } else {
                $.ajax({
                    url: '${ctx}/externalCustomer/addCall',
                    data: {
                        "content": callContent,
                        "customerId": customerId,
                        "phone": phone,
                        "buyIntention": buyIntention
                    },
                    type: "GET",
                    success: function (data) {
                        window.location.reload();
                    }
                });
            }
        });
    }

    function getCRM(customerId) {
        $.ajax({
            url: '${ctx}/externalCustomer/getCRMURL',
            data: {"customerId": customerId},
            type: "GET",
            success: function (data) {
                if (data.result == '1') {
                    if (data.data.entity == "") {
                        alert("该用户暂未推送至CRM");
                        return false;
                    }
                    window.open(data.data.entity);
                } else {
                    alert("操作失败，" + data.msg);
                }
            }
        });
    }

    var curnet = "${sessionUser.cornet}";

    function callCustomer(memPhone, managerId, customerId, buyIntention, abandon) {
        $.ajax({
            url: "${ctx}/cityCall/judgeCall",
            data: '',
            type: "get",
            dataType: 'json',
            success: function (result) {
                if (result.status == 0) {

                    if (curnet == "") {
                        House365Util.createModal("电话回访",
                            "对不起，您尚未填写固定电话短号，请前往个人中心设置", function () {
                                window.location.href = "${ctx}/role/edit/${sessionUserId}";
                            }, "前往设置");
                        return;
                    }
                    $("#callDialog").load("${ctx}/externalCustomer/callCustomer?memPhone=" + memPhone + "&customerId=" + customerId
                        + "&buyIntention=" + buyIntention + "&abandon=" + abandon, null, function () {
                    });
                    $("#callDialog").dialog({
                        closeOnEscape: false,
                        autoOpen: false,
                        draggable: false,
                        modal: true,
                        open: function (event, ui) {
                            $(".ui-dialog-titlebar-close", $(this).parent()).hide();
                        },
                        show: {
                            effect: "blind",
                            duration: 100
                        },
                        hide: {
                            effect: "explode",
                            duration: 100
                        },
                        width: 600
                    }).dialog("open");
                }
            }
        });
    }

    var deleteById = function (selectedId) {
        House365Util.createModal("提示", "您确定要删除该凭证图片吗？", function () {
            $.ajax({
                url: '${ctx}/image/delete/' + selectedId,
                type: "GET",
                success: function () {
                    window.location.reload();
                }
            });
        });
    };

    var showImage = function (imgUrl) {
        var content = "<img src='" + imgUrl + "'/>"
        House365Util.createModal("图片", content);
    };

    function showUpload() {
        $(".uploadmain").show();
    }

    function cancel() {
        $(".uploadmain").css('display', 'none');
    }

</script>
<link rel="stylesheet" href="${static_common}/jquery.qtip.custom/jquery.qtip.min.css" type="text/css">
<link rel="stylesheet" type="text/css" href="${static_common}/jquery-ui/jquery-ui.min.css"/>
<script src="${static_common}/jquery-ui/jquery-ui.min.js" type="text/javascript"></script>
<link rel="stylesheet" type="text/css" href="${static_common}/upload/css/upload.css"/>
<script type="text/javascript" src="${static_common}/upload/js/updateimg.js"></script>

<div id="callDialog" style="display: none" title="电话回访"></div>

</body>

</html>
