<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
    <link rel="stylesheet" href="${ctx}/resources/gallery/css/touchTouch.css">
    <link rel="stylesheet" type="text/css" href="${static_common}/upload/css/upload.css"/>
    <script src="${static_common}/upload/js/jquery.min.js"></script>
    <script type="text/javascript" src="${static_common}/upload/js/updateimg.js"></script>
</head>
<body>
<style>
    tr.header {
        cursor: pointer;
    }

    .header .sign:after {
        content: "展开↓";
        display: inline-block;
    }

    .header.expand .sign:after {
        content: "收起↑";
    }

    .steps {
        width: 1070px;
        height: 95px;
        position: relative;
        margin: 0 auto;
    }

    .first {
        position: absolute;
        width: 140px;
        height: 95px;
        position: absolute;
        top: 0;
        left: 0;
    }

    .first .big-circle {
        width: 33px;
        height: 33px;
        border-radius: 50%;
        background: #DBD8D8;
        position: absolute;
        left: 60px;
        top: 31px;
        text-align: center;
    }

    .first .min-circle, .second .min-circle, .third .min-circle, .fourth .min-circle, .fifth .min-circle, .sixth .min-circle {
        width: 23px;
        height: 23px;
        border-radius: 50%;
        display: inline-block;
        margin-top: 5px;
        text-align: center;
        line-height: 23px;
        color: #fff;
        font-size: 14px;
        font-weight: bold;
        background: #999;
    }

    .round_active {
        background: #2593FC !important;
    }

    .first .status-title {
        position: absolute;
        top: 0;
        left: 60px;
        line-height: 24px;
        color: #8A8A8A;
    }

    .second .status-title, .third .status-title, .fourth .status-title, .fifth .status-title, .sixth .status-title {
        position: absolute;
        top: 0;
        left: 40px;
        line-height: 24px;
        color: #8A8A8A;
    }

    .first .status-time {
        position: absolute;
        left: 20px;
        bottom: -20px;
        color: #A19F9D;
        font-size: 14px;
    }

    .second .status-time, .third .status-time, .fourth .status-time, .fifth .status-time, .sixth .status-time {
        position: absolute;
        left: 20px;
        bottom: -20px;
        color: #A19F9D;
        font-size: 14px;
    }

    .first .status-handler {
        position: absolute;
        left: 60px;
        bottom: 0;
        color: #A19F9D;
        font-size: 14px;
    }

    .second .status-handler, .third .status-handler, .fourth .status-handler, .fifth .status-handler, .sixth .status-handler {
        position: absolute;
        left: 40px;
        bottom: 0;
        color: #A19F9D;
        font-size: 14px;
    }

    .first .big-line {
        width: 130px;
        height: 10px;
        background: #DDDEDE;
        position: absolute;
        left: 88px;
        top: 42px;
        text-align: center;
        z-index: 999;
    }

    .second .big-line, .third .big-line, .fourth .big-line, .fifth .big-line {
        width: 125px;
        height: 10px;
        background: #DDDEDE;
        position: absolute;
        left: 71px;
        top: 42px;
        text-align: center;
        z-index: 999;
    }

    .first .min-line, .second .min-line, .third .min-line, .fourth .min-line, .fifth .min-line {
        width: 130px;
        height: 4px;
        margin-top: 3px;
        background: #999;
    }

    .line_active {
        background: #2593FC !important;
    }

    .second .big-circle, .third .big-circle, .fourth .big-circle, .fifth .big-circle, .sixth .big-circle {
        width: 33px;
        height: 33px;
        border-radius: 50%;
        background: #DBD8D8;
        position: absolute;
        left: 43px;
        top: 31px;
        text-align: center;
    }

    .second {
        width: 140px;
        position: absolute;
        top: 0;
        left: 170px;
        height: 95px;
    }

    .third {
        width: 140px;
        position: absolute;
        top: 0;
        left: 320px;
        height: 95px;
    }

    .fourth {
        width: 140px;
        position: absolute;
        top: 0;
        left: 470px;
        height: 95px;
    }

    .fifth {
        width: 140px;
        position: absolute;
        top: 0;
        left: 620px;
        height: 95px;
    }

    .sixth {
        width: 140px;
        position: absolute;
        top: 0;
        left: 770px;
        height: 95px;
    }

    .img-remove {
        background: #ccc;
        border-radius: 10px;
        text-align: center;
        line-height: 20px;
        width: 20px;
        height: 20px;
        left: 155px;
    }

    .sm_img {
        position: relative;
        width: 166px;
        margin-left: 18px;
        margin-bottom: 20px;
        display: inline-block;
    }

    .sm_img .img-show {
        width: 160px;
        height: 120px;
        border: 1px solid #ccc;
        padding: 2px;
        border-radius: 5px;
        -webkit-border-radius: 5px;
        -moz-border-radius: 5px;
        -ms-border-radius: 5px;
        -o-border-radius: 5px;
    }

    .show-image {
        cursor: pointer;
    }

    .uploadmain .delete {
        position: absolute;
        right: -10px;
        top: -10px;
        cursor: pointer;
        border-radius: 50%;
        background: rgba(0, 0, 0, .5) url(${static_common}/upload/image/delete.png) no-repeat center;
        width: 20px;
        height: 20px;
        background-size: 10px
    }
</style>
<form id="input_form" class="form-horizontal valid" action="${ctx}/customer/cpUpdate?action=edit" method="post">

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <a href="/house365-hgs-web/">首页</a>
                    <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                    <a href="/house365-hgs-web/customer/myRecordedCustomer?projectId=${entity.projectId}">约看客户列表</a>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->

    <div class="row-fluid">
        <div class="span11 offset1">
            <h3>客户项目信息：${entity.projectName}</h3>
        </div>
    </div>

    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span10 offset1">
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle" style="height:30px;">
                        客户信息
                    </div>
                    <input id="id" name="entity.id" type="hidden" value="${entity.id}"/>
                    <input name="customer.id" type="hidden" value="${customer.id}"/>
                    <input id="projectId" type="hidden" value="${entity.id}"/>
                    <input id="type" type="hidden" value="hgs_customer_project"/>

                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label"><span style="color: red">*</span> 客户姓名:</label>
                            <div class="controls">
                                <input type="text" id="customer.name" name="customer.name" maxlength="50"
                                       value="${customer.name}"/>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">客户电话:</label>
                            <div class="controls">
                                <span class="inline">${customer.phone}&nbsp;</span>
                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">客户类型:</label>
                            <div class="controls">
                                <span class="inline">${customer.createSource}&nbsp;</span>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">置业顾问:</label>
                            <div class="controls">
                                ${customer.managerName}
                            </div>
                        </div>
                    </div>

                    <div class="sectionTitle" style="height:30px;">
                        跟进阶段&nbsp;&nbsp;&nbsp;&nbsp;
                        <shiro:hasPermission name="FUNC:ADDSTATUS">
                            <%--<a href="#" onclick="addStatus(${entity.id})">添加客户状态</a>--%>
                            <%--<a href="#" class="btn btn-primary btn-mini" onclick="addStatus(${entity.id})">添加客户状态</a>--%>
                            <a href="#" class="btn btn-primary btn-mini" onclick="addStatus(${entity.id},${entity.isRepeat})">添加客户状态</a>
                        </shiro:hasPermission>
                    </div>
                    <div class="row-fluid" style="padding-bottom: 30px;">
                        <div class="span10 control-group steps">
                            <div class="first">
                                <div class="status-title">
                                    约看
                                </div>
                                <div class="big-circle">
                                    <c:if test="${statusProgress.maxActiveStatusId lt 1}">
                                        <div class="min-circle"></div>
                                    </c:if>
                                    <c:if test="${statusProgress.maxActiveStatusId ge 1}">
                                        <div class="min-circle round_active"></div>
                                    </c:if>
                                </div>
                                <div class="status-handler">
                                    ${statusProgress.progressDetail['1'].statusHandler}
                                </div>
                                <div class="status-time">
                                    ${statusProgress.progressDetail['1'].statusTime}
                                </div>
                                <div class="big-line">
                                    <c:if test="${statusProgress.maxActiveStatusId lt 2}">
                                        <div class="min-line"></div>
                                    </c:if>
                                    <c:if test="${statusProgress.maxActiveStatusId ge 2}">
                                        <div class="min-line line_active"></div>
                                    </c:if>
                                </div>
                            </div>

                            <div class="second">
                                <div class="status-title">
                                    到访
                                </div>
                                <div class="big-circle">
                                    <c:if test="${statusProgress.maxActiveStatusId lt 2}">
                                        <div class="min-circle"></div>
                                    </c:if>
                                    <c:if test="${statusProgress.maxActiveStatusId ge 2}">
                                        <div class="min-circle round_active"></div>
                                    </c:if>
                                </div>
                                <div class="status-handler">
                                    ${statusProgress.progressDetail['2'].statusHandler}
                                </div>
                                <div class="status-time">
                                    ${statusProgress.progressDetail['2'].statusTime}
                                </div>
                                <div class="big-line">
                                    <c:if test="${statusProgress.maxActiveStatusId lt 3}">
                                        <div class="min-line"></div>
                                    </c:if>
                                    <c:if test="${statusProgress.maxActiveStatusId ge 3}">
                                        <div class="min-line line_active"></div>
                                    </c:if>
                                </div>
                            </div>

                            <div class="third">
                                <div class="status-title">
                                    认筹
                                </div>
                                <div class="big-circle">
                                    <c:if test="${statusProgress.maxActiveStatusId lt 3}">
                                        <div class="min-circle"></div>
                                    </c:if>
                                    <c:if test="${statusProgress.maxActiveStatusId ge 3}">
                                        <div class="min-circle round_active"></div>
                                    </c:if>
                                </div>
                                <div class="status-handler">
                                    ${statusProgress.progressDetail['3'].statusHandler}
                                </div>
                                <div class="status-time">
                                    ${statusProgress.progressDetail['3'].statusTime}
                                </div>
                                <div class="big-line">
                                    <c:if test="${statusProgress.maxActiveStatusId lt 4}">
                                        <div class="min-line"></div>
                                    </c:if>
                                    <c:if test="${statusProgress.maxActiveStatusId ge 4}">
                                        <div class="min-line line_active"></div>
                                    </c:if>
                                </div>
                            </div>

                            <div class="fourth">
                                <div class="status-title">
                                    认购
                                </div>
                                <div class="big-circle">
                                    <c:if test="${statusProgress.maxActiveStatusId lt 4}">
                                        <div class="min-circle"></div>
                                    </c:if>
                                    <c:if test="${statusProgress.maxActiveStatusId ge 4}">
                                        <div class="min-circle round_active"></div>
                                    </c:if>
                                </div>
                                <div class="status-handler">
                                    ${statusProgress.progressDetail['4'].statusHandler}
                                </div>
                                <div class="status-time">
                                    ${statusProgress.progressDetail['4'].statusTime}
                                </div>
                                <div class="big-line">
                                    <c:if test="${statusProgress.maxActiveStatusId lt 5}">
                                        <div class="min-line"></div>
                                    </c:if>
                                    <c:if test="${statusProgress.maxActiveStatusId ge 5}">
                                        <div class="min-line line_active"></div>
                                    </c:if>
                                </div>
                            </div>

                            <div class="fifth">
                                <div class="status-title">
                                    签约
                                </div>
                                <div class="big-circle">
                                    <c:if test="${statusProgress.maxActiveStatusId lt 5}">
                                        <div class="min-circle"></div>
                                    </c:if>
                                    <c:if test="${statusProgress.maxActiveStatusId ge 5}">
                                        <div class="min-circle round_active"></div>
                                    </c:if>
                                </div>
                                <div class="status-handler">
                                    ${statusProgress.progressDetail['5'].statusHandler}
                                </div>
                                <div class="status-time">
                                    ${statusProgress.progressDetail['5'].statusTime}
                                </div>
                                <c:if test="${statusProgress.maxActiveStatusId eq 6}">
                                    <div class="big-line">
                                        <c:if test="${statusProgress.maxActiveStatusId lt 6}">
                                            <div class="min-line"></div>
                                        </c:if>
                                        <c:if test="${statusProgress.maxActiveStatusId ge 6}">
                                            <div class="min-line line_active"></div>
                                        </c:if>
                                    </div>
                                </c:if>
                            </div>

                            <c:if test="${statusProgress.maxActiveStatusId eq 6}">
                                <div class="sixth">
                                    <div class="status-title">
                                        退房
                                    </div>
                                    <div class="big-circle">
                                        <c:if test="${statusProgress.maxActiveStatusId lt 6}">
                                            <div class="min-circle"></div>
                                        </c:if>
                                        <c:if test="${statusProgress.maxActiveStatusId ge 6}">
                                            <div class="min-circle round_active"></div>
                                        </c:if>
                                    </div>
                                    <div class="status-handler">
                                            ${statusProgress.progressDetail['6'].statusHandler}
                                    </div>
                                    <div class="status-time">
                                            ${statusProgress.progressDetail['6'].statusTime}
                                    </div>
                                </div>
                            </c:if>
                        </div>
                    </div>

                    <div class="sectionTitle" style="height:30px;">
                        凭证文件：（<span style="color: red">注意：上传前请先保存填写的数据，上传文件将刷新页面，如未保存数据将丢失！</span>）
                    </div>
                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <div class="span3">
                                <%--<tags:imageSection resourceId="${entity.id}"--%>
                                <%--resourceType="hgs_customer_project"--%>
                                <%--bizType="${nextBizType}" editAble="true" title="图标"--%>
                                <%--maxSize="1"/>--%>
                                <a href="#" class="btn btn-primary" style="margin-left: 100px;" onclick="showUpload()"
                                   title="新增">上传文件</a>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span11 control-group">
                            <c:forEach items="${baseAttachments}" var="pic">
                                <div class="span2" style="width: 18%;margin-left: 20px;margin-right: 20px;">
                                    <div class="sm_img">
                                        <i class="img-remove icon-remove" style="margin-left: 110px;"
                                           onclick="deleteById('${pic.bizType}', '${pic.id}')"></i>
                                            <%--<img class="attach-img img-show" src="${pic.remotePath}"/>--%>
                                        <img class="attach-img  show-image" style="width: 100px;height:100px;"
                                             src="${pic.remotePath}"/>
                                            <%--<img class="show-image" style="width: 100px;height:100px;" src="${pic.remotePath}"--%>
                                            <%--onclick="showImage('${pic.remotePath}')"/>--%>
                                    </div>
                                </div>
                            </c:forEach>
                        </div>
                    </div>

                    <div class="sectionTitle" style="height:30px;">
                        客户状态变更记录
                    </div>
                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <div class="controls">
                                <ul>
                                    <c:forEach items="${logs}" var="log">
                                        <li>
                                            <c:if test="${null ne log.createTime && '' ne log.createTime}">
                                                <f:formatDate value='${log.createTime}'
                                                              pattern='yyyy-MM-dd HH:mm:ss'/>
                                            </c:if>
                                            <c:if test="${null ne log.oldValue && '' ne log.oldValue}">
                                                【项目转移】,
                                            </c:if>
                                            <c:if test="${null ne log.toStatusName && '' ne log.toStatusName}">
                                                【${log.toStatusName}】，
                                            </c:if>
                                            添加人【${log.creater}】,
                                            <c:if test="${null ne log.toStatusName && '' ne log.toStatusName && '人工判重' ne log.toStatusName}">
                                                发生时间:<f:formatDate value='${log.occurTime}'
                                                                   pattern='yyyy-MM-dd HH:mm:ss'/>,
                                            </c:if>
                                            <c:if test="${null ne log.oldValue && '' ne log.oldValue}">
                                                备注:【从${log.oldValue}转移到${log.newValue}】
                                            </c:if>
                                            <c:if test="${null eq log.oldValue || '' eq log.oldValue}">
                                                备注【${log.remark}】
                                            </c:if>

                                        </li>
                                    </c:forEach>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <div class="sectionTitle" style="height:30px;">
                        案场状态信息
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">置业顾问：</label>
                            <div class="controls">
                                <input type="text" id="entity.consultantName"
                                       name="entity.consultantName" maxlength="50"
                                       value="${entity.consultantName}"/>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">置业顾问电话：</label>
                            <div class="controls">
                                <input type="text" id="entity.consultantPhone"
                                       name="entity.consultantPhone" maxlength="50"
                                       value="${entity.consultantPhone}"/>
                            </div>
                        </div>
                        <div class="row-fluid">
                            <div class="span5 control-group">
                                <label class="control-label">案场报备：</label>
                                <div class="controls">
                                    <select name="entity.recordedStatus">
                                        <option value="">待定</option>
                                        <option value="0"
                                                <c:if test="${'0' eq entity.recordedStatus}">selected="selected"</c:if>>
                                            无效
                                        </option>
                                        <option value="1"
                                                <c:if test="${'1' eq entity.recordedStatus}">selected="selected"</c:if>>
                                            有效
                                        </option>
                                    </select>
                                </div>
                            </div>
                            <div class="span5 control-group">
                                <label class="control-label">贷款状态：</label>
                                <div class="controls">
                                    <select name="entity.loanStatus">
                                        <option value="">--请选择--</option>
                                        <option value="0"
                                                <c:if test="${'0' eq entity.loanStatus}">selected="selected"</c:if>>未办理
                                        </option>
                                        <option value="1"
                                                <c:if test="${'1' eq entity.loanStatus}">selected="selected"</c:if>>申请中
                                        </option>
                                        <option value="2"
                                                <c:if test="${'2' eq entity.loanStatus}">selected="selected"</c:if>>已下款
                                        </option>
                                        <option value="3"
                                                <c:if test="${'3' eq entity.loanStatus}">selected="selected"</c:if>>被拒绝
                                        </option>
                                        <option value="4"
                                                <c:if test="${'4' eq entity.loanStatus}">selected="selected"</c:if>>全款支付
                                        </option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row-fluid">
                            <div class="span5 control-group">
                                <label class="control-label">到访次数：</label>
                                <div class="controls">
                                    ${entity.visitTime}
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="sectionTitle" style="height:30px;">
                        意向信息
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">需求面积段:</label>
                            <div class="controls">
                                <input type="text" id="entity.requireArea"
                                       name="entity.requireArea" maxlength="50"
                                       value="${entity.requireArea}"/>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">需求房号：</label>
                            <div class="controls">
                                <input type="text" id="entity.requireHouse"
                                       name="entity.requireHouse" maxlength="50"
                                       value="${entity.requireHouse}"/>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">意向房型：</label>
                            <div class="controls">
                                <input type="text" id="entity.requireHouseType"
                                       name="entity.requireHouseType" maxlength="50"
                                       value="${entity.requireHouseType}"/>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">总价预算：</label>
                            <div class="controls">
                                <input type="text" id="entity.requirePrice"
                                       name="entity.requirePrice" maxlength="50"
                                       value="${entity.requirePrice}"/>
                            </div>
                        </div>
                    </div>

                    <div class="sectionTitle" style="height:30px;">
                        客户备注
                    </div>
                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <label class="control-label">备注信息：</label>
                            <div class="controls">
                            <textarea name="entity.remark"
                                      style="margin: 0px 0px 10px; width: 536px; height: 191px;">${entity.remark}</textarea>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="portlet-header">
                    <div class="operation-btn">
                        <input class="btn blue" type="button" onclick="commitForm()" value="保存"/>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>

<div class="uploadmain">
    <div class="uploadmask"></div>
    <div class="uploadmain">
        <div class="updiv">
            图片上传：
            <div class="upimg">
                <span>选择文件</span>
                <input type="file" id="upgteimg" value="" multiple/>
            </div>
        </div>
        <div id="showimg">
            <ul id="showui" class="imglist"></ul>
            <div id="showinput"></div>
        </div>
        <div class="btnlist">
            <button class="btn cblue" id="submit">确定</button>
            <button class="btn cgray" onclick="cancel()">取消</button>
        </div>
    </div>
</div>

<script>
    $(function () {
        $(".attach-img").touchTouch();
    });

    function deleteById(bizType, id) {
        House365Util.createModal('删除附件', '确定要删除此附件？', function () {
            $.ajax({ //提交表单
                url: ctx + '/attachment/delete/' + id, //获取提交到的页面
                type: "DELETE",
                success: function (data) {
                    if ("10000" == data) {
                        House365Util.ajaxTurn2Page($("#" + bizType
                            + "_list_container"), $(
                            "#" + bizType + "_list_container")
                            .attr("base-url"), 1);
                        window.location.reload();
                    } else {
                        House365Util.showAlertMessage($("#message"), "删除失败！", "error");
                    }
                }

            });
        });
    }

    (function () {
        $.fn.touchTouch = function () {
            var overlay = $('<div class="galleryOverlay">'),
                slider = $('<div class="gallerySlider">'),
                prevArrow = $('<a class="prevArrow"></a>'),
                nextArrow = $('<a class="nextArrow"></a>'),
                pageSpan = $('<div class="pagelimit"></div>'),
                close = $('<div class="closed"></div>'),
                overlayVisible = false;

            var placeholders = $([]),
                pl1 = [],
                index = 0,
                items = this;
            overlay.hide().appendTo('body');
            slider.appendTo(overlay);
            pageSpan.appendTo(overlay);
            items.each(function () {
                placeholders = placeholders.add($('<div class="placeholder">'));

            });

            slider.append(placeholders).on('click', function (e) {
                hideOverlay();
            });

            $('body').on('touchstart', '.gallerySlider img', function (e) {

                var touch = e.originalEvent,
                    startX = touch.changedTouches[0].pageX;

                slider.on('touchmove', function (e) {

                    e.preventDefault();

                    touch = e.originalEvent.touches[0] ||
                        e.originalEvent.changedTouches[0];

                    if (touch.pageX - startX > 10) {
                        slider.off('touchmove');
                        showPrevious();
                    }
                    else if (touch.pageX - startX < -10) {
                        slider.off('touchmove');
                        showNext();
                    }

                });

                return false;


            }).on('touchend', function () {
                slider.off('touchmove');
            });


            items.on('click', function (e) {
                e.preventDefault();

                index = items.index(this);
                showOverlay(index);
                showImage(index);

                calcPages(items, index);
                preload(index + 1);

                preload(index - 1);
                offsetSlider1(index);
                $(document).data("overlayVisible", true);
                e.cancelBubble = true;
            });

            function calcPages(items, index) {
                pageSpan.text((index + 1) + "/" + items.length);
            }

            if (!("ontouchstart" in window)) {
                overlay.append(prevArrow).append(nextArrow);

                prevArrow.click(function (e) {
                    e.preventDefault();
                    showPrevious();
                });

                nextArrow.click(function (e) {
                    e.preventDefault();
                    showNext();
                });
            }

            $(window).bind('keydown', function (e) {

                if (e.keyCode == 37) {
                    showPrevious();
                }
                else if (e.keyCode == 39) {
                    showNext();
                }

            });

            function showOverlay(index) {

                if (overlayVisible) {
                    return false;
                }

                overlay.show();

                setTimeout(function () {
                    overlay.addClass('visible');
                }, 100);

                offsetSlider1(index);

                overlayVisible = true;
            }

            function hideOverlay() {

                if (!overlayVisible) {
                    return false;
                }

                overlay.hide().removeClass('visible');
                overlayVisible = false;
                $(document).data("overlayVisible", overlayVisible);
            }

            function offsetSlider(index) {
                slider.stop(true).animate({left: (-index * 100) + '%'}, 500);
            }

            function offsetSlider1(index) {
                // slider.stop(true).animate({left:(-index*100)+'%'},500);
                slider.css('left', (-index * 100) + '%');
            }

            function preload(index) {
                setTimeout(function () {
                    showImage(index);
                }, 1000);
            }

            function showImage(index) {

                if (index < 0 || index >= items.length) {
                    return false;
                }

                loadImage(items.eq(index).attr('src'), function () {
                    placeholders.eq(index).html(this);
                });
            }

            function loadImage(src, callback) {
                var img = $('<img>').on('load', function () {
                    callback.call(img);
                });

                img.attr('src', src);
            }

            function showNext() {
                if (index + 1 < items.length) {
                    index++;
                    offsetSlider(index);
                    preload(index + 1);
                    calcPages(items, index);
                } else {
                    index++;
                    index = index % items.length;
                    offsetSlider(index);
                    preload(index + 1);
                    calcPages(items, index);
                }
            }

            function showPrevious() {

                if (index > 0) {
                    index--;
                    offsetSlider(index);
                    preload(index - 1);
                    calcPages(items, index);
                } else {
                    index--;
                    index = (index + items.length) % items.length;
                    offsetSlider(index);
                    preload(index + 1);
                    calcPages(items, index);
                }
            }
        };
    })(jQuery);

    $(function () {
        $('.header').click(function () {
            $(this).toggleClass('expand').nextUntil('tr.header').slideToggle(100);
        });

        $('.header').click();

    });

    function commitForm() {
        $("#input_form").submit();
    }

    function checkMobile(val) {
        var pattern = /(^(([0\+]\d{2,3}-)?(0\d{2,3})-)(\d{7,8})(-(\d{3,}))?$)|(^0{0,1}1[3|4|5|6|7|8|9][0-9]{9}$)/;
        if (pattern.test(val)) {
            return true;
        } else {
            return false;
        }
    }

    function addStatus(pid,isRepeat) {
        if (isRepeat == 1) {
            alert("该客户为重客，无法维护");
            return;
        }
        //添加客户回公海判断
        $.ajax({
            url: '${ctx}/customer/judgeSea/' + pid,
            type: "POST",
            success: function (data) {
                if (data.status == 0) {
                    House365Util.createRemoteModal("", "${ctx}/customer/assignStatus/" + pid, null, function () {
                        var status = "";
                        if ($("#customStatus").find("option:selected").length == 0) {
                            alert("请选择状态!");
                            return false;
                        }
                        $("#customStatus").find("option:selected").each(function () {
                            status = $(this).val();
                        });
                        if (pid == '') {
                            alert("至少要选择一个客户!");
                            return false;
                        }
                        var remark = $("#remark").val();
                        if (remark && remark.length > 200) {
                            alert("备注不能超过200个字!");
                            return false;
                        }

                        var occurTime = $("#occurTime").val();
                        if (occurTime == '' || occurTime == null) {
                            alert("请选择发生时间");
                            return false;
                        }

                        $.ajax({
                            url: '${ctx}/customer/changeStatus',
                            contentType: "application/x-www-form-urlencoded:charset=UTF-8",
                            data: {"projectId": pid, "status": status, "occurTime": occurTime, "remark": remark},
                            type: "GET",
                            success: function (data) {
                                if (data.result == '1') {
                                    window.location.reload();
                                } else {
                                    alert("操作失败，" + data.msg);
                                }
                            }
                        });
                        return true;
                    });
                } else {
                    alert(data.errorMessage);
                }
            }
        });

    }

    function showUpload() {
        $(".uploadmain").show();
    }

    function cancel() {
        $(".uploadmain").css('display', 'none');
    }

</script>

</body>

</html>
