<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<style>
    tr.header {
        cursor: pointer;
    }

    .header .sign:after {
        content: "展开↓";
        display: inline-block;
    }

    .header.expand .sign:after {
        content: "收起↑";
    }
</style>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/customer/cpUpdate"
      method="post">

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <a href="/house365-hgs-web/">首页</a>
                    <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                    <a href="/house365-hgs-web/customer/myCustomer">我的客户</a>
                    <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                    客户项目信息
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->

    <div class="row-fluid">
        <div class="span11 offset1">
            <h3>客户项目信息：${entity.projectName}</h3>
        </div>
    </div>

    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span10 offset1">
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle" style="height:30px;">
                        客户信息
                    </div>
                    <input name="entity.id" type="hidden" value="${entity.id}"/>
                    <input name="customer.id" type="hidden" value="${customer.id}"/>

                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">客户姓名:</label>
                            <div class="controls">
                                ${customer.name}
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">客户电话:</label>
                            <div class="controls">
                                <span class="inline">${customer.phone}&nbsp;</span>
                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">客户类型:</label>
                            <div class="controls">
                                <c:if test="${customer.customerSourceType eq '1'}"> 常规</c:if>
                                <c:if test="${customer.customerSourceType eq '2'}"> 抢客</c:if>
                                <c:if test="${customer.customerSourceType eq '3'}"> 营销</c:if>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">置业顾问:</label>
                            <div class="controls">
                                ${customer.managerName}
                            </div>
                        </div>
                    </div>

                    <div class="sectionTitle" style="height:30px;">
                        意向信息
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">需求面积段:</label>
                            <div class="controls">
                                <input type="text" id="entity.requireArea"
                                       name="entity.requireArea" maxlength="50"
                                       value="${entity.requireArea}"/>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">需求房号：</label>
                            <div class="controls">
                                <input type="text" id="entity.requireHouse"
                                       name="entity.requireHouse" maxlength="50"
                                       value="${entity.requireHouse}"/>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">意向房型：</label>
                            <div class="controls">
                                <input type="text" id="entity.requireHouseType"
                                       name="entity.requireHouseType" maxlength="50"
                                       value="${entity.requireHouseType}"/>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">总价预算：</label>
                            <div class="controls">
                                <input type="text" id="entity.requirePrice"
                                       name="entity.requirePrice" maxlength="50"
                                       value="${entity.requirePrice}"/>
                            </div>
                        </div>
                    </div>
                    <div class="sectionTitle" style="height:30px;">
                        案场状态信息
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">置业顾问：</label>
                            <div class="controls">
                                <c:if test="${null ne entity.consultantName && '' ne entity.consultantName}">
                                    <c:out value="${entity.consultantName}"/>
                                </c:if>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">置业顾问电话：</label>
                            <div class="controls">
                                <c:if test="${null ne entity.consultantPhone && '' ne entity.consultantPhone}">
                                    <c:out value="${entity.consultantPhone}"/>
                                </c:if>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">案场报备：</label>
                            <div class="controls">
                                <c:if test="${'' eq entity.recordedStatus}">待定</c:if>
                                <c:if test="${'0' eq entity.recordedStatus}">无效</c:if>
                                <c:if test="${'1' eq entity.recordedStatus}">有效</c:if>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">贷款状态：</label>
                            <div class="controls">
                                <c:if test="${'0' eq entity.loanStatus}">未办理</c:if>
                                <c:if test="${'1' eq entity.loanStatus}">申请中</c:if>
                                <c:if test="${'2' eq entity.loanStatus}">已下款</c:if>
                                <c:if test="${'3' eq entity.loanStatus}">被拒绝</c:if>
                                <c:if test="${'4' eq entity.loanStatus}">全款支付</c:if>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">客户状态：</label>
                            <div class="controls">
                                <c:if test="${'1' eq entity.status}">约看</c:if>
                                <c:if test="${'2' eq entity.status}">到访</c:if>
                                <c:if test="${'3' eq entity.status}">认筹</c:if>
                                <c:if test="${'4' eq entity.status}">认购</c:if>
                                <c:if test="${'5' eq entity.status}">签约</c:if>
                                <c:if test="${'6' eq entity.status}">退房</c:if>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">到访次数：</label>
                            <div class="controls">
                                ${entity.visitTime}
                            </div>
                        </div>
                    </div>

                    <div class="sectionTitle" style="height:30px;">
                        凭证文件：（<font color="red">注意：上传前请先保存填写的数据，上传文件将刷新页面，如未保存数据将丢失！</font>）
                    </div>
                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <div class="span3">
                                <tags:imageSection resourceId="${entity.id}"
                                                   resourceType="hgs_customer_project"
                                                   bizType="${nextBizType}" editAble="true" title="图标"
                                                   maxSize="1"/>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span11 control-group">
                            <c:forEach items="${baseAttachments}" var="pic">
                                <div class="span2" style="width: 18%;">
                                    <tags:imageSection resourceId="${pic.resourceId}"
                                                       resourceType="hgs_customer_project"
                                                       bizType="${pic.bizType}" editAble="true" title="图标"
                                                       maxSize="1"/>
                                </div>
                            </c:forEach>
                        </div>
                    </div>

                    <div class="sectionTitle" style="height:30px;">
                        客户备注
                    </div>
                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <label class="control-label">备注信息：</label>
                            <div class="controls">
                                <textarea name="entity.remark"
                                          style="margin: 0px 0px 10px; width: 536px; height: 191px;">${entity.remark}</textarea>
                            </div>
                        </div>
                    </div>
                    <div class="sectionTitle" style="height:30px;">
                        客户状态变更记录
                    </div>
                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <div class="controls">
                                <ul>
                                    <c:forEach items="${logs}" var="log">
                                        <li>
                                            <c:if test="${null ne log.createTime && '' ne log.createTime}">
                                                <f:formatDate value='${log.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                                            </c:if>
                                            <c:if test="${null ne log.toStatusName && '' ne log.toStatusName}">
                                                【${log.toStatusName}】，
                                            </c:if>
                                            添加人【${log.creater}】,备注【${log.remark}】
                                        </li>
                                    </c:forEach>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="portlet-header">
                <div class="operation-btn">
                    <input class="btn blue" type="button" onclick="commitForm()" value="保存">
                    </input>
                </div>
            </div>
        </div>
    </div>
</form>

<script>
    $(function () {
        $('.header').click(function () {
            $(this).toggleClass('expand').nextUntil('tr.header').slideToggle(100);
        });

        $('.header').click();
    });

    function commitForm() {
        $("#input_form").submit();
    }

    function checkMobile(val) {
        var pattern = /(^(([0\+]\d{2,3}-)?(0\d{2,3})-)(\d{7,8})(-(\d{3,}))?$)|(^0{0,1}1[3|4|5|6|7|8|9][0-9]{9}$)/;
        if (pattern.test(val)) {
            return true;
        } else {
            return false;
        }

    }

</script>

</body>

</html>
