<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>客户数据公海</title>
</head>
<body>
<link rel="stylesheet" href="${static_common}/jquery.qtip.custom/jquery.qtip.min.css" type="text/css">

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                客户数据公海
            </li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li class="active">共${summary['totalCount']}条数据，今日新增${summary['todayCount']}条</li>
        </ul>
    </div>
</div>

<div id="divarea" class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/customer" method="get">
                <input type="text" name="search_name" value="${param['search_name']}"
                       class="m-wrap small span2" placeholder="客户姓名">
                <input type="text" name="search_phone" value="${param['search_phone']}"
                       class="m-wrap small span2" placeholder="客户电话">
                <input type="text" name="search_lastManager" value="${param['search_lastManager']}"
                       class="m-wrap small span2" placeholder="原置业顾问姓名">
                掉公海时间：                        <input style="width: 7rem;border: 1px solid #d5d5d5;" type="text" name="search_GTE_oceanDateStart"
                                                    id="search_GTE_oceanDateStart" value="${param['search_GTE_oceanDateStart']}"
                                                    class="m-wrap small span2"
                >至
                <input style="width: 7rem;margin-left: 15px;border: 1px solid #d5d5d5;" type="text" name="search_LTE_oceanDateEnd"
                       id="search_LTE_oceanDateEnd" value="${param['search_LTE_oceanDateEnd']}"
                       class="m-wrap small span2"
                >
                <select style="width: 6rem" name="search_buyIntention" id="search_buyIntention">
                    <option value="">
                        全部意向
                    </option>
                    <option value="dai"
                            <c:if test="${'dai' eq param['search_buyIntention']}">selected="selected"</c:if>>
                        待定
                    </option>
                    <option value="1"
                            <c:if test="${'1' eq param['search_buyIntention']}">selected="selected"</c:if>>
                        A
                    </option>
                    <option value="2"
                            <c:if test="${'2' eq param['search_buyIntention']}">selected="selected"</c:if>>
                        B
                    </option>
                    <option value="3"
                            <c:if test="${'3' eq param['search_buyIntention']}">selected="selected"</c:if>>
                        C
                    </option>
                    <option value="4"
                            <c:if test="${'4' eq param['search_buyIntention']}">selected="selected"</c:if>>
                        D
                    </option>
                    <option value="5"
                            <c:if test="${'5' eq param['search_buyIntention']}">selected="selected"</c:if>>
                        E
                    </option>
                </select>
                <input type="hidden" name="type" value="${type}"
                       class="m-wrap small span2">
                <button type="button" class="btn btn-default" onclick="assignManager()">批量派工</button>
                <div class="buttons pull-right" style="margin:3px 30px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
            </form>
        </div>
    </div>
    <ul class="nav nav-tabs" role="tablist">
        <li role="presentation"<c:if test="${type eq '' || empty type}"> class="active"</c:if>><a
                href="${ctx}/customer">全部客户</a>
        </li>
        <li role="presentation"<c:if test="${type eq '1'}"> class="active"</c:if>><a
                href="${ctx}/customer?type=1">CRM导入</a>
        </li>
        <li role="presentation"<c:if test="${type eq '2'}"> class="active"</c:if>><a
                href="${ctx}/customer?type=2">系统回收</a>
        </li>
        <li role="presentation"<c:if test="${type eq '3'}"> class="active"</c:if>><a
                href="${ctx}/customer?type=3">无效客户</a>
        </li>
    </ul>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="40" style="text-align:center">
                <input id="memberCheckAll" type="checkbox" onclick="checkAll(this)"/>
            </th>
            <th width="100">序号</th>
            <th width="100">姓名</th>
            <th width="100">电话</th>
            <th width="100">购房意向</th>
            <th width="100">客户类型</th>
            <th width="100">原置业顾问</th>
            <th width="100">活动来源</th>
            <th width="100">约看楼盘</th>
            <th width="100">掉公海时间</th>
            <th width="150">操作</th>
        </tr>
        </thead>
        <c:forEach items="${customers}" var="customer">
            <tr>
                <td nowrap="nowrap" style="text-align:center">
                    <input type="checkbox" name="memberCheck" value="${customer.id}" onclick="checkMember(this)"/>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne customer.id && '' ne customer.id}">
                        <c:out value="${customer.id}"/>
                    </c:if>
                    <c:if test="${null eq customer.id || '' eq customer.id}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne customer.name && '' ne customer.name}">
                        <c:out value="${customer.name}"/>
                    </c:if>
                    <c:if test="${null eq customer.name || '' eq customer.name}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne customer.phone && '' ne customer.phone}">
                        <c:out value="${customer.phone}"/>
                    </c:if>
                    <c:if test="${null eq customer.phone || '' eq customer.phone}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:choose>
                        <c:when test="${customer.buyIntention eq '1'}">
                            <span class="inline">A</span>
                        </c:when>
                        <c:when test="${customer.buyIntention eq '2'}">
                            <span class="inline">B</span>
                        </c:when>
                        <c:when test="${customer.buyIntention eq '3'}">
                            <span class="inline">C</span>
                        </c:when>
                        <c:when test="${customer.buyIntention eq '4'}">
                            <span class="inline">D</span>
                        </c:when>
                        <c:when test="${customer.buyIntention eq '5'}">
                            <span class="inline">E</span>
                        </c:when>
                        <c:otherwise>
                            <span class="inline">待定</span>
                        </c:otherwise>
                    </c:choose>
                </td>
                <td nowrap="nowrap">
                    <span class="inline">${customer.createSource}</span>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne customer.lastManager && '' ne customer.lastManager}">
                        <c:out value="${customer.lastManager}"/>
                    </c:if>
                    <c:if test="${null eq customer.lastManager || '' eq customer.lastManager}">
                        &nbsp;&nbsp;-&nbsp;&nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne customer.actSource && '' ne customer.actSource}">
                        ${fn:substring(customer.actSource, 0, 35)}
                    </c:if>
                    <c:if test="${null eq customer.actSource || '' eq customer.actSource}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <a href="#" class="baobei">约看楼盘</a>
                    <div style="display: none;">
                        <c:if test="${not empty customer.projectNames}">
                            <c:forEach items="${customer.projectNames}" var="name">
                                <p>${name}</p>
                            </c:forEach>
                        </c:if>
                        <c:if test="${empty customer.projectNames}">
                            无约看信息
                        </c:if>
                    </div>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne customer.oceanDate && '' ne customer.oceanDate}">
                        <f:formatDate value='${customer.oceanDate}' pattern='yyyy-MM-dd HH:mm:ss'/>
                    </c:if>
                    <c:if test="${null eq customer.oceanDate || '' eq customer.oceanDate}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <button type="button" class="btn btn-default" onclick="customerInfo(${customer.id})">查看详情
                    <button type="button" class="btn btn-default" onclick="assignManagerSingle(${customer.id})">派工
                    </button>
                    <c:if test="${customer.buyIntention eq '5'}">
                        <button type="button" class="btn btn-warning" onclick="deleteFormOcean(${customer.id})">删除
                        </button>
                    </c:if>
                </td>
            </tr>
        </c:forEach>
    </table>

    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/jquery.qtip.custom/jquery.qtip.min.js"></script>

<script type="text/javascript">

    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    });

    $(function () {
        // 掉公海时间
        var oceanDateStart = $("#search_GTE_oceanDateStart")
        var oceanDateEnd = $("#search_LTE_oceanDateEnd");
        oceanDateEnd.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                minDate: oceanDateStart.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true
            });
        });
        oceanDateStart.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                maxDate: oceanDateEnd.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true,
                onpicked: function () {
                    WdatePicker({
                        startDate: "%y-{%M-1}-%d",
                        minDate: oceanDateStart.val(),
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        el: 'oceanDateEnd'
                    })
                }
            });
        });

        $('.baobei').each(function () { // Notice the .each() loop, discussed below
            $(this).qtip({
                content: {
                    text: $(this).next('div') // Use the "div" element next to this for the content
                }, position: {
                    at: 'bottom center', // at the bottom right of...
                    target: $(this) // my target
                }
            });
        });
    });

    function assignManagerSingle(obj) {
        House365Util.createRemoteModal("派工", "${ctx}/customer/assignManager?customerCount=1", null, function () {
            var userIds = "";
            if ($("#custom-headers").find("option:selected").length == 0) {
                alert("分派人员不可为空!");
                return false;
            }

            $("#custom-headers").find("option:selected").each(function () {
                userIds = userIds + $(this).val() + ",";
            });


            if (obj == '') {
                alert("至少要选择一个客户!");
                return false;
            }

            checkCustomerPhone(userIds, obj);
            return true;
        });
    }


    function openAssignWindow(customerCont, customerIds) {
        House365Util.createRemoteModal("客户派工", "/house365-hgs-web/customer/assignManager?multyassign=1&customerCount=" + customerCont, null, function () {
            var userIds = "";
            if ($("#custom-headers").find("option:selected").length == 0) {
                alert("分派人员不可为空!");
                return false;
            }

            $("#custom-headers").find("option:selected").each(function () {
                userIds = userIds + $(this).val() + ",";
            });

            if (customerIds == '') {
                alert("至少要选择一个客户!");
                return false;
            }

            $.ajax({
                url: '/house365-hgs-web/customer/assign',
                data: {
                    "userIds": userIds,
                    "customerIds": customerIds,
                    "type": "market"
                },
                type: "GET",
                success: function (data) {
                    if (data.result == '1') {
                        alert(data.msg);
                        window.location.reload();
                    } else {
                        alert("操作失败，" + data.msg);
                    }
                }
            });
            return true;
        });
        $(".modal").css("width", "560px");
    }

    function assignManager() {
        var customerIds = "", customerCont = 0;
        for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
            if (document.getElementsByName('memberCheck')[i].checked) {
                customerIds += document.getElementsByName('memberCheck')[i].value + ",";
                customerCont += 1;
            }
        }

        if (customerIds == '') {
            alert("请至少选择一个客户!");
            return false;
        }

        House365Util.createRemoteModal("客户派工", "/house365-hgs-web/customer/assignManager?multyassign=1&customerCount=" + customerCont, null, function () {
            var userIds = "";
            if ($("#custom-headers").find("option:selected").length == 0) {
                alert("分派人员不可为空!");
                return false;
            }

            $("#custom-headers").find("option:selected").each(function () {
                userIds = userIds + $(this).val() + ",";
            });

            if (customerIds == '') {
                alert("至少要选择一个客户!");
                return false;
            }
            checkCustomerPhone(userIds, customerIds);

            return true;
        });
        $(".modal").css("width", "560px");

    }

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }


    var deleteFormOcean = function (selectedId) {
        /*
         id为空则是多选 判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        if (selectedId == "") {
            for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            House365Util.createModal("删除客户", "请至少选择一个客户!", function () {
            });
        }
        else {
            House365Util.createModal("删除客户", "确定要删除该客户？", function () {
                $.ajax({
                    url: '${ctx}/customer/' + selectedId,
                    type: "DELETE",
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        }

    };

    function checkCustomerPhone(userIds, customerIds) {
        $.ajax({
            url: "${ctx}/customer/checkCustomerPhoneByCustomerIds",
            data: {
                userIds: userIds,
                customerIds: customerIds
            },
            async: false,
            type: "get",
            success: function (data) {
                if (data.result === "0") {
                    var tips = data.msg + ',是否继续？';
                    var msg = confirm(tips);
                    if (msg) {
                        assignCustomer(userIds, customerIds);
                        return false;
                    }
                } else {
                    assignCustomer(userIds, customerIds);
                    return false;
                }
            }
        });
    }

    function assignCustomer(userIds, customerIds) {
        $.ajax({
            url: '${ctx}/customer/assign',
            data: {"userIds": userIds, "customerIds": customerIds, "assignFrom": "fromSea"},
            type: "GET",
            success: function (data) {
                if (data.result == '1') {
                    window.location.reload();
                } else {
                    alert("操作失败，" + data.msg);
                }
            }
        });
    }

    function customerInfo(id) {
        window.open("/house365-hgs-web/customer/seaCustomerInfo?action=edit&customerId=" + id, "_blank");
    }

</script>
</body>
</html>
