<%@ page language="java" pageEncoding="UTF-8" %>
<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<html>
<head>
    <title>${title}</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7">
    <meta http-equiv="Cache-Control" content="no-store"/>
    <meta http-equiv="Pragma" content="no-cache"/>
    <meta http-equiv="Expires" content="0"/>
    <title>${title}</title>
    <link type="text/css" href="${ctx}/resources/customize/zTree/css/zTreeStyle/zTreeStyle.css" rel="stylesheet">
</head>
<body>
<input type="text" id="sourceSel" style="width:300px" value="${sourceSel}"/>
<input type="hidden" id="choseIds" value="${choseIds}"/>
<div id="treeContainer"></div>
<script src="${ctx}/resources/customize/zTree/js/jquery.ztree.all-3.5.js?3"></script>
<script src="${ctx}/resources/customize/zTree/js/tree.common.js?1"></script>
</body>

<script type="text/javascript">

    $(function () {
        var choseIds = "${choseIds}" == "" ? new Array() : "${choseIds}".split(",");

        var zNodes = [
            <c:forEach items="${trees}" var="m">
            {
                "id": "${m.sourceId}",
                "pId": "${m.parentId}",
                "name": "${m.name}",
                "open": true,
                "root": ${m.hierarchy==0},
                "isParent": true
            },
            </c:forEach>
        ];

        $.zTree.initMovableTree({
            zNodes: zNodes,
            urlPrefix: "${ctx}/crmsource",
            otherParam: {"choseIds": "${choseIds}"},
            async: {
                enable: true,
            },
            check: {
                enable: true
            },
            editable: false,
            containerId: 'treeContainer',
            maxLevel: 10,
            setting: {
                callback: {
                    onCheck: function (e, treeId, treeNode) {
                        var zTree = $.fn.zTree.getZTreeObj("treeSelect1"),
                            nodes = zTree.getCheckedNodes(true),
                            v = "", c = "";
                        for (var i = 0, l = nodes.length; i < l; i++) {
                            if (!nodes[i].isParent) {
                                c += nodes[i].id + ",";
                            }
                            var parentNode = nodes[i].getParentNode();
                            if (parentNode == null) {
                                continue;
                            }
                            //如果兄弟节点全部选中,如果是1级节点，则添加名字
                            if (parentNode.check_Child_State == 2) {
                                if (parentNode.id == 0) {
                                    v += nodes[i].name + ",";
                                }
                                continue;
                                //兄弟节点没有全部选中，子节点全部选中的，添加名字
                            } else if (nodes[i].isParent && nodes[i].check_Child_State == 2) {
                                v += nodes[i].name + ",";
                                //兄弟节点没有全部选中的子节点，添加名字
                            } else if (!nodes[i].isParent) {
                                v += nodes[i].name + ",";
                            }


                        }
                        if (v.length > 0) v = v.substring(0, v.length - 1);
                        if (c.length > 0) c = c.substring(0, c.length - 1);
                        $("#choseIds").val(c);
                        var sourceObj = $("#sourceSel");
                        sourceObj.attr("value", v);
                    }
                }
            }
        });

        asyncAll();
        var zTree = $.fn.zTree.getZTreeObj("treeSelect1");
        console.log(choseIds)
        if (choseIds.length != 0)
            $.each(choseIds, function (n, id) {
                var node = zTree.getNodeByParam("id", id);
                if (!node.isParent) {
                    zTree.checkNode(node, true, true);
                }
            })
    });

    var curStatus = "init", curAsyncCount = 0, asyncForAll = false,
        goAsync = false;

    function asyncNodes(nodes) {
        if (!nodes) return;
        curStatus = "async";
        var zTree = $.fn.zTree.getZTreeObj("treeSelect1");
        for (var i = 0, l = nodes.length; i < l; i++) {
            if (nodes[i].isParent && nodes[i].zAsync) {
                asyncNodes(nodes[i].children);
            } else {
                goAsync = true;
                zTree.reAsyncChildNodes(nodes[i], "refresh", true);
            }
        }
    }

    function asyncAll() {
        var zTree = $.fn.zTree.getZTreeObj("treeSelect1");
        if (!asyncForAll) {
            asyncNodes(zTree.getNodes());
            if (!goAsync) {
                curStatus = "";
            }
        }
    }
</script>
