/**
 * Description: 权限控制器
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-14 下午 17:27:18
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.web.controller;

import com.house365.beans.entity.DepartmentEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.beans.entity.WeChatPermissionEntity;
import com.house365.beans.entity.WeChatPermissionTreeEntity;
import com.house365.beans.system.Page;
import com.house365.beans.vo.WeChatPermissionVo;
import com.house365.web.system.controller.BaseController;
import com.house365.web.util.PathUtil;
import com.house365.web.util.SessionConstants;
import com.house365.web.util.StringUtils;
import com.house365.ws.beans.request.WeChatPermissionListRequest;
import com.house365.ws.beans.request.WeChatPermissionRequest;
import com.house365.ws.beans.response.WeChatPermissionListResponse;
import com.house365.ws.beans.response.WeChatPermissionResponse;
import com.house365.ws.interfaces.server.IDepartment;
import com.house365.ws.interfaces.server.IWeChatPermission;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springside.modules.web.Servlets;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 权限控制器<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
@Controller
@RequestMapping("/wechatpermission")
public class WeChatPermissionController extends BaseController {

    @Autowired
    private IDepartment department;

    @Autowired
    private IWeChatPermission weChatPermission;


    /**
     * 去新增权限
     *
     * @return 结果视图
     */
    @RequestMapping(value = "", params = "action=create")
    public String createForm(Model model) {
        model.addAttribute("action", "create");
        return getAutoUrl("form");
    }

    /**
     * 新增权限
     *
     * @param vo     权限页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "", method = {RequestMethod.POST})
    public String createPermission(@Valid WeChatPermissionVo vo,
                                   BindingResult result, RedirectAttributes redirectAttributes,
                                   HttpServletRequest httpRequest, Model model) {
        WeChatPermissionEntity entity = vo.getEntity();

        Integer parentId = entity.getParentId();
        if (parentId == null) {
            entity.setHierarchy(0);
            entity.setParentId(0);
        } else {
            entity.setHierarchy(department.getDepartmentById(parentId).getEntity().getHierarchy() + 1);
        }

        UserEntity userEntity = (UserEntity) httpRequest.getSession().getAttribute(SessionConstants.THREAD_USER_KEY);
        Date date = new Date();
        entity.setType(1);
        entity.setSpecial(true);
        entity.setCreateUserid(userEntity.getId());
        entity.setCreateUsername(userEntity.getName());
        entity.setCreateTime(date);
        entity.setUpdateUserid(userEntity.getId());
        entity.setUpdateUsername(userEntity.getName());
        entity.setUpdateTime(date);

        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                WeChatPermissionRequest request = new WeChatPermissionRequest();
                request.setEntity(entity);
                WeChatPermissionResponse response = weChatPermission.addPermission(request);
                Integer id = response.getEntity().getId();
                return "redirect:/wechatpermission/" + id;
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "create");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 删除权限
     *
     * @param id 权限页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.DELETE})
    @ResponseStatus(HttpStatus.OK)
    public void delete(@PathVariable String id) {
        if (!StringUtils.isEmpty(id)) {
            if (id.contains(",")) {
                String[] ids = id.split(",");
                for (int i = 0; i < ids.length; i++) {
                    weChatPermission.deletePermissionById(Integer.valueOf(ids[i]));
                }
            } else {
                weChatPermission.deletePermissionById(Integer.valueOf(id));
            }
        }
    }

    /**
     * 去查看权限
     *
     * @param id 权限页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET})
    public String showForm(@PathVariable(value = "id") Integer id, Model model) {
        WeChatPermissionResponse response = weChatPermission.getPermissionById(id);
        model.addAttribute("entity", response.getEntity());
        return getAutoUrl("form");
    }

    /**
     * 去修改权限
     *
     * @param id 权限页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET}, params = "action=edit")
    public String updateForm(@PathVariable(value = "id") Integer id, Model model) {
        WeChatPermissionResponse response = weChatPermission.getPermissionById(id);
        model.addAttribute("entity", response.getEntity());
        model.addAttribute("action", "edit");
        return getAutoUrl("form");
    }

    /**
     * 修改权限
     *
     * @param vo     权限页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.POST})
    public String updatePermission(@Valid WeChatPermissionVo vo,
                                   BindingResult result, @PathVariable Integer id,
                                   RedirectAttributes redirectAttributes, Model model) {
        WeChatPermissionEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                WeChatPermissionRequest request = new WeChatPermissionRequest();
                request.setEntity(entity);
                @SuppressWarnings("unused")
                WeChatPermissionResponse rersponse = weChatPermission
                        .updatePermission(request);
                redirectAttributes.addAttribute("message", "更新成功");
                return "redirect:/wechatpermission/" + entity.getId();
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "edit");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 查询权限
     *
     * @param request 请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "", method = RequestMethod.GET)
    public String list(Integer number, Model model, HttpServletRequest request) {
        DepartmentEntity dept = (DepartmentEntity) request.getSession().getAttribute(SessionConstants.SESSION_ORIGIN_DEPT_KEY);

        // 获取查询条件
        Map<String, Object> searchParams = Servlets.getParametersStartingWith(
                request, "search_");
        Page page = new Page(300);
        if (null != number) {
            page.setCurrentPage(number);
        }
        if (!PathUtil.isAdminDept(dept)) {
            searchParams.put("EQ_special", false);
        }

        WeChatPermissionListRequest listRequest = new WeChatPermissionListRequest();
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        listRequest.setOrderColumn("parentId");
        listRequest.setOrderMode("asc");
        WeChatPermissionListResponse response = weChatPermission
                .getPermissionList(listRequest);
        model.addAttribute("page", response.getPaging());
        List<WeChatPermissionEntity> permissionList = response.getObjectList();

        WeChatPermissionTreeEntity PermissionTree = new WeChatPermissionTreeEntity(true);
        WeChatPermissionEntity root = new WeChatPermissionEntity();
        root.setId(0);
        PermissionTree.setEntity(root);
        for (WeChatPermissionEntity permissionEntity : permissionList) {
            PermissionTree.add(permissionEntity);
        }
        List<WeChatPermissionEntity> list = PermissionTree.toList();
        model.addAttribute("permissions", list);
        model.addAttribute("searchParams", Servlets.encodeParameterStringWithPrefix(searchParams, "search_"));
        return getAutoUrl();
    }

    private String levelStr(Integer level) {
        String result = "";
        if (level == null || level == 0) {
            return result;
        }

        for (int i = 0; i < level; i++) {
            result += "      ";
        }
        return result;
    }
}
