/**
 * Description: ReportChannelDepartRel控制器
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-07-17 上午 10:14:20
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-07-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.web.controller;

import com.house365.beans.entity.ReportChannelDepartRelEntity;
import com.house365.beans.system.Page;
import com.house365.beans.vo.ReportChannelDepartRelVo;
import com.house365.web.system.controller.BaseController;
import com.house365.web.util.StringUtils;
import com.house365.ws.beans.request.ReportChannelDepartRelListRequest;
import com.house365.ws.beans.request.ReportChannelDepartRelRequest;
import com.house365.ws.beans.response.ReportChannelDepartRelListResponse;
import com.house365.ws.beans.response.ReportChannelDepartRelResponse;
import com.house365.ws.interfaces.server.IReportChannelDepartRel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springside.modules.web.Servlets;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.Map;

/**
 * ReportChannelDepartRel控制器<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-07-17
 * @see
 * @since 1.0
 */
@Controller
@RequestMapping("/reportchanneldepartrel")
public class ReportChannelDepartRelController extends BaseController {

    /**
     * 自动注入ReportChannelDepartRelWS实现
     */
    @Autowired
    private IReportChannelDepartRel reportChannelDepartRel;

    /**
     * 去新增ReportChannelDepartRel
     *
     * @return 结果视图
     */
    @RequestMapping(value = "", params = "action=create")
    public String createForm(Model model) {
        model.addAttribute("action", "create");
        return getAutoUrl("form");
    }

    /**
     * 新增ReportChannelDepartRel
     *
     * @param vo     ReportChannelDepartRel页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "", method = {RequestMethod.POST})
    public String createReportChannelDepartRel(@Valid ReportChannelDepartRelVo vo, BindingResult result, RedirectAttributes redirectAttributes, Model model) {
        ReportChannelDepartRelEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                ReportChannelDepartRelRequest request = new ReportChannelDepartRelRequest();
                request.setEntity(entity);
                ReportChannelDepartRelResponse response = reportChannelDepartRel
                        .addReportChannelDepartRel(request);
                Integer id = response.getEntity().getId();
                return "redirect:/reportchanneldepartrel/" + id;
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "create");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 删除ReportChannelDepartRel
     *
     * @param id ReportChannelDepartRel页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.DELETE})
    @ResponseStatus(HttpStatus.OK)
    public void delete(@PathVariable String id) {
        if (!StringUtils.isEmpty(id)) {
            if (id.contains(",")) {
                String[] ids = id.split(",");
                for (int i = 0; i < ids.length; i++) {
                    reportChannelDepartRel.deleteReportChannelDepartRelById(Integer.valueOf(ids[i]));
                }
            } else {
                reportChannelDepartRel.deleteReportChannelDepartRelById(Integer.valueOf(id));
            }
        }
    }

    /**
     * 去查看ReportChannelDepartRel
     *
     * @param id ReportChannelDepartRel页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET})
    public String showForm(@PathVariable(value = "id") Integer id, Model model) {
        ReportChannelDepartRelResponse response = reportChannelDepartRel
                .getReportChannelDepartRelById(id);
        model.addAttribute("entity", response.getEntity());
        return getAutoUrl("form");
    }

    /**
     * 去修改ReportChannelDepartRel
     *
     * @param id ReportChannelDepartRel页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET}, params = "action=edit")
    public String updateForm(@PathVariable(value = "id") Integer id, Model model) {
        ReportChannelDepartRelResponse response = reportChannelDepartRel
                .getReportChannelDepartRelById(id);
        model.addAttribute("entity", response.getEntity());
        model.addAttribute("action", "edit");
        return getAutoUrl("form");
    }

    /**
     * 修改ReportChannelDepartRel
     *
     * @param vo     ReportChannelDepartRel页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.POST})
    public String updateReportChannelDepartRel(@Valid ReportChannelDepartRelVo vo, BindingResult result, @PathVariable Integer id, RedirectAttributes redirectAttributes, Model model) {
        ReportChannelDepartRelEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                ReportChannelDepartRelRequest request = new ReportChannelDepartRelRequest();
                request.setEntity(entity);
                @SuppressWarnings("unused")
                ReportChannelDepartRelResponse rersponse = reportChannelDepartRel
                        .updateReportChannelDepartRel(request);
                redirectAttributes.addAttribute("message", "更新成功");
                return "redirect:/reportchanneldepartrel/" + entity.getId();
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "edit");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 查询ReportChannelDepartRel
     *
     * @param request 请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "", method = RequestMethod.GET)
    public String list(Integer number, Model model, HttpServletRequest request) {
        // 获取查询条件
        Map<String, Object> searchParams = Servlets.getParametersStartingWith(request, "search_");
        Page page = new Page();
        if (null != number) {
            page.setCurrentPage(number);
        }
        ReportChannelDepartRelListRequest listRequest = new ReportChannelDepartRelListRequest();
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        ReportChannelDepartRelListResponse response = reportChannelDepartRel.getReportChannelDepartRelList(listRequest);
        model.addAttribute("page", response.getPaging());
        model.addAttribute("reportChannelDepartRels", response.getObjectList());
        model.addAttribute("searchParams", Servlets
                .encodeParameterStringWithPrefix(searchParams, "search_"));
        return getAutoUrl();
    }
}
