package com.house365.web.controller;

import com.house365.beans.entity.CityCallConfig;
import com.house365.beans.entity.CityEntity;
import com.house365.beans.entity.DepartmentEntity;
import com.house365.beans.entity.NewHouseCityEntity;
import com.house365.commons.system.HttpClientUtil;
import com.house365.web.system.controller.BaseController;
import com.house365.web.util.SessionConstants;
import com.house365.ws.beans.util.HResult;
import com.house365.ws.interfaces.server.ICityCallInterface;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Created by Administrator on 2019/5/6.
 */
@Controller
@RequestMapping("/cityCall")
public class CityCallController extends BaseController {

    private static final Logger logger = LoggerFactory.getLogger(CityCallController.class);

    @Autowired
    private ICityCallInterface callInterface;

    /**
     * 判断城市是否有外呼设置
     *
     * @return
     */
    @RequestMapping(value = "/judgeCall")
    @ResponseBody
    public HResult judgeCall(HttpServletRequest request) {
        HResult result = new HResult();
        try {
            DepartmentEntity dept = (DepartmentEntity) request.getSession().getAttribute(SessionConstants.SESSION_CURRNET_DEPT_KEY);
            String cityCode = dept.getDescripition();
            if (StringUtils.isNotBlank(cityCode)) {
                List<CityCallConfig> list = callInterface.queryByCity(cityCode);
                if (CollectionUtils.isEmpty(list)) {
                    result.setStatus(101);
                    result.setErrorMessage("当前城市无外呼配置");
                }
            } else {
                result.setStatus(101);
                result.setErrorMessage("当前城市无外呼配置");
            }
        } catch (Exception e) {
            result.setStatus(101);
            result.setErrorMessage("当前城市无外呼配置");
            e.printStackTrace();
            logger.error("查询城市外呼设置失败", e);
        }
        return result;
    }

    @RequestMapping(value = "/getNewHouseCity")
    @ResponseBody
    public HResult getNewHouseCity() {
        HResult result = new HResult();
        try {
            String url = "http://api.house365.com/xf/newhouse/get_city.php";
            List<NameValuePair> queryParams = new ArrayList<>(10);
            queryParams.add(new BasicNameValuePair("datatype", "json"));
            String data = HttpClientUtil.doGet(url, queryParams);
            if (null != data) {
                JSONArray array = JSONArray.fromObject(data);
                for (int i = 0; i < array.size(); i++) {
                    JSONObject obj = array.getJSONObject(i);
                    String cityName = obj.get("city_name").toString();
                    String cityCode = obj.get("city_key").toString();
                    NewHouseCityEntity entity = new NewHouseCityEntity();
                    entity.setCityCode(cityCode);
                    entity.setCityName(cityName);
                    System.out.println(cityName + "----------" + cityCode);
                    callInterface.save(entity);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("调取新房城市接口失败", e);
        }
        return result;
    }

    @RequestMapping(value = "/updateCity")
    @ResponseBody
    public HResult updateCity() {
        HResult result = new HResult();
        try {
            Map<String, Object> map = new HashMap<>(10);
            List<NewHouseCityEntity> list = callInterface.queryByConditions(map);

            if (CollectionUtils.isNotEmpty(list)) {
                for (NewHouseCityEntity c : list) {
                    String cityCode = c.getCityCode();
                    String cityName = c.getCityName();
                    map.put("cityName", cityName);
                    List<CityEntity> cityList = callInterface.queryCityList(map);
                    if(CollectionUtils.isNotEmpty(cityList)){
                        CityEntity entity = cityList.get(0);
                        if(cityCode.equals(entity.getCityId())){
                            c.setIsSame(1);
                        }else {
                            c.setIsSame(0);
                        }
                    }else {
                        c.setIsSame(2);
                    }
                    callInterface.update(c);
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
            logger.error("更新城市信息失败", e);
        }
        return result;
    }

}
