package com.house365.beans.vo;

import java.io.Serializable;

/**
 * <p>Title: CRM 到访/签约客群分析</p>
 * <p>Description: 到访和签约客户信息</p>
 * <p>Date: 2018/5/4</p>
 *
 * @author XN
 * @version 1.0
 */
public class CrmVisitAndSignCustomer implements Serializable {
    private static final long serialVersionUID = 1L;

    //项目ID
    private String project_id;

    //状态 1到访 2签约
    private String state;

    //月份
    private String month;

    //项目ID
    private String buildingId;
    //经管合同号
    private String contractCode;

    //来源 1全链条 2 CRM
    private String source_form;

    //来源名称
    private String source_name;

    //CRM来源ID
    private String source_id;

    private String phone;

    private String city;

    private String crmId;

    public String getCrmId() {
        return crmId;
    }

    public void setCrmId(String crmId) {
        this.crmId = crmId;
    }

    public String getProject_id() {
        return project_id;
    }

    public void setProject_id(String project_id) {
        this.project_id = project_id;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getMonth() {
        return month;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public String getBuildingId() {
        return buildingId;
    }

    public void setBuildingId(String buildingId) {
        this.buildingId = buildingId;
    }

    public String getSource_form() {
        return source_form;
    }

    public void setSource_form(String source_form) {
        this.source_form = source_form;
    }

    public String getSource_name() {
        return source_name;
    }

    public void setSource_name(String source_name) {
        this.source_name = source_name;
    }

    public String getSource_id() {
        return source_id;
    }

    public void setSource_id(String source_id) {
        this.source_id = source_id;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;

        CrmVisitAndSignCustomer that = (CrmVisitAndSignCustomer) o;

        if (project_id != null ? !project_id.equals(that.project_id) : that.project_id != null)
            return false;
        if (state != null ? !state.equals(that.state) : that.state != null)
            return false;
        if (month != null ? !month.equals(that.month) : that.month != null)
            return false;
        if (buildingId != null ? !buildingId.equals(that.buildingId) : that.buildingId != null)
            return false;
        if (source_form != null ? !source_form.equals(that.source_form) : that.source_form != null)
            return false;
        if (source_name != null ? !source_name.equals(that.source_name) : that.source_name != null)
            return false;
        if (source_id != null ? !source_id.equals(that.source_id) : that.source_id != null)
            return false;
        if (phone != null ? !phone.equals(that.phone) : that.phone != null)
            return false;
        if (city != null ? !city.equals(that.city) : that.city != null)
            return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = project_id != null ? project_id.hashCode() : 0;
        result = 31 * result + (state != null ? state.hashCode() : 0);
        result = 31 * result + (month != null ? month.hashCode() : 0);
        result = 31 * result + (buildingId != null ? buildingId.hashCode() : 0);
        result = 31 * result + (source_form != null ? source_form.hashCode() : 0);
        result = 31 * result + (source_name != null ? source_name.hashCode() : 0);
        result = 31 * result + (source_id != null ? source_id.hashCode() : 0);
        result = 31 * result + (phone != null ? phone.hashCode() : 0);
        result = 31 * result + (city != null ? city.hashCode() : 0);
        return result;
    }
}
