/**
 * Description: 抢客客户推送记录数据库实体/领域对象
 * Copyright:   Copyright (c)2018
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2018-01-09 下午 14:01:42
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2018-01-09   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;

/**
 * 抢客客户推送记录数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2018-01-09
 * @see
 * @since 1.0
 */
public class RushCustomerPushLogEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 抢客客户id
     */
    @NotNull
    private Integer rushCustomerId;

    /**
     * 部门id
     */
    @NotNull
    private Integer departmentId;

    /**
     * 抢客规则id
     */
    @NotNull
    private Integer rushCustomerRuleId;

    /**
     * 抢客关联crm来源
     */
    @NotBlank
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String crmSource;

    /**
     * 抢客关联项目
     */
    @NotBlank
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String project;

    /**
     * 推送时间
     */
    @NotNull
    private java.util.Date createTime;

    //columns END
    /*
	public RushCustomerPushLog(){
	}

	public RushCustomerPushLog(
		Integer id
	){
		this.id = id;
	}

    */

    /**
     * 获取抢客客户id
     * @return 抢客客户id
     */
    public Integer getRushCustomerId() {
        return this.rushCustomerId;
    }

    /**
     * 设置抢客客户id
     * @param rushCustomerId 抢客客户id
     */
    public void setRushCustomerId(Integer rushCustomerId) {
        this.rushCustomerId = rushCustomerId;
    }

    /**
     * 获取部门id
     * @return 部门id
     */
    public Integer getDepartmentId() {
        return this.departmentId;
    }

    /**
     * 设置部门id
     * @param departmentId 部门id
     */
    public void setDepartmentId(Integer departmentId) {
        this.departmentId = departmentId;
    }

    /**
     * 获取抢客规则id
     * @return 抢客规则id
     */
    public Integer getRushCustomerRuleId() {
        return this.rushCustomerRuleId;
    }

    /**
     * 设置抢客规则id
     * @param rushCustomerRuleId 抢客规则id
     */
    public void setRushCustomerRuleId(Integer rushCustomerRuleId) {
        this.rushCustomerRuleId = rushCustomerRuleId;
    }

    /**
     * 获取抢客关联crm来源
     * @return 抢客关联crm来源
     */
    public String getCrmSource() {
        return this.crmSource;
    }

    /**
     * 设置抢客关联crm来源
     * @param crmSource 抢客关联crm来源
     */
    public void setCrmSource(String crmSource) {
        this.crmSource = crmSource;
    }

    /**
     * 获取抢客关联项目
     * @return 抢客关联项目
     */
    public String getProject() {
        return this.project;
    }

    /**
     * 设置抢客关联项目
     * @param project 抢客关联项目
     */
    public void setProject(String project) {
        this.project = project;
    }

    /**
     * 设置推送时间字符串格式
     * @param createTime 推送时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取推送时间
     * @return 推送时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置推送时间
     * @param createTime 推送时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("RushCustomerId", getRushCustomerId())
                .append("DepartmentId", getDepartmentId())
                .append("RushCustomerRuleId", getRushCustomerRuleId())
                .append("CrmSource", getCrmSource())
                .append("Project", getProject())
                .append("CreateTime", getCreateTime())
                .toString();
    }

    /**
     * 获取hash码
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if (obj instanceof RushCustomerPushLogEntity == false) return false;
        if (this == obj) return true;
        RushCustomerPushLogEntity other = (RushCustomerPushLogEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }
}

