/**
 * Description: 角色权限关联数据库实体/领域对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-22 上午 11:32:19
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-22   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import javax.validation.constraints.*;
import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 角色权限关联数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-22
 * @see
 * @since 1.0
 */
public class RolePermissionEntity extends DomainObject{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	//可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
	//columns START
	/**
	 * roleId
	 */
	@NotNull 
	private Integer roleId;
	
	/**
	 * permissionId
	 */
	@NotNull 
	private Integer permissionId;
	
	private String permissionName;
	private String permissionCode;
	private Integer hierarchy;
	
	/**
	 * 创建时间
	 */
	
	private java.util.Date createTime;
	
	/**
	 * 创建人用户ID
	 */
	
	private Integer createUserid;
	
	//columns END
	/*
	public RolePermission(){
	}

	public RolePermission(
		Integer id
	){
		this.id = id;
	}

    */
	
	/**
	 * 设置roleId
	 * @param roleId roleId
	 */
	public void setRoleId(Integer roleId) {
		this.roleId = roleId;
	}

	public Integer getHierarchy() {
		return hierarchy;
	}

	public void setHierarchy(Integer hierarchy) {
		this.hierarchy = hierarchy;
	}

	public String getPermissionName() {
		return permissionName;
	}

	public void setPermissionName(String permissionName) {
		this.permissionName = permissionName;
	}

	public String getPermissionCode() {
		return permissionCode;
	}

	public void setPermissionCode(String permissionCode) {
		this.permissionCode = permissionCode;
	}

	/**
	 * 获取roleId
	 * @return roleId
	 */
	public Integer getRoleId() {
		return this.roleId;
	}

	/**
	 * 设置permissionId
	 * @param permissionId permissionId
	 */
	public void setPermissionId(Integer permissionId) {
		this.permissionId = permissionId;
	}

	/**
	 * 获取permissionId
	 * @return permissionId
	 */
	public Integer getPermissionId() {
		return this.permissionId;
	}

	/**
	 * 设置创建时间
	 * @param createTime 创建时间
	 */
	public void setCreateTime(java.util.Date createTime) {
		this.createTime = createTime;
	}

	/**
	 * 设置创建时间字符串格式
	 * @param createTime 创建时间
	 */
	public void setCreateTimeStr(String createTime) {
		if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
			try {
				this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取创建时间
	 * @return 创建时间
	 */
	public java.util.Date getCreateTime() {
		return this.createTime;
	}

	/**
	 * 设置创建人用户ID
	 * @param createUserid 创建人用户ID
	 */
	public void setCreateUserid(Integer createUserid) {
		this.createUserid = createUserid;
	}

	/**
	 * 获取创建人用户ID
	 * @return 创建人用户ID
	 */
	public Integer getCreateUserid() {
		return this.createUserid;
	}

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("Id",getId())
			.append("RoleId",getRoleId())
			.append("PermissionId",getPermissionId())
			.append("CreateTime",getCreateTime())
			.append("CreateUserid",getCreateUserid())
			.toString();
	}

	/**
	 * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
	 * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof RolePermissionEntity == false) return false;
		if(this == obj) return true;
		RolePermissionEntity other = (RolePermissionEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

