/**
 * Description: 营销日报数据库实体/领域对象
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-08-08 下午 17:15:44
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-08-08   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

/**
 * 营销日报数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-08-08
 * @see
 * @since 1.0
 */
public class ReportMarketingEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 电话接触量
     */

    private Integer callCount;

    /**
     * 电话接通量
     */

    private Integer connectCount;

    /**
     * 意向沉淀量
     */

    private Integer intentBuyCount;

    private Integer twiceVisitedCount;

    private String twiceVisitedProject;

    private String visitedProject;

    public Integer getTwiceVisitedCount() {
        return twiceVisitedCount;
    }

    public void setTwiceVisitedCount(Integer twiceVisitedCount) {
        this.twiceVisitedCount = twiceVisitedCount;
    }

    public String getTwiceVisitedProject() {
        return twiceVisitedProject;
    }

    public void setTwiceVisitedProject(String twiceVisitedProject) {
        this.twiceVisitedProject = twiceVisitedProject;
    }

    public String getVisitedProject() {
        return visitedProject;
    }

    public void setVisitedProject(String visitedProject) {
        this.visitedProject = visitedProject;
    }

    /**
     * 到访量
     */

    private Integer visitedCount;

    /**
     * 认筹量
     */

    private Integer identificationChipsCount;

    /**
     * 认筹项目
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String identificationChipsProject;

    /**
     * 认购量
     */

    private Integer subscriptionCount;

    /**
     * 认购项目
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String subscriptionProject;

    /**
     * 业绩
     */

    private Integer source;

    /**
     * 创建时间
     */

    private java.util.Date createTime;

    /**
     * 部门id
     */

    private Integer departmentId;

    /**
     * 部门名称
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String departmentName;

    /**
     * 职员id
     */

    private Integer userId;

    /**
     * 职员姓名
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String userName;

    /**
     * 报告时间
     */

    private java.util.Date reportTime;

    /**
     * 城市
     */
    private String city;
    //columns END
    /*
	public ReportMarketing(){
	}

	public ReportMarketing(
		Integer id
	){
		this.id = id;
	}

    */

    /**
     * 获取电话接触量
     *
     * @return 电话接触量
     */
    public Integer getCallCount() {
        return this.callCount;
    }

    /**
     * 设置电话接触量
     * @param callCount 电话接触量
     */
    public void setCallCount(Integer callCount) {
        this.callCount = callCount;
    }

    /**
     * 获取电话接通量
     *
     * @return 电话接通量
     */
    public Integer getConnectCount() {
        return this.connectCount;
    }

    /**
     * 设置电话接通量
     * @param connectCount 电话接通量
     */
    public void setConnectCount(Integer connectCount) {
        this.connectCount = connectCount;
    }

    /**
     * 获取意向沉淀量
     *
     * @return 意向沉淀量
     */
    public Integer getIntentBuyCount() {
        return this.intentBuyCount;
    }

    /**
     * 设置意向沉淀量
     * @param intentBuyCount 意向沉淀量
     */
    public void setIntentBuyCount(Integer intentBuyCount) {
        this.intentBuyCount = intentBuyCount;
    }

    /**
     * 获取到访量
     *
     * @return 到访量
     */
    public Integer getVisitedCount() {
        return this.visitedCount;
    }

    /**
     * 设置到访量
     *
     * @param visitedCount 到访量
     */
    public void setVisitedCount(Integer visitedCount) {
        this.visitedCount = visitedCount;
    }

    /**
     * 获取认筹量
     *
     * @return 认筹量
     */
    public Integer getIdentificationChipsCount() {
        return this.identificationChipsCount;
    }

    /**
     * 设置认筹量
     * @param identificationChipsCount 认筹量
     */
    public void setIdentificationChipsCount(Integer identificationChipsCount) {
        this.identificationChipsCount = identificationChipsCount;
    }

    /**
     * 获取认筹项目
     *
     * @return 认筹项目
     */
    public String getIdentificationChipsProject() {
        return this.identificationChipsProject;
    }

    /**
     * 设置认筹项目
     *
     * @param identificationChipsProject 认筹项目
     */
    public void setIdentificationChipsProject(String identificationChipsProject) {
        this.identificationChipsProject = identificationChipsProject;
    }

    /**
     * 获取认购量
     * @return 认购量
     */
    public Integer getSubscriptionCount() {
        return this.subscriptionCount;
    }

    /**
     * 设置认购量
     * @param subscriptionCount 认购量
     */
    public void setSubscriptionCount(Integer subscriptionCount) {
        this.subscriptionCount = subscriptionCount;
    }

    /**
     * 获取认购项目
     * @return 认购项目
     */
    public String getSubscriptionProject() {
        return this.subscriptionProject;
    }

    /**
     * 设置认购项目
     *
     * @param subscriptionProject 认购项目
     */
    public void setSubscriptionProject(String subscriptionProject) {
        this.subscriptionProject = subscriptionProject;
    }

    /**
     * 获取业绩
     *
     * @return 业绩
     */
    public Integer getSource() {
        return this.source;
    }

    /**
     * 设置业绩
     *
     * @param source 业绩
     */
    public void setSource(Integer source) {
        this.source = source;
    }

    /**
     * 设置创建时间字符串格式
     *
     * @param createTime 创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取创建时间
     *
     * @return 创建时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置创建时间
     * @param createTime 创建时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取部门id
     *
     * @return 部门id
     */
    public Integer getDepartmentId() {
        return this.departmentId;
    }

    /**
     * 设置部门id
     * @param departmentId 部门id
     */
    public void setDepartmentId(Integer departmentId) {
        this.departmentId = departmentId;
    }

    /**
     * 获取部门名称
     *
     * @return 部门名称
     */
    public String getDepartmentName() {
        return this.departmentName;
    }

    /**
     * 设置部门名称
     * @param departmentName 部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    /**
     * 获取职员id
     * @return 职员id
     */
    public Integer getUserId() {
        return this.userId;
    }

    /**
     * 设置职员id
     *
     * @param userId 职员id
     */
    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    /**
     * 获取职员姓名
     *
     * @return 职员姓名
     */
    public String getUserName() {
        return this.userName;
    }

    /**
     * 设置职员姓名
     *
     * @param userName 职员姓名
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }

    /**
     * 设置报告时间字符串格式
     *
     * @param reportTime 报告时间
     */
    public void setReportTimeStr(String reportTime) {
        if (!com.house365.web.util.StringUtils.isBlank(reportTime)) {
            try {
                this.reportTime = java.text.DateFormat.getDateTimeInstance().parse(reportTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取报告时间
     *
     * @return 报告时间
     */
    public java.util.Date getReportTime() {
        return this.reportTime;
    }

    /**
     * 设置报告时间
     *
     * @param reportTime 报告时间
     */
    public void setReportTime(java.util.Date reportTime) {
        this.reportTime = reportTime;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("CallCount", getCallCount())
                .append("ConnectCount", getConnectCount())
                .append("IntentBuyCount", getIntentBuyCount())
                .append("VisitedCount", getVisitedCount())
                .append("IdentificationChipsCount", getIdentificationChipsCount())
                .append("IdentificationChipsProject", getIdentificationChipsProject())
                .append("SubscriptionCount", getSubscriptionCount())
                .append("SubscriptionProject", getSubscriptionProject())
                .append("Source", getSource())
                .append("CreateTime", getCreateTime())
                .append("DepartmentId", getDepartmentId())
                .append("DepartmentName", getDepartmentName())
                .append("UserId", getUserId())
                .append("UserName", getUserName())
                .append("ReportTime", getReportTime())
                .toString();
    }

	/**
     * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
     * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof ReportMarketingEntity == false) return false;
		if(this == obj) return true;
		ReportMarketingEntity other = (ReportMarketingEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

