/**
 * Description: 权限数据库实体/领域对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-14 下午 17:27:18
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

/**
 * 权限数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
public class PermissionEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    // 可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    // columns START
    /**
     * 编码
     */
    @Length(max = 50, message = "长度需要大于0且小于50")
    protected String code;

    /**
     * 名称
     */
    @Length(max = 50, message = "长度需要大于0且小于50")
    protected String name;

    /**
     * 父菜单ID
     */

    protected Integer parentId;

    /**
     * 排序
     */

    protected Integer orderNum;

    /**
     * 对应资源
     */
    @Length(max = 500, message = "长度需要大于0且小于500")
    protected String resource;

    /**
     * 1 菜单 2 页面 3 操作
     */

    protected java.lang.Integer type;

    /**
     * 1 admin 0 normal
     */
    protected Boolean special;

    protected Integer hierarchy;

    protected String levelStr;

    /**
     * 创建人用户ID
     */

    protected Integer createUserid;

    /**
     * 创建人用户名
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    protected String createUsername;

    private String isShow;  // 是否在菜单中显示（1：显示；0：不显示）

    private String permission; // 权限标识

    /**
     * 创建时间
     */

    protected java.util.Date createTime;

    /**
     * 创建人电脑IP
     */
    @Length(max = 30, message = "长度需要大于0且小于30")
    protected String createIp;

    /**
     * 最后一次修改人用户ID
     */

    protected Integer updateUserid;

    /**
     * 最后一次修改人用户名
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    protected String updateUsername;

    /**
     * 最后一次修改时间
     */

    protected java.util.Date updateTime;

    /**
     * 最后一次修改人电脑IP
     */
    @Length(max = 30, message = "长度需要大于0且小于30")
    protected String updateIp;

    protected boolean authorized;

    // columns END

    public String getIsShow() {
        return isShow;
    }

    public void setIsShow(String isShow) {
        this.isShow = isShow;
    }

    public String getPermission() {
        return permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public boolean isAuthorized() {
        return authorized;
    }

    public void setAuthorized(boolean authorized) {
        this.authorized = authorized;
    }

    public String getLevelStr() {
        return levelStr;
    }

    public void setLevelStr(String levelStr) {
        this.levelStr = levelStr;
    }

    /**
     * 获取编码
     *
     * @return 编码
     */
    public String getCode() {
        return this.code;
    }

    /**
     * 设置编码
     *
     * @param code 编码
     */
    public void setCode(String code) {
        this.code = code;
    }

    public Integer getHierarchy() {
        return hierarchy;
    }

    public void setHierarchy(Integer hierarchy) {
        this.hierarchy = hierarchy;
    }

    /**
     * 获取名称
     *
     * @return 名称
     */
    public String getName() {
        return this.name;
    }

    /**
     * 设置名称
     *
     * @param name 名称
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 获取父菜单ID
     *
     * @return 父菜单ID
     */
    public Integer getParentId() {
        return this.parentId;
    }

    /**
     * 设置父菜单ID
     *
     * @param parentId 父菜单ID
     */
    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    public Integer getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(Integer orderNum) {
        this.orderNum = orderNum;
    }

    /**
     * 获取对应资源
     *
     * @return 对应资源
     */
    public String getResource() {
        return this.resource;
    }

    /**
     * 设置对应资源
     *
     * @param resource 对应资源
     */
    public void setResource(String resource) {
        this.resource = resource;
    }

    /**
     * 获取1 菜单 2 页面 3 操作
     *
     * @return 1 菜单 2 页面 3 操作
     */
    public java.lang.Integer getType() {
        return this.type;
    }

    /**
     * 设置1 菜单 2 操作
     *
     * @param type 1 菜单 2 操作
     */
    public void setType(java.lang.Integer type) {
        this.type = type;
    }

    /**
     * 获取创建人用户ID
     *
     * @return 创建人用户ID
     */
    public Integer getCreateUserid() {
        return this.createUserid;
    }

    /**
     * 设置创建人用户ID
     *
     * @param createUserid 创建人用户ID
     */
    public void setCreateUserid(Integer createUserid) {
        this.createUserid = createUserid;
    }

    /**
     * 获取创建人用户名
     *
     * @return 创建人用户名
     */
    public String getCreateUsername() {
        return this.createUsername;
    }

    /**
     * 设置创建人用户名
     *
     * @param createUsername 创建人用户名
     */
    public void setCreateUsername(String createUsername) {
        this.createUsername = createUsername;
    }

    /**
     * 设置创建时间字符串格式
     *
     * @param createTime 创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    public Boolean getSpecial() {
        return special;
    }

    public void setSpecial(Boolean special) {
        this.special = special;
    }

    /**
     * 获取创建时间
     *
     * @return 创建时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置创建时间
     *
     * @param createTime 创建时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取创建人电脑IP
     *
     * @return 创建人电脑IP
     */
    public String getCreateIp() {
        return this.createIp;
    }

    /**
     * 设置创建人电脑IP
     *
     * @param createIp 创建人电脑IP
     */
    public void setCreateIp(String createIp) {
        this.createIp = createIp;
    }

    /**
     * 获取最后一次修改人用户ID
     *
     * @return 最后一次修改人用户ID
     */
    public Integer getUpdateUserid() {
        return this.updateUserid;
    }

    /**
     * 设置最后一次修改人用户ID
     *
     * @param updateUserid 最后一次修改人用户ID
     */
    public void setUpdateUserid(Integer updateUserid) {
        this.updateUserid = updateUserid;
    }

    /**
     * 获取最后一次修改人用户名
     *
     * @return 最后一次修改人用户名
     */
    public String getUpdateUsername() {
        return this.updateUsername;
    }

    /**
     * 设置最后一次修改人用户名
     *
     * @param updateUsername 最后一次修改人用户名
     */
    public void setUpdateUsername(String updateUsername) {
        this.updateUsername = updateUsername;
    }

    /**
     * 设置最后一次修改时间字符串格式
     *
     * @param updateTime 最后一次修改时间
     */
    public void setUpdateTimeStr(String updateTime) {
        if (!com.house365.web.util.StringUtils.isBlank(updateTime)) {
            try {
                this.updateTime = java.text.DateFormat.getDateTimeInstance().parse(updateTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取最后一次修改时间
     *
     * @return 最后一次修改时间
     */
    public java.util.Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * 设置最后一次修改时间
     *
     * @param updateTime 最后一次修改时间
     */
    public void setUpdateTime(java.util.Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取最后一次修改人电脑IP
     *
     * @return 最后一次修改人电脑IP
     */
    public String getUpdateIp() {
        return this.updateIp;
    }

    /**
     * 设置最后一次修改人电脑IP
     *
     * @param updateIp 最后一次修改人电脑IP
     */
    public void setUpdateIp(String updateIp) {
        this.updateIp = updateIp;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("Code",
                                                                                                      getCode()).append(
            "Name", getName()).append("ParentId", getParentId()).append("OrderNum", getOrderNum()).append("Resource",
                                                                                                          getResource()).append(
            "Type", getType()).append("CreateUserid", getCreateUserid()).append("CreateUsername",
                                                                                getCreateUsername()).append(
            "CreateTime", getCreateTime()).append("CreateIp", getCreateIp()).append("UpdateUserid",
                                                                                    getUpdateUserid()).append(
            "UpdateUsername", getUpdateUsername()).append("UpdateTime", getUpdateTime()).append("UpdateIp",
                                                                                                getUpdateIp()).toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if (obj instanceof PermissionEntity == false)
            return false;
        if (this == obj)
            return true;
        PermissionEntity other = (PermissionEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }

}
