package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

/**
 * Dictionary数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-08-30
 * @see
 * @since 1.0
 */
public class DictionaryEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * dicKey
     */
    @NotBlank
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String dicKey;

    /**
     * dicValue
     */
    @NotBlank
    private String dicValue;

    private String seleted;//1:选中,0未选中

    public String getSeleted() {
        return seleted;
    }

    public void setSeleted(String seleted) {
        this.seleted = seleted;
    }

    /**
     * dicName
     */
    @NotBlank
    @Length(max = 200, message = "长度需要大于0且小于200")
    private String dicName;

    /**
     * city
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String city;

    /**
     * 获取dicKey
     *
     * @return dicKey
     */
    public String getDicKey() {
        return this.dicKey;
    }

    /**
     * 设置dicKey
     *
     * @param dicKey dicKey
     */
    public void setDicKey(String dicKey) {
        this.dicKey = dicKey;
    }

    /**
     * 获取dicValue
     *
     * @return dicValue
     */
    public String getDicValue() {
        return this.dicValue;
    }

    /**
     * 设置dicValue
     *
     * @param dicValue dicValue
     */
    public void setDicValue(String dicValue) {
        this.dicValue = dicValue;
    }

    /**
     * 获取dicName
     *
     * @return dicName
     */
    public String getDicName() {
        return this.dicName;
    }

    /**
     * 设置dicName
     *
     * @param dicName dicName
     */
    public void setDicName(String dicName) {
        this.dicName = dicName;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("DicKey", getDicKey())
                .append("DicValue", getDicValue())
                .append("DicName", getDicName())
                .append("City", getCity())
                .toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DictionaryEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DictionaryEntity other = (DictionaryEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }
}

