/**
 * Description: 客户-置业顾问关联数据库实体/领域对象
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2017-03-14 下午 13:43:59
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-03-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import javax.validation.constraints.*;
import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 客户-置业顾问关联数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-03-14
 * @see
 * @since 1.0
 */
public class CustomerUserEntity extends DomainObject{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	//可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
	//columns START
	/**
	 * customerId
	 */
	@NotNull 
	private Integer customerId;
	
	/**
	 * userId
	 */
	@NotNull 
	private Integer userId;
	
	/**
	 * 是否星标客户-微信端展示用 1是0否
	 */
	
	private Integer star;
	
	/**
	 * createTime
	 */
	@NotNull 
	private java.util.Date createTime;

	/**
	 * 设置customerId
	 * @param customerId customerId
	 */
	public void setCustomerId(Integer customerId) {
		this.customerId = customerId;
	}

	/**
	 * 获取customerId
	 * @return customerId
	 */
	public Integer getCustomerId() {
		return this.customerId;
	}

	/**
	 * 设置userId
	 * @param userId userId
	 */
	public void setUserId(Integer userId) {
		this.userId = userId;
	}

	/**
	 * 获取userId
	 * @return userId
	 */
	public Integer getUserId() {
		return this.userId;
	}

	/**
	 * 设置是否星标客户-微信端展示用 1是0否
	 * @param star 是否星标客户-微信端展示用 1是0否
	 */
	public void setStar(Integer star) {
		this.star = star;
	}

	/**
	 * 获取是否星标客户-微信端展示用 1是0否
	 * @return 是否星标客户-微信端展示用 1是0否
	 */
	public Integer getStar() {
		return this.star;
	}

	/**
	 * 设置createTime
	 * @param createTime createTime
	 */
	public void setCreateTime(java.util.Date createTime) {
		this.createTime = createTime;
	}

	/**
	 * 设置createTime字符串格式
	 * @param createTime createTime
	 */
	public void setCreateTimeStr(String createTime) {
		if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
			try {
				this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取createTime
	 * @return createTime
	 */
	public java.util.Date getCreateTime() {
		return this.createTime;
	}

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("Id",getId())
			.append("CustomerId",getCustomerId())
			.append("UserId",getUserId())
			.append("Star",getStar())
			.append("CreateTime",getCreateTime())
			.toString();
	}

	/**
	 * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
	 * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof CustomerUserEntity == false) return false;
		if(this == obj) return true;
		CustomerUserEntity other = (CustomerUserEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

