package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotNull;

/**
 * 客户回访内容模板实体类
 */
public class CustomerCallbackTemplateEntity extends DomainObject {

    private static final long serialVersionUID = 1L;

    /**
     * 城市key
     */
    @NotNull
    private String cityKey;

    /**
     * 回访内容
     */
    @NotNull
    private String content;

    public String getCityKey() {
        return cityKey;
    }

    public void setCityKey(String cityKey) {
        this.cityKey = cityKey;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("CityKey", getCityKey())
                .append("Content", getContent())
                .toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if (obj instanceof CustomerCallbackTemplateEntity == false) return false;
        if (this == obj) return true;
        CustomerCallbackTemplateEntity other = (CustomerCallbackTemplateEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }
}

