/*
 * Copyright (C), 2002-2015, 江苏三六五网络股份有限公司
 * FileName: BaseAttachmentType.java
 * Author:   duhui
 * Date:     2015年1月18日 下午1:44:28
 * Description:     
 * History: 
 * <author>      <time>      <version>    <desc>
 * 修改人姓名                          修改时间                        版本号                                 描述
 */
package com.house365.beans.entity;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import com.house365.beans.system.DomainObject;

/**
 * 上传文件类型
 *
 * @author duhui
 * @version [v1.0.0, 2015年1月18日]
 * @see [相关类/方法]（可选）
 * @since [产品/模块版本] （可选）
 */
public class BaseAttachmentType extends DomainObject{
    
    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    
    /**
     * 文件类型
     */
    @Length(max=300)
    private java.lang.String name;
    
    /**
     * 文件后缀
     */
    @Length(max=90)
    private java.lang.String suffix;
    
    /**
     * 备注
     */
    @Length(max=100)
    private java.lang.String remark; 
    
    /**
     * 设置文件类型
     * @param name 文件类型
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * 获取文件类型
     * @return 文件类型
     */
    public java.lang.String getName() {
        return this.name;
    }

    /**
     * 设置文件后缀
     * @param suffix 文件后缀
     */
    public void setSuffix(java.lang.String suffix) {
        this.suffix = suffix;
    }

    /**
     * 获取文件后缀
     * @return 文件后缀
     */
    public java.lang.String getSuffix() {
        return this.suffix;
    }

    /**
     * 设置备注
     * @param remark 备注
     */
    public void setRemark(java.lang.String remark) {
        this.remark = remark;
    }

    /**
     * 获取备注
     * @return 备注
     */
    public java.lang.String getRemark() {
        return this.remark;
    }
    
    
    
    /**
     * 实体的toString方法
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
            .append("Id",getId())
            .append("Name",getName())
            .append("Suffix",getSuffix())
            .append("Remark",getRemark())
            .toString();
    }

    /**
     * 获取hash码
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder()
            .append(getId())
            .toHashCode();
    }

    /**
     * 对象比较
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if(obj instanceof BaseAttachmentType == false) return false;
        if(this == obj) return true;
        BaseAttachmentType other = (BaseAttachmentType)obj;
        return new EqualsBuilder()
            .append(getId(),other.getId())
            .isEquals();
    }
    

}
