package com.house365.beans.common;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Date: 2017/12/1</p>
 *
 * @author XN
 * @version 1.0
 */
public class HGSConstant {
    public static final String CACHE_DICT = "dict_";
    public static final String CACHE_DICT_LIST = "dict_list_";
    //Redis字段
    public static final String RUSH_CUSTOMER_LEFT_LIST = "rushCustomer:left:list:";

    /**
     * 跟踪状态：有效
     */
    static final public int TRACE_STATUS_INVALID = 1;

    //购房意向
    public static enum BUYINTENTIONENUM {
        A("1", "A"), B("2", "B"), C("3", "C"), D("4", "D"), E("5", "E");

        private String code;
        private String name;

        BUYINTENTIONENUM(String code, String name) {
            this.code = code;
            this.name = name;
        }

        /**
         * @return the msg
         */
        public String getCode() {
            return code;
        }

        /**
         * @param msg the msg to set
         */
        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    //crm 同步状态 1 已同步 0 未同步
    public static enum CrmSyncStatus {
        DONE("1"), WAIT("0");

        private String type;

        CrmSyncStatus(String type) {
            this.type = type;
        }

        /**
         * @return the msg
         */
        public String getType() {
            return type;
        }

        /**
         * @param
         */
        public void setType(String type) {
            this.type = type;
        }
    }

    //客户来源类型 1：常规；2：抢客；3：营销；
    public static enum CustomerSourceType {
        NORMAL(1), ROB(2), MARKET(3);

        private Integer type;

        CustomerSourceType(Integer type) {
            this.type = type;
        }

        /**
         * @return the msg
         */
        public Integer getType() {
            return type;
        }

        /**
         * @param
         */
        public void setType(Integer type) {
            this.type = type;
        }
    }

    public static enum CustomerTypeEnum {
        ONLINE(1), OFFLINE(0);

        private Integer msg;

        CustomerTypeEnum(Integer msg) {
            this.msg = msg;
        }

        /**
         * @return the msg
         */
        public Integer getMsg() {
            return msg;
        }

        /**
         * @param msg the msg to set
         */
        public void setMsg(Integer msg) {
            this.msg = msg;
        }
    }

    //客户营销状态 1：常规；2：删除；3：草稿；进入第二步没有导入数据
    public static enum ActivityStatus {
        NORMAL(1), DELETE(2), DRAFT(3);

        private Integer status;

        ActivityStatus(Integer status) {
            this.status = status;
        }

        /**
         * @return the msg
         */
        public Integer getStatus() {
            return status;
        }

        /**
         * @param
         */
        public void setStatus(Integer status) {
            this.status = status;
        }
    }


    /**
     * 客户来源
     */
    public static enum CustomerSourceEnum {
        CRM("CRM"), SYSTEM("SYSTEM"), MANAGE("MANAGE"), HOTLINE("HOTLINE"), WECHAT("WECHAT");

        private String msg;

        CustomerSourceEnum(String msg) {
            this.msg = msg;
        }

        /**
         * @return the msg
         */
        public String getMsg() {
            return msg;
        }

        /**
         * @param msg the msg to set
         */
        public void setMsg(String msg) {
            this.msg = msg;
        }
    }

    /**
     * 状态 0 未约看 1 约看、2 到访、3 认筹、4 认购、5 签约、6 退房
     */
    public static enum CustomerStatusEnum {
        NORECORD("未约看", 0), RECORDED("约看", 1), VISITED("到访", 2), ORDERED("认筹", 3), BUY("认购", 4), SING("签约", 5), CANCEL(
            "退房", 6);

        private String msg;
        private int status;

        CustomerStatusEnum(String msg, int status) {
            this.msg = msg;
            this.status = status;
        }

        public static String getMsgByStatus(int i) {
            switch (i) {
                case 0:
                    return NORECORD.getMsg();
                case 1:
                    return RECORDED.getMsg();
                case 2:
                    return VISITED.getMsg();
                case 3:
                    return ORDERED.getMsg();
                case 4:
                    return BUY.getMsg();
                case 5:
                    return SING.getMsg();
                case 6:
                    return CANCEL.getMsg();
                default:
                    return "";
            }
        }

        /**
         * @return the msg
         */
        public String getMsg() {
            return msg;
        }

        /**
         * @param msg the msg to set
         */
        public void setMsg(String msg) {
            this.msg = msg;
        }

        /**
         * @return the status
         */
        public int getStatus() {
            return status;
        }

        /**
         * @param status the status to set
         */
        public void setStatus(int status) {
            this.status = status;
        }
    }


}
