/**
 * Description: StatusSourceStatistics业务实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-11-02 下午 17:54:57
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-11-02   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.StatusSourceStatisticsEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IStatusSourceStatisticsDao;
import com.house365.ws.service.interfaces.IStatusSourceStatisticsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * StatusSourceStatistics业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-11-02
 * @see
 * @since 1.0
 */
@Service("statusSourceStatisticsService")
public class StatusSourceStatisticsServiceImpl<T extends StatusSourceStatisticsEntity> extends DefaultServiceImpl<T> implements IStatusSourceStatisticsService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IStatusSourceStatisticsDao<T> statusSourceStatisticsDao;

    @Override
    protected Dao<T> getDao() {
        return statusSourceStatisticsDao;
    }

    @Override
    public List<Map> statisticCustomer(QueryParams para) {
        return statusSourceStatisticsDao.statisticCustomer(para);
    }

    @Override
    public List<Map> statisticCustomerByWeek(QueryParams<T> queryParams) {
        return statusSourceStatisticsDao.statisticCustomerByWeek(queryParams);
    }

    @Override
    public List<Map> statisticCustomerByMonth(QueryParams<T> queryParams) {
        return statusSourceStatisticsDao.statisticCustomerByMonth(queryParams);
    }

    @Override
    public List<Map> statisticStatusSource(QueryParams para) {
        return statusSourceStatisticsDao.statisticStatusSource(para);
    }

    @Override
    public List<Map> statisticStatusSourceByWeek(QueryParams<T> queryParams) {
        return statusSourceStatisticsDao.statisticStatusSourceByWeek(queryParams);
    }

    @Override
    public List<Map> statisticStatusSourceByMonth(QueryParams<T> queryParams) {
        return statusSourceStatisticsDao.statisticStatusSourceByMonth(queryParams);
    }

    @Override
    public void updateNames() {
        statusSourceStatisticsDao.updateProjectName();
        statusSourceStatisticsDao.updateCityName();
        statusSourceStatisticsDao.updateSourceName();
    }

    @Override
    public void deleteByDate(String startDateStr) {
        statusSourceStatisticsDao.deleteByDate(startDateStr);
    }
}
