/**
 * Description: 营销日报业务实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-07-17 下午 13:27:32
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-07-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.ReportMarketingEntity;
import com.house365.beans.po.ReportDailyPo;
import com.house365.beans.system.QueryParams;
import com.house365.beans.vo.ReportMarketingFormVo;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IReportMarketingDao;
import com.house365.ws.service.interfaces.IReportMarketingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 营销日报业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-07-17
 * @see
 * @since 1.0
 */
@Service("reportMarketingService")
public class ReportMarketingServiceImpl<T extends ReportMarketingEntity> extends DefaultServiceImpl<T> implements IReportMarketingService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IReportMarketingDao<T> reportMarketingDao;

    @Override
    protected Dao<T> getDao() {
        return reportMarketingDao;
    }

    @Override
    public List<ReportDailyPo> getDailies(String startTime, String endTime, String city, List<Integer> userIds) {
        Map<String, Object> param = new HashMap<>();
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        param.put("userIds", userIds);
        param.put("city", city);
        return reportMarketingDao.getDailies(param);
    }

    @Override
    public List<ReportMarketingFormVo> statistic(QueryParams<?> queryParams) {
        return reportMarketingDao.statistic(queryParams);
    }

    @Override
    public List<ReportMarketingEntity> getByUserId(Integer userId, String reportTime) {
        Map<String, Object> param = new HashMap<>();
        param.put("reportTime", reportTime);
        param.put("userId", userId);
        return reportMarketingDao.getByUserId(param);
    }

    @Override
    public void updateByUserId(ReportMarketingEntity reportmarketingentity) {
        reportMarketingDao.updateByUserId(reportmarketingentity);
    }
}