package com.house365.ws.service.impl;

import com.house365.beans.entity.CustomerCallbackRecordEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.ICustomerCallbackRecordDao;
import com.house365.ws.service.interfaces.ICustomerCallbackRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 回访记录service实现
 *
 * @author Administrator
 * @date 2018/6/26
 */
@Service("customerCallbackRecordService")
public class CustomerCallbackRecordServiceImpl<T extends CustomerCallbackRecordEntity> extends DefaultServiceImpl<T> implements ICustomerCallbackRecordService<T> {

    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private ICustomerCallbackRecordDao<CustomerCallbackRecordEntity> customerCallbackRecordDao;

    @Override
    protected Dao<T> getDao() {
        return null;
    }

    @Override
    public List<CustomerCallbackRecordEntity> queryCallbackRecord(QueryParams<CustomerCallbackRecordEntity> queryParams) {

        return customerCallbackRecordDao.queryByPage(queryParams);
        //return customerCallbackRecordDao.queryCallbackRecord(queryParams);
    }
}
