/**
 * Description: 抢客规则WS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-11-28 下午 13:41:47
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-11-28   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.RushCustomerRuleEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.RushCustomerRuleListRequest;
import com.house365.ws.beans.request.RushCustomerRuleRequest;
import com.house365.ws.beans.response.RushCustomerRuleListResponse;
import com.house365.ws.beans.response.RushCustomerRuleResponse;
import com.house365.ws.interfaces.server.IRushCustomerRule;
import com.house365.ws.interfaces.server.IRushCustomerRuleDepartmentRel;
import com.house365.ws.service.interfaces.IRushCustomerRuleService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 抢客规则WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-11-28
 * @see
 * @since 1.0
 */
@Service("rushCustomerRule")
public class RushCustomerRuleImpl implements IRushCustomerRule {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(RushCustomerRuleImpl.class);

    /**
     * 抢客规则服务对象
     */
    @Autowired
    IRushCustomerRuleService<RushCustomerRuleEntity> rushCustomerRuleService;
    @Autowired
    IRushCustomerRuleDepartmentRel ruleDepartmentRel;

    /**
     * 抢客规则列表查询
     *
     * @param request 抢客规则列表查询请求
     * @return 抢客规则列表查询响应
     */
    @Override
    public RushCustomerRuleListResponse getRushCustomerRuleList(RushCustomerRuleListRequest request) {
        RushCustomerRuleListResponse response = new RushCustomerRuleListResponse();
        try {
            QueryParams<RushCustomerRuleEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            List<RushCustomerRuleEntity> rushCustomerRules = rushCustomerRuleService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(rushCustomerRules);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存抢客规则
     *
     * @param request 抢客规则请求
     * @return 保存抢客规则响应
     */
    @Override
    public RushCustomerRuleResponse addRushCustomerRule(RushCustomerRuleRequest request) {
        RushCustomerRuleResponse response = new RushCustomerRuleResponse();
        try {
            RushCustomerRuleEntity entity = request.getEntity();
            rushCustomerRuleService.save(entity);

            ruleDepartmentRel.saveDepartmentRuleRel(entity.getId(), entity.getDepartment());

            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除抢客规则通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除抢客规则响应
     */
    @Override
    public RushCustomerRuleResponse deleteRushCustomerRuleById(Integer id) {
        RushCustomerRuleResponse response = new RushCustomerRuleResponse();
        try {
            rushCustomerRuleService.delete(id);

            ruleDepartmentRel.deleteDepartmentRuleRelByRuleId(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改抢客规则
     *
     * @param request 修改抢客规则请求
     * @return 修改抢客规则响应
     */
    @Override
    public RushCustomerRuleResponse updateRushCustomerRule(RushCustomerRuleRequest request) {
        RushCustomerRuleResponse response = new RushCustomerRuleResponse();
        try {
            RushCustomerRuleEntity entity = request.getEntity();
            rushCustomerRuleService.update(entity);

            ruleDepartmentRel.saveDepartmentRuleRel(entity.getId(), entity.getDepartment());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取抢客规则
     *
     * @param id 唯一标识
     * @return 通过ID获取抢客规则响应
     */
    @Override
    public RushCustomerRuleResponse getRushCustomerRuleById(Integer id) {
        RushCustomerRuleResponse response = new RushCustomerRuleResponse();
        try {
            RushCustomerRuleEntity entity = rushCustomerRuleService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    public void changeRuleStatus(Integer ruleId, Integer status, Integer userId, String userName) {
        RushCustomerRuleEntity entity = rushCustomerRuleService.getById(ruleId);
        entity.setStatus(status);
        entity.setUpdateTime(new Date());
        entity.setUpdateUserId(userId);
        entity.setUpdateUserName(userName);
        rushCustomerRuleService.update(entity);
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
