/**
 * Description: 营销日报WS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-07-17 下午 13:27:32
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-07-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.ReportMarketingEntity;
import com.house365.beans.po.ReportDailyPo;
import com.house365.beans.system.QueryParams;
import com.house365.beans.vo.ReportMarketingFormVo;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.ReportMarketingListRequest;
import com.house365.ws.beans.request.ReportMarketingRequest;
import com.house365.ws.beans.response.ReportMarketingListResponse;
import com.house365.ws.beans.response.ReportMarketingResponse;
import com.house365.ws.interfaces.server.IReportMarketing;
import com.house365.ws.service.interfaces.IReportMarketingService;
import com.house365.ws.system.House365SearchResponse;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 营销日报WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-07-17
 * @see
 * @since 1.0
 */
@Service("reportMarketing")
public class ReportMarketingImpl implements IReportMarketing {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportMarketingImpl.class);

    /**
     * 营销日报服务对象
     */
    @Autowired
    IReportMarketingService<ReportMarketingEntity> reportMarketingService;

    /**
     * 营销日报列表查询
     *
     * @param request 营销日报列表查询请求
     * @return 营销日报列表查询响应
     */
    @Override
    public ReportMarketingListResponse getReportMarketingList(
            ReportMarketingListRequest request) {
        ReportMarketingListResponse response = new ReportMarketingListResponse();
        try {
            QueryParams<ReportMarketingEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            List<ReportMarketingEntity> reportMarketings = reportMarketingService.queryByPage(queryParams);
            if (reportMarketings != null && reportMarketings.size() > 0) {
                for (ReportMarketingEntity rme : reportMarketings) {
                    Integer callCount = rme.getCallCount();
                    Integer connectCount = rme.getConnectCount();
                    Integer intentBuyCount = rme.getIntentBuyCount();
                    if (callCount == null || "".equals(callCount) || connectCount == null || "".equals(connectCount) ||
                            intentBuyCount == null || "".equals(intentBuyCount)) {
                        callCount = 0;
                        rme.setCallCount(callCount);
                    }
                    if (connectCount == null || "".equals(connectCount)) {
                        connectCount = 0;
                        rme.setConnectCount(connectCount);
                    }
                    if (intentBuyCount == null || "".equals(intentBuyCount)) {
                        intentBuyCount = 0;
                        rme.setIntentBuyCount(intentBuyCount);
                    }
                }
            }
            response.setPaging(queryParams.getPaging());
            response.setObjectList(reportMarketings);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存营销日报
     *
     * @param request 营销日报请求
     * @return 保存营销日报响应
     */
    @Override
    public ReportMarketingResponse addReportMarketing(ReportMarketingRequest request) {
        ReportMarketingResponse response = new ReportMarketingResponse();
        try {
            ReportMarketingEntity entity = request.getEntity();
            reportMarketingService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除营销日报通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除营销日报响应
     */
    @Override
    public ReportMarketingResponse deleteReportMarketingById(Integer id) {
        ReportMarketingResponse response = new ReportMarketingResponse();
        try {
            reportMarketingService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改营销日报
     *
     * @param request 修改营销日报请求
     * @return 修改营销日报响应
     */
    @Override
    public ReportMarketingResponse updateReportMarketing(
            ReportMarketingRequest request) {
        ReportMarketingResponse response = new ReportMarketingResponse();
        try {
            reportMarketingService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取营销日报
     *
     * @param id 唯一标识
     * @return 通过ID获取营销日报响应
     */
    @Override
    public ReportMarketingResponse getReportMarketingById(Integer id) {
        ReportMarketingResponse response = new ReportMarketingResponse();
        try {
            ReportMarketingEntity entity = reportMarketingService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    public List<ReportDailyPo> getDailies(String startTime, String endTime, List<Integer> userIds, String city) {
        return reportMarketingService.getDailies(startTime, endTime, city, userIds);
    }

    @Override
    public House365SearchResponse statistic(ReportMarketingListRequest request) {
        House365SearchResponse response = new House365SearchResponse();
        try {
            QueryParams queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<ReportMarketingFormVo> localReports = reportMarketingService.statistic(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(localReports);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
