package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.BaseAttachment;
import com.house365.beans.entity.CityEntity;
import com.house365.beans.entity.ReportAttachEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.ws.beans.response.AttachmentListResponse;
import com.house365.ws.beans.util.HResult;
import com.house365.ws.dao.mapper.CityMapper;
import com.house365.ws.dao.mapper.ReportAttachMapper;
import com.house365.ws.interfaces.server.IAttachmentInterface;
import com.house365.ws.interfaces.server.IReportAttachInterface;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @author Created by Administrator on 2020/4/21.
 */
@Service("reportAttach")
public class ReportAttachImpl implements IReportAttachInterface {

    private static final Logger logger = LoggerFactory.getLogger(ReportAttachImpl.class);

    @Autowired
    private ReportAttachMapper mapper;
    @Autowired
    private CityMapper cityMapper;
    @Autowired
    private IAttachmentInterface attachmentService;

    @Override
    public List<ReportAttachEntity> queryByConditions(Map<String, Object> map) {
        List<ReportAttachEntity> list = mapper.queryByConditions(map);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public HResult save(ReportAttachEntity entity) {
        HResult result = new HResult();
        try {
            Map<String, Object> searchMap = new HashMap<>(10);
            List<CityEntity> cityList = cityMapper.queryList(searchMap);
            List<ReportAttachEntity> list;
            if (CollectionUtils.isNotEmpty(cityList)) {
                for (CityEntity c : cityList) {
                    entity.setCity(c.getCityId());
                    entity.setUrl("");
                    entity.setLink("");
                    Map<String, Object> map = new HashMap<>(5);
                    map.put("city", c.getCityId());
                    map.put("name", "市场解读");
                    list = mapper.queryByConditions(map);
                    if (CollectionUtils.isEmpty(list)) {
                        entity.setName("市场解读");
                        mapper.save(entity);
                    }
                    map.put("name", "购房政策");
                    list = mapper.queryByConditions(map);
                    if (CollectionUtils.isEmpty(list)) {
                        entity.setName("购房政策");
                        mapper.save(entity);
                    }
                    map.put("name", "广告图");
                    list = mapper.queryByConditions(map);
                    if (CollectionUtils.isEmpty(list)) {
                        entity.setName("广告图");
                        mapper.save(entity);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("新增置业报告资质失败", e);
            result.setStatus(500);
        }
        return result;
    }

    @Override
    public HResult update(ReportAttachEntity entity, UserEntity userEntity) {
        HResult result = new HResult();
        try {
            ReportAttachEntity oldEntity = mapper.getById(entity.getId());
            String name = oldEntity.getName();
            AttachmentListResponse response = null;
            if ("市场解读".equals(name)) {
                response = attachmentService.queryByResourceIdAndResouceType(String.valueOf(entity.getId()), "report_attach_market");
            } else if ("购房政策".equals(name)) {
                response = attachmentService.queryByResourceIdAndResouceType(String.valueOf(entity.getId()), "report_attach_buy");
            } else if ("广告图".equals(name)) {
                response = attachmentService.queryByResourceIdAndResouceType(String.valueOf(entity.getId()), "report_attach_ad");
            }
            if (response != null && CollectionUtils.isNotEmpty(response.getObjectList())) {
                BaseAttachment attachment = (BaseAttachment) response.getObjectList().get(0);
                String url = attachment.getRemotePath();
                oldEntity.setUrl(url);
            }else {
                oldEntity.setUrl("");
            }
            if(StringUtils.isNotBlank(entity.getLink())) {
                oldEntity.setLink(entity.getLink());
            }else {
                oldEntity.setLink("");
            }
            oldEntity.setUpdateTime(new Date());
            oldEntity.setUpdateId(userEntity.getId());
            oldEntity.setUpdateName(userEntity.getRealName());
            mapper.update(oldEntity);
        } catch (Exception e) {
            e.printStackTrace();
            result.setStatus(500);
            result.setErrorMessage("更新资质失败");
        }
        return result;
    }
}
