/**
 * Description: 客户状态变更纪录WS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-15 下午 15:36:20
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CustomerStatusLogEntity;
import com.house365.beans.po.ProjectSrouceParaPo;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CustomerStatusLogListRequest;
import com.house365.ws.beans.request.CustomerStatusLogRequest;
import com.house365.ws.beans.response.CustomerStatusLogListResponse;
import com.house365.ws.beans.response.CustomerStatusLogResponse;
import com.house365.ws.interfaces.server.ICustomerStatusLog;
import com.house365.ws.service.interfaces.ICustomerStatusLogService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

//import org.house365.core.support.QueryParams;

/**
 * 客户状态变更纪录WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-15
 * @see
 * @since 1.0
 */
@Service("customerStatusLog")
public class CustomerStatusLogImpl implements ICustomerStatusLog {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory
            .getLogger(CustomerStatusLogImpl.class);

    /**
     * 客户状态变更纪录服务对象
     */
    @Autowired
    ICustomerStatusLogService<CustomerStatusLogEntity> customerStatusLogService;

    @Override
    public List<Map<String, Long>> getProjectTransform(Map<String, Object> map) {
        return customerStatusLogService.getProjectTransform(map);
    }

    @Override
    public List<Map<String, Object>> getProjectSource(ProjectSrouceParaPo map) {
        return customerStatusLogService.getProjectSource(map);
    }

    /**
     * 客户状态变更纪录列表查询
     *
     * @param request
     *            客户状态变更纪录列表查询请求
     * @return 客户状态变更纪录列表查询响应
     */
    @Override
    public CustomerStatusLogListResponse getCustomerStatusLogList(CustomerStatusLogListRequest request) {
        CustomerStatusLogListResponse response = new CustomerStatusLogListResponse();
        try {
            QueryParams<CustomerStatusLogEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<CustomerStatusLogEntity> customerStatusLogs = customerStatusLogService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(customerStatusLogs);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存客户状态变更纪录
     *
     * @param request  客户状态变更纪录请求
     * @return 保存客户状态变更纪录响应
     */
    @Override
    public CustomerStatusLogResponse addCustomerStatusLog(CustomerStatusLogRequest request) {
        CustomerStatusLogResponse response = new CustomerStatusLogResponse();
        try {
            CustomerStatusLogEntity entity = request.getEntity();
            customerStatusLogService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除客户状态变更纪录通过唯一标识
     *
     * @param id    唯一标识
     * @return 删除客户状态变更纪录响应
     */
    @Override
    public CustomerStatusLogResponse deleteCustomerStatusLogById(Integer id) {
        CustomerStatusLogResponse response = new CustomerStatusLogResponse();
        try {
            customerStatusLogService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改客户状态变更纪录
     *
     * @param request
     *            修改客户状态变更纪录请求
     * @return 修改客户状态变更纪录响应
     */
    @Override
    public CustomerStatusLogResponse updateCustomerStatusLog(CustomerStatusLogRequest request) {
        CustomerStatusLogResponse response = new CustomerStatusLogResponse();
        try {
            customerStatusLogService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取客户状态变更纪录
     *
     * @param id
     *            唯一标识
     * @return 通过ID获取客户状态变更纪录响应
     */
    @Override
    public CustomerStatusLogResponse getCustomerStatusLogById(Integer id) {
        CustomerStatusLogResponse response = new CustomerStatusLogResponse();
        try {
            CustomerStatusLogEntity entity = customerStatusLogService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
