/**
 * Description: ProjectUser数据访问接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-18 上午 10:05:26
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.interfaces;

import com.house365.beans.entity.ProjectEntity;
import com.house365.beans.entity.ProjectUserEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.dao.system.interfaces.Dao;

import java.util.List;

/**
 * ProjectUser数据访问接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-18
 * @see
 * @since 1.0
 */
public interface IProjectUserDao<T extends ProjectUserEntity> extends Dao<T> {
    List<UserEntity> queryUserByPrjId(Integer projectId);

    List<UserEntity> getProjectUser(List<Integer> projectIds);

    public List<ProjectEntity> getProjectByUserId(Integer userId, String cityCode);

    List<ProjectEntity> getProjectByUserIdAndStatus(Integer userId, String cityCode, String showStatus);
}
