/**
 * Description: 营销活动数据访问接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2017-12-05 下午 19:20:59
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-05   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.interfaces;

import com.house365.beans.entity.MarketCustomerEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;

import com.house365.beans.entity.MarketingActivityEntity;

import java.util.List;

/**
 * 营销活动数据访问接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-05
 * @see
 * @since 1.0
 */
public interface IMarketingActivityDao<T extends MarketingActivityEntity> extends Dao<T>{
    Integer queryProtectCount(String phone);

    Integer queryCustomerCountByActive(Integer activeId);

    Integer queryAllPullCount(QueryParams<?> queryParams);

    void setDisable(Integer id);

    void addCallBackCount(Integer id);

    void addWaitVisitCount(Integer id);

    void addBughtCount(Integer id);

    void addOverTimeCount(Integer id);

}
