/**
 * Description: HouseInfo数据访问接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-18 下午 15:44:53
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.interfaces;

import com.house365.beans.entity.HouseInfoEntity;
import com.house365.dao.system.interfaces.Dao;
import com.house365.ws.beans.response.HouseInfoListResponse;

import java.util.List;

/**
 * HouseInfo数据访问接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-18
 * @see
 * @since 1.0
 */
public interface IHouseInfoDao<T extends HouseInfoEntity> extends Dao<T> {
    List<HouseInfoEntity> getHouseByHouseId(Integer integer);

    List<HouseInfoEntity> getHouseInfoListByActiveId(Integer activeId);

}
