/**
 * Description: UserSourceStatisticsWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-10-25 上午 09:36:01
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-10-25   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.DeptSourceStatisticsListRequest;
import com.house365.ws.beans.request.UserSourceStatisticsListRequest;
import com.house365.ws.beans.request.UserSourceStatisticsRequest;
import com.house365.ws.beans.response.SourceStatisticsListResponse;
import com.house365.ws.beans.response.UserSourceStatisticsListResponse;
import com.house365.ws.beans.response.UserSourceStatisticsResponse;


/**
 * UserSourceStatisticsWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-10-25
 * @see
 * @since 1.0
 */
public interface IUserSourceStatistics extends IService {

    /**
     * UserSourceStatistics列表查询
     *
     * @param request
     *            UserSourceStatistics列表查询请求
     * @return UserSourceStatistics列表查询响应
     */
    UserSourceStatisticsListResponse getUserSourceStatisticsList(
        UserSourceStatisticsListRequest request
    );

    /**
     * 保存UserSourceStatistics
     *
     * @param request
     *            UserSourceStatistics请求
     * @return 保存UserSourceStatistics响应
     */
    UserSourceStatisticsResponse addUserSourceStatistics(UserSourceStatisticsRequest request);

    /**
     * 删除UserSourceStatistics通过唯一标识
     *
     * @param id
     *            唯一标识
     * @return 删除UserSourceStatistics响应
     */
    UserSourceStatisticsResponse deleteUserSourceStatisticsById(Integer id);

    /**
     * 修改UserSourceStatistics
     *
     * @param request
     *            修改UserSourceStatistics请求
     * @return 修改UserSourceStatistics响应
     */
    UserSourceStatisticsResponse updateUserSourceStatistics(
        UserSourceStatisticsRequest request
    );

    /**
     * 通过ID获取UserSourceStatistics
     *
     * @param id
     *            唯一标识
     * @return 通过ID获取UserSourceStatistics响应
     */
    UserSourceStatisticsResponse getUserSourceStatisticsById(Integer id);

    SourceStatisticsListResponse customerTrans(
        UserSourceStatisticsListRequest request, String dateViewType
    );

    SourceStatisticsListResponse statisticCustomer(
        UserSourceStatisticsListRequest request, String dateViewType
    );
}
