/**
 * Description: 账户WS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-14 下午 17:27:22
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.beans.entity.*;
import com.house365.beans.system.Page;
import com.house365.rest.context.IService;
import com.house365.ws.beans.request.*;
import com.house365.ws.beans.response.*;
import com.house365.ws.beans.util.HResult;
import org.apache.shiro.authc.AuthenticationToken;

import java.util.List;
import java.util.Map;


/**
 * 账户WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
public interface IUser extends IService {

    /**
     * 账户列表查询
     *
     * @param
     * @return 账户列表查询响应
     */
    void addLabel(LabelEntity entity);

    void saveCustomersLabels(List<LabelEntity> paramList);

    List<LabelEntity> getCustomerLabelById(LabelEntity labelentity);

    List<LabelEntity> getCustomerLabelIds(LabelEntity labelentity);

    List<LabelEntity> getColorLabel(Map<String, Object> labelMap);

    List<LabelEntity> getAllLabelsByOwn(Map<String, Object> labelMap);

    List<LabelEntity> getColorLabel4MyCustomer(Map<String, Object> labelMap);

    List<LabelEntity> queryCustomerLabel(Integer userId, Integer customerId);

    List<LabelEntity> queryUserLabel(Integer userId);

    List<LabelEntity> queryUserCustomerLabel(Integer userId, Integer customerId);

    void updateLabel(LabelEntity entity);

    void updateUserCustomerLabel(LabelEntity entity);

    void delLabel(LabelEntity entity);

    void delCustomerLabel(LabelEntity entity);

    UserListResponse getUserList(UserListRequest request);

    LabelResponse getLabelList(LabelRequest request);

    List<LabelEntity> getLabelColor(Map<String, Object> labelMap);

    VersionListResponse getAppVersionList(VersionListRequest request);

    AuthorizationResponse getAuthorizationList(AuthorizationRequest listRequest);

    void saveUnbindLog(UserEntity entity);

    void authorizationById(RequestLoginEntity entity);

    void updateRequestById(RequestLoginEntity requestloginentity);

    /**
     * 保存账户
     *
     * @param request 账户请求
     * @return 保存账户响应
     */
    UserResponse addUser(UserRequest request);

    void addRequestLoginInfo(RequestLoginEntity requestlogin);

    List<RequestLoginEntity> getRequestLoginInfo(RequestLoginEntity requestloginentity);

    RequestLoginEntity getRequestLoginInfoById(Integer id);

    /**
     * 删除账户通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除账户响应
     */
    UserResponse deleteUserById(Integer id,int userId);

    /**
     * 修改账户
     *
     * @param request 修改账户请求
     * @return 修改账户响应
     */
    UserResponse updateUser(UserRequest request);

    UserResponse updateUserAndSyncToWechat(UserRequest request);

    void syncToWechat(UserRequest request);

    void updateIM(UserEntity ue);

    /**
     * 通过ID获取账户
     *
     * @param id 唯一标识
     * @return 通过ID获取账户响应
     */
    UserResponse getUserById(Integer id);

    UserEntity getRemotePath(Integer resourceId);

    List<DutyStaffEntity> getOndutyById(Integer uid);

    List<UserEntity> getManagerByPid(Integer uid, String managername);

    UserEntity getLimitLoginById(String name);

    Map<String, Object> validate(AuthenticationToken token);

    List<DepartmentEntity> getChildDepartList(Integer deptId);

    UserListResponse getUserListByDept(DepartmentEntity dept, Map<String, Object> userParaMap, Page page);

    //获取自己和所有下属id
    List<Integer> getUserIdOnPath(Integer parentId);

    Map<String, Object> getSummary(String managerId);

    String unbindHotlinePhone(UserEntity userEntity);

    /**
     * 通过userId判断是否为主管
     *
     * @param userId
     * @return
     */
    Boolean isDirector(Integer userId);

    UserEntity getById(int id);

    List<UserEntity> queryByConditions(Map<String, Object> map);

    void saveWxUser(WxUserEntity entity);

    List<WxUserEntity> queryByCondition(Map<String, Object> map);

    HResult saveRelation(UserWxRelation userWxRelation);

    List<UserWxRelation> queryList(Map<String, Object> map);

    List<MessageLogEntity> queryMsglogList(Map<String, Object> map);

    List<UserEntity> queryManagers(Map<String, Object> map);

    List<UserEntity> queryRuleManagers(Map<String, Object> map);

    void syncUserList();

    MapListResponse list(Map<String, Object> map);

    UserWxRelation getRelationById(int id);

    void update(UserWxRelation userWxRelation);

}
