/**
 * Description: DictionaryWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-08-30 下午 13:46:00
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-08-30   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.beans.entity.DictionaryEntity;
import com.house365.rest.context.IService;
import com.house365.ws.beans.request.DictionaryListRequest;
import com.house365.ws.beans.request.DictionaryRequest;
import com.house365.ws.beans.response.DictionaryListResponse;
import com.house365.ws.beans.response.DictionaryResponse;

import java.util.List;
import java.util.Map;


/**
 * DictionaryWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-08-30
 * @see
 * @since 1.0
 */
public interface IDictionary extends IService {

    /**
     * Dictionary列表查询
     *
     * @param request
     *            Dictionary列表查询请求
     * @return Dictionary列表查询响应
     */
    DictionaryListResponse getDictionaryList(DictionaryListRequest request);

    /**
     * 保存Dictionary
     *
     * @param request
     *            Dictionary请求
     * @return 保存Dictionary响应
     */
    DictionaryResponse addDictionary(DictionaryRequest request);

    /**
     * 删除Dictionary通过唯一标识
     *
     * @param id
     *            唯一标识
     * @return 删除Dictionary响应
     */
    DictionaryResponse deleteDictionaryById(Integer id);

    /**
     * 修改Dictionary
     *
     * @param request
     *            修改Dictionary请求
     * @return 修改Dictionary响应
     */
    DictionaryResponse updateDictionary(DictionaryRequest request);

    /**
     * 通过ID获取Dictionary
     *
     * @param id
     *            唯一标识
     * @return 通过ID获取Dictionary响应
     */
    DictionaryResponse getDictionaryById(Integer id);

    List<DictionaryEntity> getListByKey(String key);

    DictionaryEntity getByKey(String key);

    List<DictionaryEntity> getNoApproximateConfig(Map<String, Object> map);
}
