/**
 * Description: 部门WS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-14 下午 17:27:15
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.beans.entity.DepartmentEntity;
import com.house365.rest.context.IService;
import com.house365.ws.beans.request.DepartmentListRequest;
import com.house365.ws.beans.request.DepartmentRequest;
import com.house365.ws.beans.response.DepartmentListResponse;
import com.house365.ws.beans.response.DepartmentResponse;

import java.util.List;
import java.util.Map;


/**
 * 部门WS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
public interface IDepartment extends IService,IBaseTreeableService<DepartmentEntity>{

    /**
     * 部门列表查询
     * 
     * @param request
     *            部门列表查询请求
     * @return 部门列表查询响应
     */
    DepartmentListResponse getDepartmentList(DepartmentListRequest request);

    /**
     * 保存部门
     * 
     * @param request
     *            部门请求
     * @return 保存部门响应
     */
    DepartmentResponse addDepartment(DepartmentRequest request);

    /**
     * 删除部门通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除部门响应
     */
    DepartmentResponse deleteDepartmentById(Integer id);

    /**
     * 修改部门
     * 
     * @param request
     *            修改部门请求
     * @return 修改部门响应
     */
    DepartmentResponse updateDepartment(DepartmentRequest request);

    /**
     * 通过ID获取部门
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取部门响应
     */
    DepartmentResponse getDepartmentById(Integer id);

    /**
     * 部门列表查询
     *
     * @param request
     *            部门列表查询请求
     * @return 部门列表查询响应
     */
    DepartmentListResponse getDepartments(DepartmentListRequest request);

    DepartmentEntity queryById(int id);

    List<DepartmentEntity> queryByCondition(Map<String,Object> map);
}
