<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>权限组授权</title>
    <link href="${ctx}/resources/treeTable/themes/vsStyle/treeTable.min.css" rel="stylesheet" type="text/css"/>
    <script src="${ctx}/resources/treeTable/jquery.treeTable.min.js" type="text/javascript"></script>
</head>
<body>
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li>
                <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                <a href="${ctx}/role/${roleId}">权限组</a>
            </li>
            <li class="active">
                <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                <span class="inline">授权</span>
            </li>
        </ul>
    </div>
    <div class="span11">
        <div class="buttons pull-right">
            <a href="#" class="btn blue pull-right" title="确定授权" onclick="authorizeById('')">确定授权</a>
        </div>
        <input type="hidden" name="roleId" id="roleId" value="${roleId}">
    </div>
</div>

<div class="page-container">
    <table id="treeTable" class="table table-advance table-hover">
        <tr>
            <td colspan="3">PC端菜单权限</td>
        </tr>
        <tr>

            <!-- <th width="100">id</th> -->
            <th width="40%">编码</th>
            <th width="40%">名称</th>
            <th width="20%"><input id="memberCheckAll" type="checkbox" onclick="checkAll(this)" hidden="hidden"/>是否授权
            </th>
        </tr>
        <c:forEach items="${permissions}" var="permission">
            <tr id="${permission.id}" pId="${permission.parentId}">
                <td nowrap="nowrap">
                    <c:if test="${null ne permission.code && '' ne permission.code}">
                        <c:out value="${permission.code}"/>
                    </c:if>
                    <c:if test="${null eq permission.code || '' eq permission.code}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${permission.hierarchy eq 1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</c:if>
                    <c:if test="${null ne permission.name && '' ne permission.name}">
                        <c:out value="${permission.name}"/>
                    </c:if>
                    <c:if test="${null eq permission.name || '' eq permission.name}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <input type="checkbox" name="memberCheck" value="${permission.id}" onclick="checkMember(this)"
                           <c:if test="${permission.authorized}">checked="checked"</c:if>
                           <c:if test="${permission.hierarchy eq 0}">hidden="hidden"</c:if>/>
                </td>
            </tr>
        </c:forEach>
    </table>

    <table id="treeTable1" class="table table-advance table-hover">
        <tr>
            <td colspan="3">移动端菜单权限</td>
        </tr>
        <tr>

            <!-- <th width="100">id</th> -->
            <th width="40%">编码</th>
            <th width="40%">名称</th>
            <th width="20%"><input id="memberCheckAll" type="checkbox" onclick="checkAll(this)" hidden="hidden"/>是否授权
            </th>
        </tr>
        <c:forEach items="${wepermissions}" var="permission">
            <tr id="${permission.id}" pId="${permission.parentId}">
                <td nowrap="nowrap">
                    <c:if test="${null ne permission.code && '' ne permission.code}">
                        <c:out value="${permission.code}"/>
                    </c:if>
                    <c:if test="${null eq permission.code || '' eq permission.code}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${permission.hierarchy eq 1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</c:if>
                    <c:if test="${null ne permission.name && '' ne permission.name}">
                        <c:out value="${permission.name}"/>
                    </c:if>
                    <c:if test="${null eq permission.name || '' eq permission.name}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <input type="checkbox" name="memberCheck" value="${permission.id}" onclick="checkMember(this)"
                           <c:if test="${permission.authorized}">checked="checked"</c:if>
                           <c:if test="${permission.hierarchy eq 0}">hidden="hidden"</c:if>/>
                </td>
            </tr>
        </c:forEach>

    </table>

    <table id="funcTable" class="table table-advance table-hover">
        <tr>
            <td colspan="3">功能菜单权限</td>
        </tr>
        <tr>

            <!-- <th width="100">id</th> -->
            <th width="40%">编码</th>
            <th width="40%">名称</th>
            <th width="20%"><input id="memberCheckAll" type="checkbox" onclick="checkAll(this)" hidden="hidden"/>是否授权
            </th>
        </tr>
        <c:forEach items="${funcList}" var="permission">
            <tr id="${permission.id}" pId="${permission.parentId}">
                <td nowrap="nowrap">
                    <c:if test="${null ne permission.code && '' ne permission.code}">
                        <c:out value="${permission.code}"/>
                    </c:if>
                    <c:if test="${null eq permission.code || '' eq permission.code}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${permission.hierarchy eq 1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</c:if>
                    <c:if test="${null ne permission.name && '' ne permission.name}">
                        <c:out value="${permission.name}"/>
                    </c:if>
                    <c:if test="${null eq permission.name || '' eq permission.name}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <input type="checkbox" name="memberCheck" value="${permission.id}" onclick="checkMember(this)"
                           <c:if test="${permission.authorized}">checked="checked"</c:if>
                           <c:if test="${permission.hierarchy eq 0}">hidden="hidden"</c:if>/>
                </td>
            </tr>
        </c:forEach>

    </table>

</div>
<script type="text/javascript">

    $(document).ready(function () {
        $("#treeTable").treeTable({expandLevel: 3}).show();
        $("#treeTable1").treeTable({expandLevel: 3}).show();
        $("#funcTable").treeTable({expandLevel: 3}).show();
    });

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    var authorizeById = function (selectedId) {
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        if (selectedId == "") {
            for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            selectedId = -1;
        }
        House365Util.createModal("权限组授权", "确定授权？", function () {
            $.ajax({
                url: '${ctx}/rolepermission/authorize/' + $("#roleId").val() + "/" + selectedId,
                type: "GET",
                success: function () {
                    window.location = "${ctx}/role/" + $("#roleId").val();
                }
            });
        });

    };

</script>
</body>
</html>
