<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>置业报告日志</title>
</head>
<body>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>报告管理
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>操作历史
            </li>
        </ul>
    </div>
</div>

<div class="page-container">
    <div class="row${fluid}">
        <form id="filterForm" name="filterForm" class="form-inline filterForm"
              action="${ctx}/reportlog/list" method="get">
        </form>

        <table class="table table-bordered table-advance table-hover">
            <tr class="info">
                <td width="100" style="text-align:center">序号</td>
                <td width="100" style="text-align:center">操作</td>
                <td width="100" style="text-align:center">操作人</td>
                <td width="100" style="text-align:center">操作时间</td>
            </tr>
            <c:if test="${not empty dataList}">
                <c:forEach items="${dataList}" var="item" varStatus="i">
                    <tr>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${i.index+1}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.action}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.createName}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                            <c:if test="${null ne item.createTime && '' ne item.createTime}">
                                <f:formatDate value='${item.createTime}'
                                              pattern='yyyy-MM-dd HH:mm:ss'/>
                            </c:if>
                        </td>
                    </tr>
                </c:forEach>
            </c:if>
            <c:if test="${ empty dataList}">
                <tr>
                    <td colspan="15" style="text-align: center">暂未找到与条件相关的数据，请重新搜索</td>
                </tr>
            </c:if>
        </table>
    </div>

</div>
<script type="text/javascript">

</script>
</body>
</html>