<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>置业报告列表</title>
</head>
<body>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>概览
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>置业报告
            </li>
        </ul>
    </div>
</div>

<div class="page-container">
    <div class="row${fluid}">
        <form id="filterForm" name="filterForm" class="form-inline filterForm"
              action="${ctx}/propertyreport/list" method="get">

            <div style="margin-top:10px;">
                用户手机号：<input type="text" id="search_phone" style="border: 1px solid #d5d5d5;" name="search_phone"
                            value="${param['search_phone']}"
                            class="m-wrap small" placeholder="用户手机号">&nbsp;&nbsp;&nbsp;&nbsp;
                是否发送：
                <select style="width: 6rem" name="search_isSend" id="search_isSend">
                    <option value="0"
                            <c:if test="${'0' eq param['search_isSend']}">selected="selected"</c:if>>
                        全部
                    </option>
                    <option value="1"
                            <c:if test="${'1' eq param['search_isSend']}">selected="selected"</c:if>>
                        已发送
                    </option>
                    <option value="2"
                            <c:if test="${'2' eq param['search_isSend']}">selected="selected"</c:if>>
                        未发送
                    </option>
                </select>
                <a class="btn" onclick="btnSubmit();">搜索</a>
            </div>
        </form>

        <table class="table table-bordered table-advance table-hover">
            <tr class="info">
                <td width="100" style="text-align:center">序号</td>
                <td width="100" style="text-align:center">用户手机号</td>
                <td width="100" style="text-align:center">价格（万）</td>
                <td width="100" style="text-align:center">面积(㎡)</td>
                <td width="100" style="text-align:center">区属</td>
                <td width="100" style="text-align:center">报告生成时间</td>
                <td width="100" style="text-align:center">状态</td>
                <td width="100" style="text-align:center">最后修改时间</td>
                <td width="100" style="text-align:center">上一次短信发送时间</td>
                <td width="100" style="text-align:center">报告链接</td>
                <td width="100" style="text-align:center">操作</td>
            </tr>
            <c:if test="${not empty dataList}">
                <c:forEach items="${dataList}" var="item" varStatus="i">
                    <tr>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${i.index+1}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.phone}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.totalPriceMin}-${item.totalPriceMax}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.areaMin}-${item.areaMax}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.district}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                            <c:if test="${null ne item.createTime && '' ne item.createTime}">
                                <f:formatDate value='${item.createTime}'
                                              pattern='yyyy-MM-dd HH:mm:ss'/>
                            </c:if>
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                            <c:if test="${1 eq item.sendStatus }">
                                已发送
                            </c:if>
                            <c:if test="${0 eq item.sendStatus }">
                                未发送
                            </c:if>
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                            <c:if test="${null ne item.updateTime && '' ne item.updateTime}">
                                <f:formatDate value='${item.updateTime}'
                                              pattern='yyyy-MM-dd HH:mm:ss'/>
                            </c:if>
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">

                            <c:if test="${null ne item.sendTime && '' ne item.sendTime}">
                                <f:formatDate value='${item.sendTime}'
                                              pattern='yyyy-MM-dd HH:mm:ss'/>
                            </c:if>
                            <c:if test="${null eq item.sendTime || '' eq item.sendTime}">
                                -
                            </c:if>
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.reportUrl}
                        </td>

                        <td nowrap="nowrap" style="text-align:center;">
                            <button onclick="toEditReport(${item.customerId})">修改</button>
                            <button onclick="sendMessage(${item.id})">发送短信</button>
                            <button onclick="getLog(${item.id})">历史操作</button>
                        </td>
                    </tr>
                </c:forEach>
            </c:if>
            <c:if test="${ empty dataList}">
                <tr>
                    <td colspan="15" style="text-align: center">暂未找到与条件相关的数据，请重新搜索</td>
                </tr>
            </c:if>

        </table>
        <div class="row${fluid}">
            <house365:pagination page="${page}"/>
        </div>
    </div>

</div>


<link rel="stylesheet" href="${static_common }/script/bootstrap/css/bootstrap-multiselect.css" type="text/css">
<script type="text/javascript" src="${static_common }/script/bootstrap/js/bootstrap-multiselect.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>

<script type="text/javascript">

    function btnSubmit() {
        $('#filterForm').submit();
    }

    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    });

    function getLog(id) {
        window.open("/house365-hgs-web/reportlog/list/" + id, "_blank");
    }

    function toEditReport(id) {
        var url = "${ctx}/propertyreport/queryReport/" + id;
        $.ajax({
            url: url,
            type: 'post',
            contentType: 'application/json',
            data: '',
            dataType: 'json',
            cache: false,
            success: function (result) {
                if (result.status == 0) {
                    window.open("/house365-hgs-web/propertyreport/toEdit/" + id, "_blank");
                }else if(result.status == 101){
                    alert("请先新增置业报告");
                }  else{
                    alert(result.errorMessage);
                }
            }
        });
    }

    function sendMessage(id) {
        $.ajax({
            url: '${ctx}/propertyreport/sendMessage/' + id,
            type: 'POST',
            contentType: 'application/json',
            data: '',
            dataType: 'json',
            cache: false,
            success: function (result) {
                if (result.status == 0) {
                    alert("发送成功！");
                    window.location.reload();
                } else {
                    addHouseArray = [];
                    alert(result.errorMessage);
                }
            }
        });
    }

</script>
</body>
</html>
