<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<style>
    tr.header {
        cursor: pointer;
    }

    .header .sign:after {
        content: "展开↓";
        display: inline-block;
    }

    .header.expand .sign:after {
        content: "收起↑";
    }
</style>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                <%--<a href="/house365-hgs-web/customer/myCustomer">我的客户</a>--%>
                <a href="/house365-hgs-web/customermanagement/myCustomerNew?type=&search_EQ_orderByTime=5">外部客户</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                客户信息
            </li>
            <li class="active">
                <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                <span class="inline">新增</span>
            </li>
        </ul>
    </div>
</div>
<!-- 面包屑 end -->
<house365:flushMessage/>
<div class="row${fluid}">
    <div class="span10 offset1">
        <div class="form-horizontal house365Page">
            <div class="house365Border">
                <!-- 片段头 begin -->
                <input type="hidden" name="entity.customerType" value="1"/>
                <div class="sectionTitle" style="height:30px;">
                    基本信息
                </div>
                <div class="row-fluid">
                    <div class="span5 control-group">
                        <label class="control-label">客户姓名:<span style="color:red;">*</span></label>
                        <div class="controls">
                            <input type="text" id="name"
                                   name="name" class="required"/>
                            <span style="color:red;"><form:errors path="customerVo.entity.name"/></span>
                        </div>
                    </div>
                    <div class="span5 control-group">
                        <label class="control-label">手机号码:<span style="color:red;">*</span></label>
                        <div class="controls">
                                <span class="inline">
                                <input type="text" id="phone" class="required"
                                       name="phone" maxlength="11"
                                       onblur="checkCustomerPhone()"/>
                                </span>
                            <span style="color: red" id="phoneError"></span>
                        </div>
                    </div>
                </div>
                <div class="row-fluid">
                    <div class="span5 control-group">
                        <label class="control-label">性别:</label>
                        <div class="controls">
                            <input type="radio" name="sex" value="2" checked>未知
                            <input type="radio" name="sex" value="1">男
                            <input type="radio" name="sex" value="0">女
                        </div>
                    </div>
                    <div class="span5 control-group">
                        <label class="control-label">其他号码1:</label>
                        <div class="controls">
                            <input type="text" id="bakPhone"
                                   name="bakPhone" maxlength="11"/>
                            <span style="color: red"><form:errors path="customerVo.entity.bakPhone"/></span>
                        </div>
                    </div>
                </div>
                <div class="row-fluid">
                    <div class="span5 control-group">
                        <label class="control-label">跟踪状态:</label>
                        <div class="controls">
                            <select name="entity.traceStatus" id="traceStatus">
                                <option value="1">
                                    有效
                                </option>
                                <option value="2">
                                    已购
                                </option>
                                <option value="3">
                                    我购
                                </option>
                                <option value="4">
                                    暂缓
                                </option>
                            </select>
                        </div>
                    </div>
                    <div class="span5 control-group">
                        <label class="control-label">活动来源：<span style="color: red">*</span></label>
                        <div class="controls">
                            <select name="entity.actSourceId" id="actSource">
                                <c:forEach items="${sources}" var="source">
                                    <option value="${source.id}">${source.sourceName}</option>
                                </c:forEach>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row-fluid">
                    <div class="span5 control-group">
                        <label class="control-label">购房意向：<span style="color: red">*</span></label>
                        <div class="controls">
                            <select name="entity.buyIntention" id="buyIntention">
                                <option value="">请选择</option>
                                <option value="1">A</option>
                                <option value="2">B</option>
                                <option value="3">C</option>
                                <option value="4">D</option>
                                <option value="5">E</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row-fluid">
                    <div class="span9 control-group">
                        <label class="control-label">回访记录:<span style="color: red">*</span></label>
                        <div class="controls">
                                        <textarea class="span9" id="remark" name="remark" rows="6"
                                                  maxlength="600"
                                                  placeholder="回访记录"></textarea>
                            <span style="color: red"><form:errors path="customerVo.entity.remark"/></span>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <div class="portlet-header" style="margin-top: 20px;">
            <div class="operation-btn">
                <input class="btn blue" type="button" onclick="commitForm()" value="保存"/>
                <a href="${ctx}/externalCustomer/list" class="btn gray">返回</a>
            </div>
        </div>
    </div>
</div>

<script>
    $(function () {
        $('.header').click(function () {
            $(this).toggleClass('expand').nextUntil('tr.header').slideToggle(100);
        });

        $('.header').click();
    });

    function commitForm() {
        var phone = $("#phone").val();
        var bakPhone = $("#bakPhone").val();
        var name = $("#name").val();
        var actSource = $("#actSource").val();
        var buyIntention = $("#buyIntention").val();
        var traceStatus = $("#traceStatus").val();
        var remark = $("#remark").val().replace(/(^\s*)|\s*$/g, '');
        var sex = $("input[name='sex']:checked").val();

        if (name == 'null' || !name || name == "") {
            House365Util.createModal("提示", "请填写姓名", function () {
                $("#name").focus();
            });
            return false;
        }
        if (actSource == 'null' || !actSource || actSource == "") {
            House365Util.createModal("提示", "请选择活动来源", function () {
                $("#actSource").focus();
            });
            return false;
        }

        if (buyIntention == 'null' || !buyIntention || buyIntention == "") {
            alert("请填写购房意向");
            return false;
        }

        if (remark == 'null' || !remark || remark == "") {
            alert("请填写回访记录");
            return false;
        }

        var city = "";
        $("#currentDept").find("option:selected").each(function () {
            city = $(this).val();
        });

        if ("1" == city) {
            House365Util.createModal("提示", "请切换到城市再添加客户信息", function () {
            });
            return false;
        }

        if (phone == "") {
            House365Util.createModal("提示", "请填写电话号码", function () {
                $("#phone").focus();
            });
            return false;
        }
        if (phone != "" && !checkMobile(phone)) {
            House365Util.createModal("提示", "电话号码格式不正确", function () {
                $("#phone").focus();
            });
            return false;
        }
        if (bakPhone != "" && !checkMobile(bakPhone)) {
            House365Util.createModal("提示", "其他号码格式不正确", function () {
                $("#bakPhone").focus();
            });
            return false;
        }

        var data = {
            phone: phone,
            name: name,
            sex: parseInt(sex),
            bakPhone: bakPhone,
            traceStatus: parseInt(traceStatus),
            actSourceId: parseInt(actSource),
            buyIntention: buyIntention,
            remark: remark
        };

        data = JSON.stringify(data);
        console.log(data);
        $.ajax({
            url: '${ctx}/externalCustomer/save',
            type: 'POST',
            contentType: 'application/json',
            data: data,
            dataType: 'json',
            cache: false,
            success: function (result) {
                if (result.status == 0) {
                    var url = "/house365-hgs-web/externalCustomer/list";
                    window.location.href = url;
                } else {
                    alert(result.errorMessage);
                }
            }
        });
    }

    function checkMobile(val) {
        var pattern = /(^(([0\+]\d{2,3}-)?(0\d{2,3})-)(\d{7,8})(-(\d{3,}))?$)|(^0{0,1}1[3|4|5|6|7|8|9][0-9]{9}$)/;
        if (pattern.test(val)) {
            return true;
        } else {
            return false;
        }
    }

    function checkCustomerPhone() {
        var phone = $("#phone").val();
        if (!checkMobile(phone)) {
            $("#phoneError").text("手机号有误，请重填！");
            return false;
        }
        $.ajax({
            url: "${ctx}/externalCustomer/checkPhone",
            data: {
                customerPhone: phone
            },
            type: "get",
            success: function (data) {
                if (data.status != 0) {
                    $("#phoneError").text(data.errorMessage);
                } else {
                    $("#phoneError").text("");
                }
            }
        });
    }
</script>

</body>

</html>
