<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>带看评价列表</title>
    <style>
        .tdText {
            word-wrap: break-word;
            word-break: break-all;
            white-space: pre-line;
        }
    </style>
</head>
<body>
<%-- <div class="row${fluid}">
    <div class="span6">
        <h2 class="page-title">EvaluateUserCustomerLog列表</h2>
    </div>
    <div class="span6 header_buttons">
        <a href="${ctx}/evaluateusercustomerlog?action=create" class="btn blue pull-right"><i class="icon-plus"></i></a>
    </div>
</div> --%>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <!-- <li><a href="/house365-hmc-web/">首页</a> <span class="divider"></span></li> -->
            <li class="active"><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>带看评价列表
            </li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/evaluateusercustomerlog" method="get">
                <input type="text" name="search_LIKE_userName" value="${param['search_LIKE_userName']}"
                       class="m-wrap small" placeholder="直销人员">
                <input type="text" name="search_LIKE_projectName" value="${param['search_LIKE_projectName']}"
                       class="m-wrap small" placeholder="楼盘项目">
                <input type="text" name="search_GTE_evaluateTimeStart" id="search_GTE_evaluateTimeStart"
                       value="${param['search_GTE_evaluateTimeStart']}"
                       class="m-wrap small span2" placeholder="评价时间-开始">至
                <input type="text" name="search_LTE_evaluateTimeEnd" id="search_LTE_evaluateTimeEnd"
                       value="${param['search_LTE_evaluateTimeEnd']}"
                       class="m-wrap small span2" placeholder="评价时间-截止">
                <select style="width: 6rem" name="search_EQ_checkStatus" id="search_EQ_checkStatus">
                    <option value="">审核状态</option>
                    <option value="0"
                            <c:if test="${'0' eq param['search_EQ_checkStatus']}">selected="selected"</c:if>>
                        待审核
                    </option>
                    <option value="1"
                            <c:if test="${'1' eq param['search_EQ_checkStatus']}">selected="selected"</c:if>>
                        通过
                    </option>
                </select>
                <div class="buttons pull-right" style="margin:3px 30px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
            </form>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="100">序号</th>
            <th width="100">评价内容</th>
            <th width="100">分值</th>
            <th width="100">评价人称呼</th>
            <th width="100">直销人员姓名</th>
            <th width="100">所属项目</th>
            <th width="100">带看时间</th>
            <th width="100">评价时间</th>
            <th width="150">操作</th>
        </tr>
        </thead>
        <c:forEach items="${evaluateUserCustomerLogs}" var="evaluateUserCustomerLog">
            <tr>
                <td nowrap="nowrap">
                        ${evaluateUserCustomerLog.id}
                </td>
                <td nowrap="nowrap" class="tdText">
                    <c:if test="${null ne evaluateUserCustomerLog.content && '' ne evaluateUserCustomerLog.content}">
                        <c:out value="${evaluateUserCustomerLog.content}"/>&nbsp;<c:out value="${evaluateUserCustomerLog.contentTags}"/>
                    </c:if>
                    <c:if test="${null eq evaluateUserCustomerLog.content || '' eq evaluateUserCustomerLog.content}">
                        &nbsp;<c:out value="${evaluateUserCustomerLog.contentTags}"/>
                    </c:if></td>
                <td nowrap="nowrap">
                    <c:if test="${null ne evaluateUserCustomerLog.score && '' ne evaluateUserCustomerLog.score}">
                        <c:out value="${evaluateUserCustomerLog.score}"/>
                    </c:if>
                    <c:if test="${null eq evaluateUserCustomerLog.score || '' eq evaluateUserCustomerLog.score}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne evaluateUserCustomerLog.customerName && '' ne evaluateUserCustomerLog.customerName}">
                        <c:out value="${evaluateUserCustomerLog.customerName}"/>
                    </c:if>
                    <c:if test="${null eq evaluateUserCustomerLog.customerName || '' eq evaluateUserCustomerLog.customerName}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne evaluateUserCustomerLog.userName && '' ne evaluateUserCustomerLog.userName}">
                        <c:out value="${evaluateUserCustomerLog.userName}"/>
                    </c:if>
                    <c:if test="${null eq evaluateUserCustomerLog.userName || '' eq evaluateUserCustomerLog.userName}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne evaluateUserCustomerLog.projectName && '' ne evaluateUserCustomerLog.projectName}">
                        <c:out value="${evaluateUserCustomerLog.projectName}"/>
                    </c:if>
                    <c:if test="${null eq evaluateUserCustomerLog.projectName || '' eq evaluateUserCustomerLog.projectName}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne evaluateUserCustomerLog.createTime && '' ne evaluateUserCustomerLog.createTime}">
                        <f:formatDate value='${evaluateUserCustomerLog.createTime}' pattern='yyyy-MM-dd'/>
                    </c:if>
                    <c:if test="${null eq evaluateUserCustomerLog.createTime || '' eq evaluateUserCustomerLog.createTime}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne evaluateUserCustomerLog.evaluateTime && '' ne evaluateUserCustomerLog.evaluateTime}">
                        <f:formatDate value='${evaluateUserCustomerLog.evaluateTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                    </c:if>
                    <c:if test="${null eq evaluateUserCustomerLog.evaluateTime || '' eq evaluateUserCustomerLog.evaluateTime}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${evaluateUserCustomerLog.checkStatus eq 0}">
                        <button type="button" class="btn btn-default"
                                onclick="checkPass('${evaluateUserCustomerLog.id}')">
                            审核通过
                        </button>
                    </c:if>
                    <c:if test="${evaluateUserCustomerLog.checkStatus eq 1}">
                        已审核
                    </c:if>
                        <%--<c:if test="${evaluateUserCustomerLog.checkStatus eq 2}">--%>
                        <%--不通过--%>
                        <%--</c:if>--%>
                    &nbsp;&nbsp; <i
                        title="删除"
                        class="icon-minus pointer icon-large"
                        onclick="deleteById('${evaluateUserCustomerLog.id}')"> </i>
                </td>
            </tr>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>
<script type="text/javascript">
    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    })

    $(function () {
        var startTime = $("#search_GTE_evaluateTimeStart")
        var endTime = $("#search_LTE_evaluateTimeEnd");
        endTime.bind("click", function () {
            WdatePicker({doubleCalendar: true, startDate: "%y-{%M-1}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: true});
        });
        startTime.bind("click", function () {
            WdatePicker({
                doubleCalendar: true, startDate: "%y-{%M-1}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: true,
                onpicked: function () {
//                    $("#search_LTE_createTimeEnd").click();
                    WdatePicker({
                        doubleCalendar: true,
                        startDate: "%y-{%M-1}-%d",
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        el: 'search_LTE_evaluateTimeEnd'
                    })
                }
            });
        });
    });
    function checkPass(id) {
        $.ajax({
            url: '${ctx}/evaluateusercustomerlog/check',
            data: {
                id: id,
                checkStatus: 1
            },
            type: "post",
            success: function () {
                window.location.reload();
            }
        });
    }

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    var deleteById = function (selectedId) {
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        if (selectedId == "") {
            for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            House365Util.createModal("删除评价", "请至少选择一条评价!", function () {
            });
        }
        else {
            House365Util.createModal("删除评价", "确定要删除该评价？", function () {
                $.ajax({
                    url: '${ctx}/evaluateusercustomerlog/' + selectedId,
                    type: "DELETE",
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        }

    };

</script>
</body>
</html>
