<%@ page language="java" pageEncoding="UTF-8" %>
<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<html>
<head>
    <title>电话回访</title>
    <script language="javascript" type="text/javascript"
            src="${ctx}/resources/script/jquery/jquery-1.10.2.min.js"></script>
    <script src="${static_common}/jquery-ui/jquery-ui.min.js" type="text/javascript"></script>
    <!-- 日历控件脚本 -->
    <script type="text/javascript"
            src="${static_common}/script/bootstrap-datetimepicker-master/js/bootstrap-datetimepicker.js"></script>
    <script type="text/javascript"
            src="${static_common}/script/bootstrap-datetimepicker-master/js/locales/bootstrap-datetimepicker.zh-CN.js"></script>
    <style>
        .temp {
            border: 1px solid #cccccc;
            width: 450px !important;
            height: 160px !important;
            position: relative;
            top: -26px;
            left: 71px;
        }

        .bat1 {
            padding: 0 10px;
            background-color: white;
            border-radius: 5px;
            outline: 0;
            border-color: transparent;
            box-shadow: none;
            margin: 0 5px;
            display: inline-block;
            height: 30px;
            line-height: 30px;
        }

        .color_999 {
            border: 1px solid #999;
            color: #999;
        }

        .color_d9534f {
            border: 1px solid #d9534f;
            color: #d9534f;
        }

        .color_f0ad4e {
            border: 1px solid #f0ad4e;
            color: #f0ad4e;
        }

        .color_5cb85c {
            border: 1px solid #5cb85c;
            color: #5cb85c;
        }

        .color_5bc0de {
            border: 1px solid #5bc0de;
            color: #5bc0de;
        }

        .color_0275d8 {
            border: 1px solid #0275d8;
            color: #0275d8;
        }

        .color_663399 {
            border: 1px solid #663399;
            color: #663399;
        }

        .bt_last {
            background-color: #f0f0f0 !important;
            border: none !important;
            background-image: none !important;
        }

        .bt_close {
            background-color: white;
            border: 1px solid black;
            border-radius: 5px;
            padding: 5px 20px;
            margin-top: 10px;
        }
    </style>
</head>
<body>
<div id="callTable">
    <p>您填写的短号为：${sessionUser.cornet}</p>
    <p>是否拨打？</p>
    <button id="calling">是</button>
    <button id="cancel" >取消</button>
</div>
<div id="callingCompleted" style="display: none">
    回访电话拨打完成！
    <button id="completed">结束</button>
</div>
<div id="callingTable" style="display: none; width: 500px">
    <p>呼叫成功！电话正在拨通：<span id="callingTime">00 : 00</span></p>

    <div>
        <span>客户意向：</span>
        <select style="width: 6rem;margin-top: 12px" name="buyIntention" id="buyIntentionNew"
                onchange="confirmBuyIntention(this.value)">
            <option value=""
                    <c:if test="${'' eq param['search_EQ_buyIntention']}">selected="selected"</c:if>>
                请选择
            </option>
            <c:forEach items="${fns:getDictList('crm_visit_result')}" var="dict">
                <c:if test="${dict.dicValue < 5}">
                    <option value="${dict.dicValue}"
                            <c:if test="${dict.dicValue == buyIntention}">selected</c:if>>${dict.dicName}</option>
                </c:if>
            </c:forEach>
        </select>
        <span id="confirmMessage" style="color: red;"></span>
        <span style="margin-left: 200px;position: relative;right: -24%;">
            <img id="starImage1" class="collect1" src="${ctx}/resources/img/collect_no.png" alt="">
        </span>

    </div>
    <div style="position: relative;">
        <input type="hidden" id="callbackLogId"/>
        <div class='row-fluid'>
            <label class='control-label'>回访内容：</label>
            <div class="span5 control-group" style="width: 100%;position: relative;top:3px">

                <p contenteditable="true" class="temp" cols="10" rows="5"
                   style="margin: 0px 0px 10px; width: 436px; height: 70px;" id="callContent" name="callContent">
                <div style="position: absolute;bottom: 39px;width: 90%;left:80px">
                    <c:forEach items="${callbackTemplateList}" var="item">
                        <button type="button" class="btn bt_last" style="margin: 5px"
                                onclick="setCallbackContent(this)">${item.content}</button>
                    </c:forEach>
                </div>
                </p>
            </div>
        </div>
        <div style="margin-top: 10px;">
            <%--回访内容模板--%>

        </div>
        <div class="row-fluid">
            <div style="display: inline-flex;"><span>客户标签：</span>
                <div class="clearfix"
                     style="display: flex;flex-wrap: wrap;width: 370px;line-height: 35px;height: auto;">
                    <div style="margin-top: -5px;float:left;">
                        <c:forEach items='${userLabelList}' var='lid'>
                            <c:choose>
                                <c:when test="${1 eq lid.selected}">
                                    <c:if test="${1 eq lid.colorId}"><span class="bat1 color_999"
                                                                           data-index="${lid.labelId}" opsel=""
                                                                           style="background-color: rgb(153, 153, 153); color: white;">${lid.labelName}</span></c:if>
                                    <c:if test="${2 eq lid.colorId}"><span class="bat1 color_d9534f"
                                                                           data-index="${lid.labelId}" opsel=""
                                                                           style="background-color: rgb(217, 83, 79); color: white;">${lid.labelName}</span></c:if>
                                    <c:if test="${3 eq lid.colorId}"><span class="bat1 color_f0ad4e"
                                                                           data-index="${lid.labelId}" opsel=""
                                                                           style="background-color: rgb(240, 173, 78); color: white;">${lid.labelName}</span></c:if>
                                    <c:if test="${4 eq lid.colorId}"><span class="bat1 color_5cb85c"
                                                                           data-index="${lid.labelId}" opsel=""
                                                                           style="background-color: rgb(92, 184, 92); color: white;">${lid.labelName}</span></c:if>
                                    <c:if test="${5 eq lid.colorId}"><span class="bat1 color_5bc0de"
                                                                           data-index="${lid.labelId}" opsel=""
                                                                           style="background-color: rgb(91, 192, 222); color: white;">${lid.labelName}</span></c:if>
                                    <c:if test="${6 eq lid.colorId}"><span class="bat1 color_0275d8"
                                                                           data-index="${lid.labelId}" opsel=""
                                                                           style="background-color: rgb(2, 117, 216); color: white;">${lid.labelName}</span></c:if>
                                    <c:if test="${7 eq lid.colorId}"><span class="bat1 color_663399"
                                                                           data-index="${lid.labelId}" opsel=""
                                                                           style="background-color: rgb(102, 51, 153); color: white;">${lid.labelName}</span></c:if>
                                </c:when>
                                <c:otherwise>
                                    <c:if test="${1 eq lid.colorId}"><span class="bat1 color_999"
                                                                           data-index="${lid.labelId}"
                                                                           opsel="">${lid.labelName}</span></c:if>
                                    <c:if test="${2 eq lid.colorId}"><span class="bat1 color_d9534f"
                                                                           data-index="${lid.labelId}"
                                                                           opsel="">${lid.labelName}</span></c:if>
                                    <c:if test="${3 eq lid.colorId}"><span class="bat1 color_f0ad4e"
                                                                           data-index="${lid.labelId}"
                                                                           opsel="">${lid.labelName}</span></c:if>
                                    <c:if test="${4 eq lid.colorId}"><span class="bat1 color_5cb85c"
                                                                           data-index="${lid.labelId}"
                                                                           opsel="">${lid.labelName}</span></c:if>
                                    <c:if test="${5 eq lid.colorId}"><span class="bat1 color_5bc0de"
                                                                           data-index="${lid.labelId}"
                                                                           opsel="">${lid.labelName}</span></c:if>
                                    <c:if test="${6 eq lid.colorId}"><span class="bat1 color_0275d8"
                                                                           data-index="${lid.labelId}"
                                                                           opsel="">${lid.labelName}</span></c:if>
                                    <c:if test="${7 eq lid.colorId}"><span class="bat1 color_663399"
                                                                           data-index="${lid.labelId}"
                                                                           opsel="">${lid.labelName}</span></c:if>
                                </c:otherwise>
                            </c:choose>
                        </c:forEach>
                    </div>
                </div>
            </div>
        </div>

        <div style="margin-top: 10px;">
            <span>回访提醒：</span>
            <input type="text" style="width: 200px;" autocomplete="off" class="datetime-picker span2 input-large"
                   id="returnTime2"
                   date-language="zh-CN" date-format="yyyy-mm-dd hh:ii:ss"
                   placeholder="/年/月/日">
        </div>
        <div style="margin-top: 10px;">
            <span>中介同行：</span>
            <input type="radio" name="isPeer" value="0"> 否
            <input style="margin-left: 20px;" type="radio" name="isPeer" value="1"> 是
        </div>
        <button id="hangup" class="bt_close" style="margin-left: 80px">挂断</button>
        <c:if test="${abandon eq '1'}">
            <button id="abandon" class="bt_close">放弃</button>
        </c:if>
    </div>
</div>

</body>

<script type="text/javascript">
    var arr = new Array();
    var type;
    var abandon = ${abandon};
    if(abandon == 0){
        type = 1
    }else if(abandon == 1){
        type = 0
    }

    $(function () {
        method.init();
        var isPeer = "${isPeer}";
        var star = "${star}";
        $("input[name='isPeer']").removeAttr('checked');
        if (isPeer == 0) {
            $("input[name='isPeer'][value='0']").prop("checked", true);
        } else if (isPeer == 1) {
            $("input[name='isPeer'][value='1']").prop("checked", true);
        }
        if (star == 0) {
            $('#starImage1').attr("src", "${ctx}/resources/img/collect_no.png")
        } else if (star == 1) {
            $('#starImage1').attr("src", "${ctx}/resources/img/collect_yes.png")
        }
        <%--var hasOwnlabel = ${hasOwnlabel};--%>
        var markedLabelId = "${markedLabelId}";
        if (markedLabelId != undefined && markedLabelId != '') {
            arr = markedLabelId.split(",");
        }
        var ids = "";
        if (arr.length > 0) {
            for (var i = 0; i < arr.length; i++) {
                ids += arr[i] + ",";
            }
        }
        if (ids.indexOf(",") != -1) {
            ids = ids.substring(0, ids.length - 1);
        }
    });

    $(document).on('click', '.bat1', function () {
//        var bor_color = $(this).css("border-color");
        var bor_color = $(this).css("borderRightColor");
        var bg_color = $(this).css("background-color");
        var labelIds = $("#labelIds").val();


        if (bg_color === 'rgb(255, 255, 255)') {
            $(this).css("background-color", bor_color);
            $(this).css("color", "white");
            $(this).attr("opsel", 1);
            var lid = $(this).attr("data-index");
            if(arr.indexOf(lid) == -1){
                arr.push(lid);
            }
        } else {
            $(this).css("background-color", "rgb(255, 255, 255)");
            $(this).css("color", bor_color);
            $(this).attr("opsel", 0);
            var lid = $(this).attr("data-index");
            for (var i = 0; i < arr.length; i++) {
                if (arr[i] == lid) {
                    arr.splice(i, 1);
                }
            }
        }
    });

    var method = {
        timer: 1,
        memphone: "${memPhone}",
        customerId: "${customerId}",
        minute: 0,
        second: 0,
        init: function () {
            method.bindEvent();
        },
        bindEvent: function () {
            var _this = this;
            $('#calling').click(function () {
                if (!$(this).hasClass('calling')) {
                    $(this).removeClass('calling').text('拨打中...');
                    _this.calling();
                }
            });
            $('#hangup').click(function () {
                _this.hangup();

            });
            $('#abandon').click(function () {
                _this.abandon();
            });
            $('#completed').click(function () {
                $(".ui-dialog").hide();
                $(".ui-widget-overlay").hide();
                window.location.reload(true);
            });
            $('#cancel').click(function () {
                $(".ui-dialog").hide();
                $(".ui-widget-overlay").hide();
//                window.location.reload(true);
            });
        },
        calling: function () {
            $('#calling').off();
            $.ajax({
                url: "${ctx}/customermanagement/calling",
                data: {
                    memPhone: method.memphone,
                    customerId: method.customerId
                },
                type: "get",
                dataType: 'json',
                success: function (callbackLogId) {
                    $("#callTable").hide();
                    $("#callingTable").show();
                    $("#callbackLogId").val(callbackLogId);
                    method.timeInterval();
                },
                error: function () {
                    House365Util.createModal("电话回访",
                        "呼叫失败!请重新尝试或联系管理员", function () {
                        });
                }
            });
        },
        hangup: function () {
            var customerId = "${customerId}";

            var returnTime = $("#returnTime2").val();
            var buyIntention = $("#buyIntentionNew").val();
            var ids = "";
            if (arr.length > 0) {
                for (var i = 0; i < arr.length; i++) {
                    ids += arr[i] + ",";
                }
            }
            if (ids.indexOf(",") != -1) {
                ids = ids.substring(0, ids.length - 1);
            }
            var starImage = $('#starImage1').attr("src");
            var customerStar;
            if (starImage === '${ctx}/resources/img/collect_no.png') {
                customerStar = 0;
            } else {
                customerStar = 1;
            }
            if (buyIntention == null || buyIntention == '') {
                alert("请选择购房意向");
                return false;
            }
            if (returnTime != null && returnTime != '') {
                var date = new Date();
                var date1 = new Date(returnTime);
                if (date.getTime() > date1.getTime()) {
                    alert("回访提醒时间不能小于当前时间");
                    return false;
                }
            }
//            var callContent = $("#callContent").val().replace(/(^\s*)|\s*$/g, '');
            var callContent = $("#callContent").text().replace(/(^\s*)|\s*$/g, '');
            if (!callContent || callContent == "") {
                alert("回访内容不能为空");
                return;
            }

            $.ajax({
                url: "${ctx}/customermanagement/handUp",
                type: "get",
                data: {
                    memPhone: method.memphone,
                    callbackLogId: $("#callbackLogId").val(),
                    callContent: callContent,
                    labelIds: ids,
                    oldCustomerId: customerId,
                    buyIntention: buyIntention
                },
                success: function () {
                    //更新客户是否中介同行状态
                    var isPeer = $("input[name='isPeer']:checked").val();
                    $.ajax({
                        url: '${ctx}/customermanagement/updatePeerAndTime/' + type,
                        contentType: 'application/json',
                        data: JSON.stringify({
                            id: customerId,
                            isPeer: isPeer,
                            buyIntention: buyIntention,
                            starCustomer: customerStar,
                            returnRemindTime: returnTime
                        }),
                        dataType: 'json',
                        type: "POST",
                        success: function (data) {
                            if (data.status == 0) {
//                                window.clearInterval(method.timer);
                                $("#callingTable").hide();
                                $("#callingCompleted").show();

                            } else {
                                alert(data.errorMessage);
                            }
                        }
                    });
                }
            });
        },
        abandon: function () {
            var customerId = "${customerId}";
            var returnTime = $("#returnTime2").val();
            var buyIntention = $("#buyIntentionNew").val();
            var ids = "";
            if (arr.length > 0) {
                for (var i = 0; i < arr.length; i++) {
                    ids += arr[i] + ",";
                }
            }
            if (ids.indexOf(",") != -1) {
                ids = ids.substring(0, ids.length - 1);
            }
            var starImage = $('#starImage1').attr("src");
            var customerStar;
            if (starImage === '${ctx}/resources/img/collect_no.png') {
                customerStar = 0;
            } else {
                customerStar = 1;
            }
            if (returnTime != null && returnTime != '') {
                var date = new Date();
                var date1 = new Date(returnTime);
                if (date.getTime() > date1.getTime()) {
                    alert("回访提醒时间不能小于当前时间");
                    return false;
                }
            }
//            var callContent = $("#callContent").val().replace(/(^\s*)|\s*$/g, '');
            var callContent = $("#callContent").text().replace(/(^\s*)|\s*$/g, '');
            if (!callContent || callContent == "") {
                alert("回访内容不能为空");
                return;
            }

            $.ajax({
                url: "${ctx}/customermanagement/handUp",
                type: "get",
                data: {
                    memPhone: method.memphone,
                    callbackLogId: $("#callbackLogId").val(),
                    callContent: callContent,
                    buyIntention: buyIntention,
                    labelIds: ids,
                    oldCustomerId: customerId,
                    starCustomer: customerStar,
                    abandon: "1"
                },
                success: function () {
                    //更新客户是否中介同行状态
                    var isPeer = $("input[name='isPeer']:checked").val();
                    $.ajax({
                        url: '${ctx}/customermanagement/updatePeerAndTime/' + type,
                        contentType: 'application/json',
                        data: JSON.stringify({
                            id: customerId,
                            isPeer: isPeer,
                            buyIntention: buyIntention,
                            returnRemindTime: returnTime
                        }),
                        dataType: 'json',
                        type: "POST",
                        success: function (data) {
                            if (data.status == 0) {
                                window.clearInterval(method.timer);
                                $("#callingTable").hide();
                                $("#callingCompleted").show();
                            } else {
                                alert(data.errorMessage);
                            }
                        }
                    });
                }
            });

        },
        timeInterval: function () {
            method.timer = setInterval(function () {
                method.second = method.second + 1;
                if (method.second >= 60) {
                    method.second = 0;
                    method.minute = method.minute + 1;
                }
                var minute, second;
                if (method.minute < 10) {
                    minute = "0" + method.minute;
                } else {
                    minute = method.minute;
                }
                if (method.second < 10) {
                    second = "0" + method.second;
                } else {
                    second = method.second;
                }
                $("#callingTime").html(minute + " : " + second);
            }, 1000);
        }
    };

    function confirmBuyIntention(buyIntention) {
        if (buyIntention == 5) {
            $("#confirmMessage").text("您确定要将客户移入公海吗？");
        } else {
            $("#confirmMessage").text("");
        }
    }

    function setCallbackContent(template) {
        var content = $(template).text();
        var obj = document.getElementById("callContent");
        obj.innerHTML = content;
    }

    $(document).on('click', '.collect1', function () {
        var customerId = "${customerId}";
        $.ajax({
            url: '${ctx}/customermanagement/judgeStar/' + customerId,
            type: "GET",
            success: function (data) {
                if (data.status == 0) {
                    var img_src = $('#starImage1').attr("src");
                    if (img_src === '${ctx}/resources/img/collect_no.png') {
                        $('#starImage1').attr("src", "${ctx}/resources/img/collect_yes.png")
                    } else {
                        $('#starImage1').attr("src", "${ctx}/resources/img/collect_no.png")
                    }
                } else {
                    alert(data.errorMessage);
                }
            }
        });
    })
</script>
</html>
