<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<style>
    tr.header {
        cursor: pointer;
    }

    .header .sign:after {
        content: "展开↓";
        display: inline-block;
    }

    .header.expand .sign:after {
        content: "收起↑";
    }
</style>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/customer/${entity.id}?action=view"
      method="post">

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <a href="/house365-hgs-web/">首页</a>
                    <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                    <%--<a href="/house365-hgs-web/project/myProjects">我的驻场项目</a>--%>
                    <%--<span class="divider" style="color:#26a0da;font-weight:bold;"> > ／</span>--%>
                    <a href="/house365-hgs-web/customer/myRecordedCustomer?projectId=${projectId}">约看客户列表</a>
                    <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                    客户详情
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span10 offset1">
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle" style="height:30px;">
                        客户属性
                    </div>
                    <input name="entity.id" type="hidden" value="${entity.id}"/>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">客户类型:</label>
                            <div class="controls">
                                <input disabled type="radio" name="customerSourceType" value="1" <c:if
                                        test="${entity.customerSourceType eq '1'}"> checked</c:if>>常规
                                <input disabled type="radio" name="customerSourceType" value="2" <c:if
                                        test="${entity.customerSourceType eq '2'}"> checked</c:if>>抢客
                                <input disabled type="radio" name="customerSourceType" value="3" <c:if
                                        test="${entity.customerSourceType eq '3'}"> checked</c:if>>营销
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">置业顾问:</label>
                            <div class="controls">
                                ${entity.managerName}
                            </div>
                        </div>
                    </div>
                    <div class="sectionTitle" style="height:30px;">
                        基本信息
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label"><font color="red">*</font> 客户姓名:</label>
                            <div class="controls">
                                <input type="text" id="entity.name"
                                       name="entity.name"
                                       value="${entity.name}"/>
                                <font color="red"><form:errors path="customerVo.entity.name"/></font><br>
                                <a href="#" onclick="getCRM(${entity.id})">查看CRM视图</a>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">手机号码:</label>
                            <div class="controls">
                                <span class="inline">${entity.phone}&nbsp;</span>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">性别:</label>
                            <div class="controls">
                                <c:if test="${entity.sex eq '2'}">未知</c:if>
                                <c:if test="${entity.sex eq '1'}">男</c:if>
                                <c:if test="${entity.sex eq '0'}">女</c:if>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">其他号码1:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity_bakPhone1"
                                               name="entity.bakPhone1" maxlength="11"
                                               value="${entity.bakPhone1}"/>
                                        <font color="red"><form:errors path="customerVo.entity.bakPhone1"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.bakPhone1}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">其他号码2:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity_bakPhone2"
                                               name="entity.bakPhone2" maxlength="11"
                                               value="${entity.bakPhone2}"/>
                                        <font color="red"><form:errors path="customerVo.entity.bakPhone2"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.bakPhone2}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">其他号码3:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity_bakPhone3"
                                               name="entity.bakPhone3" maxlength="11"
                                               value="${entity.bakPhone3}"/>
                                        <font color="red"><form:errors path="customerVo.entity.bakPhone3"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.bakPhone3}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>
                    <div class="sectionTitle" style="height:30px;">
                        回访记录
                        <shiro:hasPermission name="FUNC:ADDCALL">
                            <button type="button" class="btn btn-default" style="float: right" onclick="addCallBack()">
                                添加回访
                            </button>
                        </shiro:hasPermission>
                    </div>
                    <div class="row-fluid">
                        <div class="span8 control-group offset1">
                            回访内容
                        </div>
                        <div class="span1 control-group">
                            添加人
                        </div>
                        <div class="span2 control-group">
                            添加日期
                        </div>
                    </div>

                    <c:forEach items="${callLogs}" var="call">
                        <div class="row-fluid">
                            <div class="span8 control-group offset1" style="overflow: auto;">
                                    ${call.content}
                            </div>
                            <div class="span1 control-group">
                                    ${call.managerName}
                            </div>
                            <div class="span2 control-group">
                                <fmt:formatDate value='${call.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                            </div>
                        </div>
                    </c:forEach>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                        </div>
                        <div class="span4 control-group">
                            <a href="${ctx}/customercallbacklog?customerId=${entity.id}" target="_blank">查看更多回访纪录</a>
                        </div>
                        <div class="span2 control-group">
                        </div>
                    </div>

                    <div class="sectionTitle" style="height:30px;">
                        客户情况与来源
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">购房意向：</label>
                            <div class="controls">
                                <span class="inline">
                                     <c:if test="${null ne entity.buyIntention && '' ne entity.buyIntention}">
                                         <c:choose>
                                             <c:when test="${customer.buyIntention eq '1'}">
                                                 <span class="inline">A</span>
                                             </c:when>
                                             <c:when test="${customer.buyIntention eq '2'}">
                                                 <span class="inline">B</span>
                                             </c:when>
                                             <c:when test="${customer.buyIntention eq '3'}">
                                                 <span class="inline">C</span>
                                             </c:when>
                                             <c:when test="${customer.buyIntention eq '4'}">
                                                 <span class="inline">D</span>
                                             </c:when>
                                             <c:when test="${customer.buyIntention eq '5'}">
                                                 <span class="inline">E(丢入公海)</span>
                                             </c:when>
                                             <c:otherwise>
                                                 <span class="inline">待定</span>
                                             </c:otherwise>
                                         </c:choose>
                                     </c:if>
                                </span>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">活动来源：</label>
                            <div class="controls">
                                <span class="inline">${fn:replace(entity.actSource," ","&nbsp;")}&nbsp;</span>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">初次来源:</label>
                            <div class="controls">
                                <span class="inline">${entity.firstSource}&nbsp;</span>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">最近来源:</label>
                            <div class="controls">
                                <span class="inline">${entity.latestSource}&nbsp;</span>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">最近回访:</label>
                            <div class="controls">
                                <span class="inline">${entity.crmLatestCall}&nbsp;</span>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">最近回访结果:</label>
                            <div class="controls">
                                <span class="inline">${entity.crmLatestCallResult}&nbsp;</span>
                            </div>
                        </div>
                    </div>
                    <div class="sectionTitle" style="height:30px;">
                        约看信息
                    </div>
                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <table style="width: 100%;">
                                <c:forEach items="${customerProjects}" var="cp">
                                    <tr class="header expand" style="line-height: 30px;background-color: #EEEEEE;">
                                        <td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
                                        <td>约看项目：${cp.projectName} <a
                                                href="${ctx}/customer/updateProjectInfo/${cp.id}"
                                                target="_blank">查看约看详情</a></td>
                                        <td>客户状态：
                                            <c:if test="${null ne cp.status and '' ne cp.status}">
                                                <c:choose>
                                                    <c:when test="${cp.status==1}">
                                                        <span class="inline">约看</span>
                                                    </c:when>
                                                    <c:when test="${cp.status==2}">
                                                        <span class="inline">到访</span>
                                                    </c:when>
                                                    <c:when test="${cp.status==3}">
                                                        <span class="inline">认筹</span>
                                                    </c:when>
                                                    <c:when test="${cp.status==4}">
                                                        <span class="inline">认购</span>
                                                    </c:when>
                                                    <c:when test="${cp.status==5}">
                                                        <span class="inline">签约</span>
                                                    </c:when>
                                                    <c:when test="${cp.status==6}">
                                                        <span class="inline">退房</span>
                                                    </c:when>
                                                </c:choose>
                                            </c:if>
                                            <font color="red">${cp.remark}</font>
                                        </td>
                                        <td><span class="sign"></span></td>
                                    </tr>
                                    <tr style="line-height: 30px;">
                                        <td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
                                        <td>到访次数：${cp.visitTime}</td>
                                        <td>案场报备：
                                            <c:if test="${null ne cp.recordedStatus}">
                                                <c:choose>
                                                    <c:when test="${cp.recordedStatus=='1'}">
                                                        <span class="inline">有效</span>
                                                    </c:when>
                                                    <c:when test="${cp.recordedStatus=='0'}">
                                                        <span class="inline">无效</span>
                                                    </c:when>
                                                </c:choose>
                                            </c:if>
                                            <c:if test="${empty cp.recordedStatus}">
                                                <span class="inline">待定</span>
                                            </c:if>
                                        </td>
                                        <td>贷款状态：
                                            <c:if test="${null ne cp.loanStatus}">
                                                <c:choose>
                                                    <c:when test="${cp.loanStatus eq '0'}">
                                                        <span class="inline">未办理</span>
                                                    </c:when>
                                                    <c:when test="${cp.loanStatus eq '1'}">
                                                        <span class="inline">申请中</span>
                                                    </c:when>
                                                    <c:when test="${cp.loanStatus eq '2'}">
                                                        <span class="inline">已下款</span>
                                                    </c:when>
                                                    <c:when test="${cp.loanStatus eq '3'}">
                                                        <span class="inline">被拒绝</span>
                                                    </c:when>
                                                    <c:when test="${cp.loanStatus eq '4'}">
                                                        <span class="inline">全款支付</span>
                                                    </c:when>
                                                </c:choose>
                                            </c:if>
                                        </td>
                                    </tr>
                                    <tr style="line-height: 30px;">
                                        <td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
                                        <td>需求面积段：${cp.requireArea}</td>
                                        <td>意向房型：${cp.requireHouseType}</td>
                                        <td>需求房号：${cp.requireHouse}</td>
                                    </tr>
                                    <tr style="line-height: 30px;">
                                        <td>&nbsp;&nbsp;&nbsp;&nbsp;</td>
                                        <td>总价预算：${cp.requirePrice}</td>
                                        <td>约看时间：
                                            <c:if test="${null ne cp.recordedTime && '' ne cp.recordedTime}">
                                                <f:formatDate value='${cp.recordedTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                                            </c:if>
                                        </td>
                                        <td></td>
                                    </tr>
                                </c:forEach>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="portlet-header">
                <div class="operation-btn">
                    <input class="btn blue" type="button" onclick="commitForm()" value="保存">
                    </input>
                </div>
            </div>
        </div>
    </div>
</form>

<script>
    $(function () {
        $('.header').click(function () {
            $(this).toggleClass('expand').nextUntil('tr.header').slideToggle(100);
        });

        $('.header').click();
    });

    function commitForm() {
        $("#input_form").submit();
    }

    function checkMobile(val) {
        var pattern = /(^(([0\+]\d{2,3}-)?(0\d{2,3})-)(\d{7,8})(-(\d{3,}))?$)|(^0{0,1}1[3|4|5|6|7|8|9][0-9]{9}$)/;
        if (pattern.test(val)) {
            return true;
        } else {
            return false;
        }
    }

    function addCallBack() {
        House365Util.createModal("添加回访", "回访内容<textarea cols='10' rows='5' style='margin: 0px 0px 10px; width: 436px; height: 70px;' id='callContent'></textarea>", function () {
            var callContent = $("#callContent").val();
            if (callContent.length > 600) {
                alert("不能超过600个字");
                return false;
            } else {
                $.ajax({
                    url: '${ctx}/customer/addCall',
                    data: {"content": callContent, "customerId": ${entity.id}},
                    type: "GET",
                    success: function (data) {
                        if (data.result == '1') {
                            window.location.reload();
                        } else {
                            alert("操作失败，" + data.msg);
                        }
                    }
                });
            }

        });
    }

    function getCRM(customerId) {
        $.ajax({
            url: '${ctx}/customer/getCRMURL',
            data: {"customerId": customerId},
            type: "GET",
            success: function (data) {
                if (data.result == '1') {
                    if (data.data.entity == "") {
                        alert("该用户暂未推送至CRM");
                        return false;
                    }
                    window.open(data.data.entity);
                } else {
                    alert("操作失败，" + data.msg);
                }
            }
        });
    }
</script>

</body>

</html>
