<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>客户信息列表</title>
</head>
<body>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li class="active"><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>客户信息列表</li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<div class="page-container">
    <form id="filterForm" class="form-inline filterForm" action="${ctx}/cloudcustomer/list/${activity.id}" method="get">
        <input type="hidden" id="actId" name="activeId" value="${activity.id}">
        <input type="hidden" id="type" name="type" value="${type}">

        <div class="row-fluid" style="color: #999999">
            <p><span style="font-size: medium">${activity.name}</span></p>
            <p>此次共查询到${customerCount}组客户数据，其中${waitCount}组数据等待派工</p>
        </div>
        <div class="row-fluid">
            <ul class="nav nav-tabs" style="margin-bottom: 0;position: relative;">
                <li <c:if test="${'' eq type || empty type}">class="active"</c:if>>
                    <a href="javascript:linkTypeUrl('')">待派（${waitCount}）</a>
                </li>
                <li <c:if test="${'assigned' eq type}">class="active"</c:if>>
                    <a href="javascript:linkTypeUrl('assigned')">已派（${sentCount}）</a>
                </li>
            </ul>
        </div>

        <div class="row-fluid" style="margin-top: 5px;">
            <div class="span10">
                客户电话：<input type="text" id="search_phone" name="search_phone"
                            value="${param['search_phone']}"
                            class="m-wrap small" placeholder="客户电话">
                报名来源：<input type="text" id="search_latestSource" name="search_latestSource"
                            value="${param['search_latestSource']}" class="m-wrap small" placeholder="报名来源">
                报名活动：<input type="text" id="search_actSource" name="search_actSource"
                            value="${param['search_actSource']}" class="m-wrap small" placeholder="报名活动">
                置业顾问：<input type="text" id="search_managerName" name="search_managerName"
                            value="${param['search_managerName']}"
                            class="m-wrap small" placeholder="置业顾问">
                报名项目：<input type="text" id="search_signupHouseName" name="search_signupHouseName"
                            value="${param['search_signupHouseName']}"
                            class="m-wrap small" placeholder="报名项目">
                <c:if test="${'assigned' eq type}">
                    客户状态：
                    <select style="width: 6rem" name="search_status" id="search_status">
                        <option value="0"
                                <c:if test="${'0' eq param['search_status']}">selected="selected"</c:if>>
                            全部
                        </option>
                        <option value="1"
                                <c:if test="${'1' eq param['search_status']}">selected="selected"</c:if>>
                            约看
                        </option>
                        <option value="2"
                                <c:if test="${'2' eq param['search_status']}">selected="selected"</c:if>>
                            到访
                        </option>
                        <option value="3"
                                <c:if test="${'3' eq param['search_status']}">selected="selected"</c:if>>
                            认筹
                        </option>
                        <option value="4"
                                <c:if test="${'4' eq param['search_status']}">selected="selected"</c:if>>
                            认购
                        </option>
                        <option value="5"
                                <c:if test="${'5' eq param['search_status']}">selected="selected"</c:if>>
                            签约
                        </option>
                        <option value="6"
                                <c:if test="${'6' eq param['search_status']}">selected="selected"</c:if>>
                            退房
                        </option>
                    </select>
                </c:if>
                <c:if test="${'assigned' eq type}">
                    回访状态：
                    <select style="width: 6rem" name="search_backStatus" id="search_backStatus">
                        <option value="0"
                                <c:if test="${'0' eq param['search_backStatus']}">selected="selected"</c:if>>
                            全部
                        </option>
                        <option value="1"
                                <c:if test="${'1' eq param['search_backStatus']}">selected="selected"</c:if>>
                            已回访
                        </option>
                        <option value="2"
                                <c:if test="${'2' eq param['search_backStatus']}">selected="selected"</c:if>>
                            未回访
                        </option>
                    </select>
                </c:if>

                <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
            </div>
            <div class="span2">
                <c:choose>
                    <c:when test="${'assigned' ne type}">
                        <c:if test="${page.records>0}">
                            <div class="bottomBtnR" onclick="assignManager()">批量派工</div>
                            <div class="bottomBtnR" onclick="allAssignManager()">派工所有</div>
                        </c:if>
                    </c:when>
                    <c:when test="${'assigned' eq type}">
                        <div class="row-fluid">
                            <div class="bottomBtnR" onclick="assignManager()">批量改派</div>
                        </div>
                    </c:when>
                </c:choose>
            </div>
        </div>

    </form>

    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="40" style="text-align:center">
                <input id="memberCheckAll" type="checkbox" onclick="checkAll(this)"/>
            </th>
            <th width="100">id</th>
            <th width="100">姓名</th>
            <th width="100">手机号</th>
            <th width="100">报名项目</th>
            <th width="100">最近报名来源</th>
            <th width="100">最近报名活动</th>
            <th width="100">报名时间</th>
            <c:if test="${'assigned' eq type}">
                <th width="100">派工时间</th>
                <th width="100">置业顾问</th>
            </c:if>
            <th width="150">操作</th>
        </tr>
        </thead>
        <c:forEach items="${dataList}" var="data">
            <tr>
                <td nowrap="nowrap" style="text-align:center">
                    <input type="checkbox" id="ck_${data.id}" name="memberCheck" value="${data.id}"
                           onclick="checkMember(this)"/>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne data.id && '' ne data.id}">
                        <c:out value="${data.id}"/>
                    </c:if>
                    <c:if test="${null eq data.id || '' eq data.id}">
                        &nbsp;-
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne data.name && '' ne data.name}">
                        <c:out value="${data.name}"/>
                    </c:if>
                    <c:if test="${null eq data.name || '' eq data.name}">
                        &nbsp;-
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne data.phone && '' ne data.phone}">
                        <c:out value="${data.phone}"/>
                    </c:if>
                    <c:if test="${null eq data.phone || '' eq data.phone}">
                        &nbsp;-
                    </c:if>
                </td>
                <td nowrap="nowrap" width="100">
                    <c:if test="${null ne data.signupHouseName && '' ne data.signupHouseName}">
                        <c:out value="${data.signupHouseName}"/>
                    </c:if>
                    <c:if test="${null eq data.signupHouseName || '' eq data.signupHouseName}">
                        &nbsp;-
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne data.latestSource && '' ne data.latestSource}">
                        <c:out value="${data.latestSource}"/>
                    </c:if>
                    <c:if test="${null eq data.latestSource || '' eq data.latestSource}">
                        &nbsp;-
                    </c:if>
                </td>
                <td nowrap="nowrap" width="300">
                    <c:if test="${null ne data.actSource && '' ne data.actSource}">
                        <c:out value="${data.actSource}"/>
                    </c:if>
                    <c:if test="${null eq data.actSource || '' eq data.actSource}">
                        &nbsp;-
                    </c:if>
                </td>

                <td nowrap="nowrap">
                    <c:if test="${null ne data.signupTime && '' ne data.signupTime}">
                        <c:out value="${data.signupTime}"/>
                    </c:if>
                    <c:if test="${null eq data.signupTime || '' eq data.signupTime}">
                        &nbsp;-
                    </c:if>
                </td>
                <c:if test="${'assigned' eq type}">
                    <td nowrap="nowrap">
                        <c:if test="${null ne data.bindTime && '' ne data.bindTime}">
                            <f:formatDate value='${data.bindTime}'
                                          pattern='yyyy-MM-dd HH:mm:ss'/>
                        </c:if>
                        <c:if test="${null eq data.bindTime || '' eq data.bindTime}">
                            &nbsp;-
                        </c:if>
                    </td>
                    <td nowrap="nowrap">
                        <c:if test="${null ne data.managerName && '' ne data.managerName}">
                            <c:out value="${data.managerName}"/>
                        </c:if>
                        <c:if test="${null eq data.managerName || '' eq data.managerName}">
                            &nbsp;-
                        </c:if>
                    </td>
                </c:if>

                <td nowrap="nowrap">
                    <c:choose>
                        <c:when test="${'assigned' eq type}">
                            <div class="bottomBtnR" onclick="customerInfo(${data.id})">查看</div>
                            <div class="bottomBtnR" onclick="getCRM(${data.id})">CRM视图</div>
                            <div class="bottomBtnR" onclick="assignManagerSingle(${data.id})">改派</div>
                        </c:when>
                        <c:otherwise>
                            <div class="bottomBtnR" onclick="getCRM(${data.id})">CRM视图</div>
                            <div class="bottomBtnR" onclick="assignManagerSingle(${data.id})">
                                派工
                            </div>
                        </c:otherwise>
                    </c:choose>
                </td>
            </tr>
        </c:forEach>
    </table>

    <c:choose>
        <c:when test="${'assigned' ne type}">
            <c:if test="${page.records>0}">
                <div class="row-fluid">
                    <div class="bottomBtnR" onclick="assignManager()">批量派工</div>
                    <div class="bottomBtnR" onclick="allAssignManager()">派工所有</div>
                </div>
            </c:if>
        </c:when>
        <c:when test="${'assigned' eq type}">
            <div class="row-fluid">
                <div class="bottomBtnR" onclick="assignManager()">批量改派</div>
            </div>
        </c:when>
    </c:choose>

    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script type="text/javascript">

    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    });

    function linkTypeUrl(type) {
        $("#type").val(type);
        $('#search_LIKE_phone').val('');
        $('#search_LIKE_signupSourceName').val('');
        $('#search_LIKE_managerName').val('');

        $('#filterForm').submit();
    }

    function assignManagerSingle(customerId) {
        $("#ck_" + customerId).prop("checked", true);
        $.ajax({
            url: '/house365-hgs-web/cloudcustomer/judgeCustomer/' + customerId,
            type: "GET",
            success: function (data) {
                if (data.status == 0) {
                    openAssignWindow(1, customerId);
                } else {
                    alert(data.errorMessage);
                }
            }
        });
    }

    function allAssignManager() {
        openAllAssignWindow("${page.records}");
    }

    function assignManager() {
        var customerIds = "",
            customerCont = 0;
        for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
            if (document.getElementsByName('memberCheck')[i].checked) {
                customerIds += document.getElementsByName('memberCheck')[i].value + ",";
                customerCont += 1;
            }
        }

        if (customerIds == '') {
            alert("请至少选择一个客户!");
            return false;
        }
        openAssignWindow(customerCont, customerIds);
    }

    function openAllAssignWindow(customerCont) {
        House365Util.createRemoteModal("客户派工", "/house365-hgs-web/customer/assignManager?multyassign=1&customerCount=" + customerCont, null, function () {
            var userIds = "";
            if ($("#custom-headers").find("option:selected").length == 0) {
                alert("分派人员不可为空!");
                return false;
            }

            $("#custom-headers").find("option:selected").each(function () {
                userIds = userIds + $(this).val() + ",";
            });

            $.ajax({
                url: '/house365-hgs-web/customer/assign',
                data: {
                    "userIds": userIds,
                    "actid": "${activity.id}",
                    "customerType": $("#type").val(),
                    "type": "cloudAll"
                },
                type: "GET",
                success: function (data) {
                    if (data.result == '1') {
                        alert(data.msg);
                        window.location.reload();
                    } else {
                        alert("操作失败，" + data.msg);
                    }
                }
            });
            return true;
        });
        $(".modal").css("width", "560px");
    }

    function openAssignWindow(customerCont, customerIds) {
        House365Util.createRemoteModal("客户派工", "/house365-hgs-web/customer/assignManager?multyassign=1&customerCount=" + customerCont, null, function () {
            var userIds = "";
            if ($("#custom-headers").find("option:selected").length == 0) {
                alert("分派人员不可为空!");
                return false;
            }

            $("#custom-headers").find("option:selected").each(function () {
                userIds = userIds + $(this).val() + ",";
            });

            if (customerIds == '') {
                alert("至少要选择一个客户!");
                return false;
            }

            $.ajax({
                url: '/house365-hgs-web/customer/assign',
                data: {
                    "userIds": userIds,
                    "customerIds": customerIds,
                    "type": "cloud"
                },
                type: "GET",
                success: function (data) {
                    if (data.result == '1') {
                        alert(data.msg);
                        window.location.reload();
                    } else {
                        alert("操作失败，" + data.msg);
                    }
                }
            });
            return true;
        });
        $(".modal").css("width", "560px");
    }

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    function getCRM(customerId) {
        $.ajax({
            url: '${ctx}/cloudcustomer/getCloudCrmUrl',
            data: {"customerId": customerId},
            type: "GET",
            success: function (data) {
                if (data.result == '1') {
                    if (data.data.entity == "") {
                        alert("该用户暂未推送至CRM");
                        return false;
                    }
                    window.open(data.data.entity);
                } else {
                    alert("操作失败，" + data.msg);
                }
            }
        });
    }

    function customerInfo(id) {
        $.ajax({
            url: '/house365-hgs-web/cloudcustomer/judgeCustomer/' + id,
            type: "GET",
            success: function (data) {
                debugger;
                if (data.status == 0) {
                    var customerId = data.data.customerId;
                    window.open("/house365-hgs-web/customer/customerInfo?action=edit&customerId=" + customerId, "_blank");
                } else if (data.status == 101) {
                    var customerId = data.data.customerId;
                    window.open("/house365-hgs-web/customer/seaCustomerInfo?action=edit&customerId=" + customerId, "_blank");
                } else {
                    alert(data.errorMessage);
                }
            }
        });
    }

</script>
</body>
</html>
