<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>云迹数据</title>
</head>
<body>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>客户管理
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>云迹数据
            </li>
        </ul>
    </div>
</div>

<div class="page-container">
    <div class="row${fluid}">
        <form id="filterForm" name="filterForm" class="form-inline filterForm"
              action="${ctx}/cloudactivity/list" method="get">

            <div style="margin-top:10px;">
                活动名称：<input type="text" id="search_name" style="border: 1px solid #d5d5d5;" name="search_name"
                            value="${param['search_name']}"
                            class="m-wrap small" placeholder="活动名称">&nbsp;&nbsp;&nbsp;&nbsp;
                <a class="btn" onclick="btnSubmit();">搜索</a>
            </div>
            <div style="margin-left: 90%">
                <shiro:hasPermission name="FUNC:CUSTOMCLOUD">
                    <button type="button" class="btn btn-default" onclick="showModalNew()">定制云迹数据</button>
                </shiro:hasPermission>
            </div>
        </form>

        <table class="table table-bordered table-advance table-hover">
            <tr class="info">
                <td width="100" style="text-align:center">序号</td>
                <td width="100" style="text-align:center">名称</td>
                <td width="100" style="text-align:center">总数</td>
                <td width="100" style="text-align:center">待派</td>
                <td width="100" style="text-align:center">已派</td>

                <td width="100" style="text-align:center">已跟进</td>
                <td width="100" style="text-align:center">回公海</td>
                <td width="100" style="text-align:center"> A/B意向数</td>
                <td width="100" style="text-align:center">约看数</td>
                <td width="100" style="text-align:center">到访数</td>
                <td width="100" style="text-align:center">认购数</td>
                <td width="100" style="text-align:center">签约数</td>
                <td width="100" style="text-align:center">创建人</td>
                <td width="100" style="text-align:center">创建时间</td>
                <td width="100" style="text-align:center">操作</td>
            </tr>
            <c:if test="${not empty dataList}">
                <c:forEach items="${dataList}" var="item" varStatus="i">
                    <tr>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${i.index+1}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.name}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.customerCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.waitCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.sentCount}
                        </td>

                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.backCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.seaCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.abCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.seeCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.daoCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.buyCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.signCount}
                        </td>

                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.createName}
                        </td>

                        <td nowrap="nowrap" style="text-align:center;">
                            <c:if test="${null ne item.createTime && '' ne item.createTime}">
                                <f:formatDate value='${item.createTime}'
                                              pattern='yyyy-MM-dd HH:mm:ss'/>
                            </c:if>
                            <c:if test="${null eq item.createTime || '' eq item.createTime}">
                                -
                            </c:if>
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                            <button onclick="geDetail(${item.id})">详情</button>
                        </td>
                    </tr>
                </c:forEach>
            </c:if>
            <c:if test="${ empty dataList}">
                <tr>
                    <td colspan="15" style="text-align: center">暂未找到与条件相关的数据，请重新搜索</td>
                </tr>
            </c:if>

        </table>
        <div class="row${fluid}">
            <house365:pagination page="${page}"/>
        </div>
    </div>

</div>

<link rel="stylesheet" href="${static_common }/script/bootstrap/css/bootstrap-multiselect.css" type="text/css">
<script type="text/javascript" src="${static_common }/script/bootstrap/js/bootstrap-multiselect.js"></script>

<!-- 模态框（Modal） -->
<div class="modal fade" id="cloudModal" tabindex="-1" role="dialog" aria-labelledby="cloudModalLabel"
     aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
                    &times;
                </button>
                <h4 class="modal-title" id="cloudModalLabel">
                    定制云迹
                </h4>
            </div>
            <div class="modal-body">
                <form class="form-inline ">
                    <div class="form-group">
                        <label>楼盘：</label>
                        <input type="text" class="form-control" id="houseName" style="width: 200px"
                               placeholder="">
                        <button type="button" class="btn btn-primary"
                                style="height: 25px;line-height: 13px;width: 80px" onclick="searchByName()">查询
                        </button>
                    </div>
                </form>
                <span>已选中楼盘</span>
                <table class="table table-bordered table-hover user_table">
                    <thead>
                    <tr class="col_f5f5f5">
                        <th><input type="checkbox"/></th>
                        <th>楼盘名称</th>
                    </tr>
                    </thead>
                    <tbody id="houseHtml">
                    </tbody>
                </table>
                <span>查询楼盘</span>
                <table class="table table-bordered table-hover user_table">
                    <thead>
                    <tr class="col_f5f5f5">
                        <th><input type="checkbox" onclick="checkAll(this)"/></th>
                        <th>楼盘名称</th>
                    </tr>
                    </thead>
                    <tbody id="houseNameHtml">

                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default close_model" data-dismiss="modal">关闭
                </button>
                <button type="button" class="btn btn-primary" onclick="addHouse()">
                    添加
                </button>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">

    function btnSubmit() {
        $('#filterForm').submit();
    }

    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    });

    function geDetail(id) {
        window.open("/house365-hgs-web/cloudcustomer/list/" + id, "_blank");
    }

    var showModalNew = function () {
        var htmlNew = "";
        $.ajax({
            url: '${ctx}/cloudactivity/getList',
            type: 'POST',
            contentType: 'application/json',
            data: {},
            dataType: 'json',
            cache: false,
            success: function (data) {
                if (data.status == 0) {
                    houseArray = data.data;
                    var houseHtml = "";
                    for (var i = 0; i < data.data.length; i++) {
                        var house = data.data[i];
                        houseHtml += '<tr>';
                        var value = house.houseName;
                        houseHtml += "<td>" + "<button type='button' class='delete btn btn-primary' value='" + value + "'>" + "删除" + "</button>" + "</td>";
                        houseHtml += "<td>" + house.houseName + "</td>";
                        houseHtml += "</tr>";
                    }
                    $("#houseHtml").html(houseHtml);
                } else {
                    alert(data.errorMessage);
                }
            }
        });
        $("#houseNameHtml").html(htmlNew);
        $("#cloudModal").modal('show');
    };

    var checkNum = 0;
    function checkAll(btn) {
        var that = btn;
        if (btn.checked) {
            for (var i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                checkNum++;
                document.getElementsByName('memberCheck')[i].checked = "checked";
                var con = $(that).parent().parent().parent().next().children().children().find("input").eq(i).attr("value")
                var str = "<tr><td><button type='button' class='delete btn btn-primary' value='" + con + "'>" + "删除" + "</button></td><td>" + con + "</td></tr>";
                $("#houseHtml").append(str)
            }
        } else {
            for (var i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                checkNum++;
                document.getElementsByName('memberCheck')[i].checked = "";
            }
        }
    }

    var houseArray = [];
    var houseNameArray = [];
    var addHouseArray = [];
    var searchByName = function () {
        var houseName = $("#houseName").val();
        if (typeof(houseName) == "undefined" || houseName == '' || houseName == null) {
            alert("请填写楼盘名");
            return;
        }
        var data = {
            customerName: houseName
        };
        data = JSON.stringify(data);
        $.ajax({
            url: '${ctx}/cloudactivity/searchHouse',
            type: 'POST',
            contentType: 'application/json',
            data: data,
            dataType: 'json',
            cache: false,
            success: function (data) {
                if (data.status == 0) {
                    houseNameArray = data.data;
                    var houseNameHtml = "";
                    for (var i = 0; i < data.data.length; i++) {
                        var house = data.data[i];
                        houseNameHtml += '<tr>';
                        var value = house.houseName;
                        houseNameHtml += "<td>" + "<input type='checkbox' name='memberCheck' class='selectChose' value='" + value + "'>" + "</td>";
                        houseNameHtml += "<td>" + house.houseName + "</td>";
                        houseNameHtml += "</tr>";
                    }
                    $("#houseNameHtml").html(houseNameHtml);
                } else {
                    alert(data.errorMessage);
                }
            }
        });
    };

    $(document).on('click', '.delete', function () {
        $(this).parent().parent().remove()
    });

    $(document).on('click', '.selectChose', function () {
        var that = $(this);
        var check = that.prop("checked") == true;
        if (check) {
            that.parent().attr("checked", true);
            var con = that.parent().next().html();
            var str = "<tr><td><button type='button' class='delete btn btn-primary' value='" + con + "'>" + "删除" + "</button></td><td>" + con + "</td></tr>";
            $("#houseHtml").append(str)
        }
    });

    var addHouse = function () {
        var ss = $(".delete").length;
        var list = [];
        for (var i = 0; i < ss; i++) {
            var but = $(".delete").eq(i).val()
            var house = [];
            house = but.split("-");
            var ruleEntity = {
                projectId: '',
                projectName: '',
                channelName: '',
                channel: ''
            };
            ruleEntity.projectId = parseInt(house[2]);
            ruleEntity.projectName = house[0];
            ruleEntity.channel = parseInt(house[3]);
            ruleEntity.channelName = house[1];
            list.push(ruleEntity);
        }

        var data = {
            list: list
        };
        data = JSON.stringify(data);
        $.ajax({
            url: '${ctx}/cloudactivity/addRule',
            type: 'POST',
            contentType: 'application/json',
            data: data,
            dataType: 'json',
            cache: false,
            success: function (result) {
                if (result.status == 0) {
                    alert("定制规则成功！");
                    addHouseArray = [];
                    window.location.reload();
                } else {
                    addHouseArray = [];
                    alert(result.errorMessage);
                }
            }
        });
    };

</script>
</body>
</html>
