/**
 * Description: 账户页面表单对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-14 下午 17:27:22
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.vo;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import com.house365.beans.entity.UserEntity;

/**
 * 账户页面表单对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
public class UserVo {
    /**
     * 账户实体
     */
    @NotNull
    @Valid
    private UserEntity entity;


    /**
     * 设置账户实体
     * @param entity 账户实体
     */
    public void setEntity(UserEntity entity) {
        this.entity = entity;
    }

    /**
     * 获取账户实体
     * @return 账户实体
     */
    public UserEntity getEntity() {
        return this.entity;
    }

    /**
     * 名下是否有客户
     */
    private boolean hasCustomers = false;

    public boolean isHasCustomers() {
        return hasCustomers;
    }

    public void setHasCustomers(boolean hasCustomers) {
        this.hasCustomers = hasCustomers;
    }
}
