/**
 * Description: 客户项目信息页面表单对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-15 下午 15:36:18
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.vo;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import com.house365.beans.entity.CustomerProjectEntity;

/**
 * 客户项目信息页面表单对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-15
 * @see
 * @since 1.0
 */
public class CustomerProjectVo {
    /**
     * 客户项目信息实体
     */
    @NotNull
    @Valid
    private CustomerProjectEntity entity;


    /**
     * 设置客户项目信息实体
     * @param entity 客户项目信息实体
     */
    public void setEntity(CustomerProjectEntity entity) {
        this.entity = entity;
    }

    /**
     * 获取客户项目信息实体
     * @return 客户项目信息实体
     */
    public CustomerProjectEntity getEntity() {
        return this.entity;
    }
}
